/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers;

import fr.toutatice.portail.cms.nuxeo.api.ContextualizationHelper;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoCompatibility;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.PageSelectors;
import fr.toutatice.portail.cms.nuxeo.api.cms.LockStatus;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoPermissions;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoPublicationInfos;
import fr.toutatice.portail.cms.nuxeo.api.cms.QuickAccessStatus;
import fr.toutatice.portail.cms.nuxeo.api.cms.SubscriptionStatus;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoConnectionProperties;
import fr.toutatice.portail.cms.nuxeo.portlets.cms.ExtendedDocumentInfos;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.DefaultCMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.BrowserAdapter;
import fr.toutatice.portail.cms.nuxeo.portlets.document.helpers.DocumentHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.WindowState;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.core.model.portal.PortalObject;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cms.DocumentContext;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.contribution.IContributionService;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.directory.v2.service.PersonService;
import org.osivia.portal.api.html.AccessibilityRoles;
import org.osivia.portal.api.html.DOM4JUtils;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.menubar.IMenubarService;
import org.osivia.portal.api.menubar.MenubarContainer;
import org.osivia.portal.api.menubar.MenubarDropdown;
import org.osivia.portal.api.menubar.MenubarGroup;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.menubar.MenubarModule;
import org.osivia.portal.api.portalobject.bridge.PortalObjectUtils;
import org.osivia.portal.api.taskbar.ITaskbarService;
import org.osivia.portal.api.taskbar.TaskbarItem;
import org.osivia.portal.api.taskbar.TaskbarItems;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.urls.PortalUrlType;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.ICMSServiceLocator;

public class MenuBarFormater {
    private final Log log = LogFactory.getLog(this.getClass());
    private final IMenubarService menubarService = (IMenubarService)Locator.findMBean(IMenubarService.class, (String)"osivia:service=MenubarService");
    private final ICMSServiceLocator cmsServiceLocator = (ICMSServiceLocator)Locator.findMBean(ICMSServiceLocator.class, (String)"osivia:service=CmsServiceLocator");
    private final IPortalUrlFactory portalUrlFactory = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");
    private final DefaultCMSCustomizer customizer;
    private final IContributionService contributionService;
    private final ITaskbarService taskbarService;
    private final IBundleFactory bundleFactory;

    public MenuBarFormater(DefaultCMSCustomizer customizer) {
        this.customizer = customizer;
        this.contributionService = (IContributionService)Locator.findMBean(IContributionService.class, (String)"osivia:service=ContributionService");
        this.taskbarService = (ITaskbarService)Locator.getService(ITaskbarService.class);
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.getService(IInternationalizationService.class);
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    public void formatDefaultContentMenuBar(CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, ExtendedDocumentInfos extendedInfos) throws CMSException, PortalException {
        NuxeoDocumentContext documentContext;
        List menubar;
        PortalControllerContext portalControllerContext;
        block21: {
            String path;
            ICMSService cmsService = this.cmsServiceLocator.getCMSService();
            PortletRequest request = cmsContext.getRequest();
            portalControllerContext = new PortalControllerContext(cmsContext.getPortletCtx(), request, (PortletResponse)cmsContext.getResponse());
            Bundle bundle = this.bundleFactory.getBundle(cmsContext.getRequest().getLocale());
            Portal portal = PortalObjectUtils.getPortal((PortalControllerContext)cmsContext.getPortalControllerContext());
            menubar = (List)request.getAttribute("osivia.menuBar");
            if (cmsContext.getDoc() != null) {
                Document document = (Document)cmsContext.getDoc();
                path = document.getPath();
            } else {
                path = cmsContext.getCreationPath();
            }
            if (path == null) {
                documentContext = null;
            } else {
                documentContext = (NuxeoDocumentContext)cmsService.getDocumentContext(cmsContext, path, NuxeoDocumentContext.class);
                Document document = documentContext.getDocument();
                boolean webPageFragment = false;
                if (PortalObjectUtils.isSpaceSite((PortalObject)portal) && cmsContext.getDoc() != null) {
                    String webPagePath = (String)request.getAttribute("osivia.cms.webPagePath");
                    String docLivePath = ContextualizationHelper.getLivePath((String)((Document)cmsContext.getDoc()).getPath());
                    if (StringUtils.equals((String)docLivePath, (String)webPagePath)) {
                        webPageFragment = true;
                    }
                }
                if (!pubInfos.getSatellite().isMain()) {
                    return;
                }
                boolean isGlobalAdministrator = BooleanUtils.isTrue((Boolean)((Boolean)request.getAttribute("osivia.isAdministrator")));
                boolean isWorkspaceOrRoom = this.isWorkspaceOrRoom(document);
                boolean insideUserWorkspace = this.isInUserWorkspace(cmsContext, document);
                boolean isTaskbarItem = !isWorkspaceOrRoom && this.isTaskbarItem(portalControllerContext, cmsContext, documentContext);
                boolean isWorkspaceAdmin = (isWorkspaceOrRoom || isTaskbarItem) && this.isWorkspaceAdmin(cmsContext, documentContext);
                Document sharingRoot = this.getSharingRoot(cmsContext);
                try {
                    DocumentType documentType = this.customizer.getCMSItemTypes().get(document.getType());
                    this.addCMSEditionDropdown(portalControllerContext, documentType, bundle);
                    this.addShareDropdown(portalControllerContext, documentType, bundle);
                    this.addOtherOptionsDropdown(portalControllerContext, documentType, bundle);
                    this.getCreateLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle, !isWorkspaceOrRoom);
                    if (!webPageFragment) {
                        this.getContextualizationLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle);
                        if (!insideUserWorkspace && sharingRoot == null) {
                            this.getPermaLinkLink(portalControllerContext, cmsContext, pubInfos, extendedInfos, menubar, bundle);
                        }
                        if (ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext)) {
                            this.addDraftLinks(portalControllerContext, cmsContext, pubInfos, extendedInfos, menubar, bundle);
                            if (!isWorkspaceOrRoom) {
                                if (!isTaskbarItem || isWorkspaceAdmin) {
                                    this.getReorderLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle);
                                    this.getEditLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle);
                                    this.getDeleteLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle);
                                }
                                if (!isTaskbarItem) {
                                    this.getChangeModeLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle, extendedInfos);
                                }
                            }
                            if (!isTaskbarItem) {
                                this.getMoveLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle, isTaskbarItem);
                            }
                            this.getLiveContentBrowserLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle);
                            this.getSynchronizeLink(portalControllerContext, cmsContext, menubar, bundle, extendedInfos);
                            this.getAdministrationLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle, isGlobalAdministrator);
                            if (!insideUserWorkspace) {
                                this.getSubscribeLink(portalControllerContext, cmsContext, menubar, bundle, extendedInfos);
                                if (!isWorkspaceOrRoom) {
                                    this.getQuickAccesLink(portalControllerContext, cmsContext, menubar, bundle, extendedInfos);
                                }
                                if (!isWorkspaceOrRoom) {
                                    this.getQuickAccesLink(portalControllerContext, cmsContext, menubar, bundle, extendedInfos);
                                }
                                if (!isWorkspaceOrRoom && !isTaskbarItem) {
                                    this.getLockLink(portalControllerContext, cmsContext, menubar, bundle, extendedInfos);
                                    this.getValidationWfLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle, extendedInfos);
                                    this.getRemotePublishingLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle, extendedInfos);
                                }
                            }
                        }
                    }
                }
                catch (CMSException e) {
                    if (e.getErrorCode() == 1 || e.getErrorCode() == 3) break block21;
                    throw e;
                }
            }
        }
        List<MenubarModule> modules = this.customizer.getPluginManager().customizeMenubarModules();
        for (MenubarModule module : modules) {
            module.customizeDocument(portalControllerContext, menubar, (DocumentContext)documentContext);
        }
    }

    protected boolean isWorkspaceOrRoom(Document document) {
        String type = document.getType();
        return "Workspace".equals(type) || "Room".equals(type);
    }

    protected boolean isInUserWorkspace(CMSServiceCtx cmsContext, Document document) throws CMSException {
        BrowserAdapter browserAdapter = this.customizer.getBrowserAdapter();
        boolean userWorkspace = false;
        if (document != null) {
            String path = document.getPath() + "/";
            List<CMSItem> userWorkspaces = browserAdapter.getAllUserWorkspaces(cmsContext);
            Iterator<CMSItem> iterator = userWorkspaces.iterator();
            while (iterator.hasNext() && !userWorkspace) {
                CMSItem cmsItem = iterator.next();
                userWorkspace = StringUtils.startsWith((String)path, (String)(cmsItem.getNavigationPath() + "/"));
            }
        }
        return userWorkspace;
    }

    protected boolean isTaskbarItem(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, NuxeoDocumentContext documentContext) throws CMSException, PortalException {
        boolean taskbarItem;
        String parentPath;
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        Document document = documentContext.getDocument();
        NuxeoPublicationInfos publicationInfos = documentContext.getPublicationInfos();
        String basePath = publicationInfos.getSpacePath();
        if (StringUtils.equals((String)basePath, (String)(parentPath = StringUtils.substringBeforeLast((String)document.getPath(), (String)"/")))) {
            String prefix;
            CMSItem spaceConfig = cmsService.getSpaceConfig(cmsContext, basePath);
            Document space = (Document)spaceConfig.getNativeItem();
            String shortname = space.getString("webc:url");
            String webId = document.getString("ttc:webid");
            if (StringUtils.startsWith((String)webId, (String)(prefix = "workspace_" + shortname + "_"))) {
                String taskId = StringUtils.upperCase((String)StringUtils.removeStart((String)webId, (String)prefix));
                TaskbarItems items = this.taskbarService.getItems(portalControllerContext);
                TaskbarItem item = items.get(taskId);
                taskbarItem = item != null && !item.isHidden();
            } else {
                taskbarItem = false;
            }
        } else {
            taskbarItem = false;
        }
        return taskbarItem;
    }

    protected boolean isWorkspaceAdmin(CMSServiceCtx cmsContext, NuxeoDocumentContext documentContext) throws CMSException {
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        NuxeoPublicationInfos publicationInfos = documentContext.getPublicationInfos();
        String basePath = publicationInfos.getSpacePath();
        NuxeoDocumentContext workspaceDocumentContext = StringUtils.equals((String)basePath, (String)publicationInfos.getPath()) ? documentContext : (NuxeoDocumentContext)cmsService.getDocumentContext(cmsContext, basePath, NuxeoDocumentContext.class);
        NuxeoPermissions permissions = workspaceDocumentContext.getPermissions();
        return permissions.isManageable();
    }

    protected Document getSharingRoot(CMSServiceCtx cmsContext) throws CMSException {
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        CMSItem cmsItem = cmsService.getSharingRoot(cmsContext);
        Document document = cmsItem != null && cmsItem.getNativeItem() != null && cmsItem.getNativeItem() instanceof Document ? (Document)cmsItem.getNativeItem() : null;
        return document;
    }

    public void formatContentMenuBar(CMSServiceCtx cmsCtx, CMSPublicationInfos publicationInfos, ExtendedDocumentInfos extendedDocumentInfos) throws Exception {
        this.formatDefaultContentMenuBar(cmsCtx, publicationInfos, extendedDocumentInfos);
    }

    public boolean hasWebId(CMSServiceCtx cmsCtx) {
        boolean has = false;
        Document document = (Document)cmsCtx.getDoc();
        if (document != null) {
            String webid = document.getString("ttc:webid");
            has = StringUtils.isNotBlank((String)webid);
        }
        return has;
    }

    public void addCMSEditionDropdown(PortalControllerContext portalControllerContext, DocumentType type, Bundle bundle) {
        MenubarDropdown dropdown = new MenubarDropdown("CMS_EDITION", bundle.getString("CMS_EDITION"), "glyphicons glyphicons-basic-pencil", MenubarGroup.CMS, 6, false, false);
        dropdown.setBreadcrumb(true);
        this.menubarService.addDropdown(portalControllerContext, dropdown);
    }

    public void addShareDropdown(PortalControllerContext portalControllerContext, DocumentType type, Bundle bundle) {
        MenubarDropdown dropdown = new MenubarDropdown("SHARE", bundle.getString("SHARE"), "glyphicons glyphicons-basic-share", MenubarGroup.GENERIC, 8);
        dropdown.setBreadcrumb(true);
        this.menubarService.addDropdown(portalControllerContext, dropdown);
    }

    public void addOtherOptionsDropdown(PortalControllerContext portalControllerContext, DocumentType type, Bundle bundle) {
        MenubarDropdown dropdown = new MenubarDropdown("OTHER_OPTIONS", bundle.getString("OTHER_OPTIONS"), "glyphicons glyphicons-basic-more-vertical", MenubarGroup.GENERIC, 40, false, false);
        dropdown.setBreadcrumb(true);
        this.menubarService.addDropdown(portalControllerContext, dropdown);
    }

    protected void getAdministrationLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle, boolean isGlobalAdministrator) throws CMSException {
        if (cmsContext.getRequest().getRemoteUser() == null) {
            return;
        }
        if (DocumentHelper.isRemoteProxy(cmsContext, pubInfos)) {
            return;
        }
        if (!pubInfos.isDraft()) {
            String url = NuxeoConnectionProperties.getPublicBaseUri().toString() + "/nxdoc/default/" + pubInfos.getLiveId() + "/view_documents";
            MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "OTHER_OPTIONS");
            MenubarItem item = new MenubarItem("MANAGE", bundle.getString("MANAGE_IN_NUXEO"), null, (MenubarContainer)parent, 21, url, "nuxeo", null, null);
            item.setAjaxDisabled(true);
            item.setDivider(true);
            item.setVisible(isGlobalAdministrator);
            menubar.add(item);
        }
    }

    protected void addDraftLinks(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, ExtendedDocumentInfos extendedInfos, List<MenubarItem> menubar, Bundle bundle) {
        Document document = (Document)cmsContext.getDoc();
        if (DocumentHelper.isLeaf(document)) {
            MenubarDropdown dropdown = this.menubarService.getDropdown(portalControllerContext, "CMS_EDITION");
            int order = 1;
            if (pubInfos.isDraft()) {
                MenubarItem indicator = new MenubarItem("DRAFT", bundle.getString("DRAFT"), (MenubarContainer)MenubarGroup.CMS, -12, "badge badge-info");
                indicator.setState(true);
                menubar.add(indicator);
                if (pubInfos.isNotOrphanDraft()) {
                    String webId = DocumentHelper.getCheckinedWebIdFromDraft(document);
                    String path = NuxeoController.webIdToCmsPath((String)webId);
                    String url = this.portalUrlFactory.getCMSUrl(portalControllerContext, null, path, null, null, null, null, null, null, null);
                    MenubarItem item = new MenubarItem("GO_TO_DRAFT_SOURCE", bundle.getString("GO_TO_DRAFT_SOURCE"), "glyphicons glyphicons-basic-undo", (MenubarContainer)dropdown, order, url, null, null, null);
                    item.setAjaxDisabled(true);
                    menubar.add(item);
                }
            } else if (pubInfos.hasDraft()) {
                String path = pubInfos.getDraftPath();
                String url = this.portalUrlFactory.getCMSUrl(portalControllerContext, null, path, null, null, null, null, null, null, null);
                MenubarItem item = new MenubarItem("GO_TO_DRAFT", bundle.getString("GO_TO_DRAFT"), "glyphicons glyphicons-basic-redo", (MenubarContainer)dropdown, order, url, null, null, null);
                item.setAjaxDisabled(true);
                menubar.add(item);
            }
        } else if (extendedInfos.getDraftCount() > 0) {
            String url;
            String webId = DocumentHelper.getWebId(document);
            HashMap<String, String> properties = new HashMap<String, String>(1);
            properties.put("osivia.drafts.folderWebId", webId);
            try {
                url = this.portalUrlFactory.getStartPortletUrl(portalControllerContext, "toutatice-portail-cms-nuxeo-viewDraftsListPortletInstance", properties, PortalUrlType.MODAL);
            }
            catch (PortalException e) {
                url = "#";
            }
            String title = bundle.getString("DRAFTS_LIST");
            MenubarItem item = new MenubarItem("DRAFTS_LIST", title, "glyphicons glyphicons-basic-construction-cone", (MenubarContainer)MenubarGroup.CMS, 4, "#", null, null, null);
            item.getData().put("target", "#osivia-modal");
            item.getData().put("load-url", url);
            item.getData().put("title", title);
            item.getData().put("footer", String.valueOf(true));
            item.setCounter(Integer.valueOf(extendedInfos.getDraftCount()));
            menubar.add(item);
        }
    }

    protected void getChangeModeLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle, ExtendedDocumentInfos extendedInfos) throws CMSException, PortalException {
    }

    protected void addValidatePublishingItems(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, MenubarContainer parent, Bundle bundle) throws CMSException {
        String validateURL = this.contributionService.getValidatePublishContributionURL(portalControllerContext, pubInfos.getDocumentPath());
        MenubarItem validateItem = new MenubarItem("ONLINE_WF_VALIDATE", bundle.getString("VALIDATE_PUBLISH"), "glyphicons glyphicons-basic-circle-check", parent, 13, validateURL, null, null, null);
        validateItem.setAjaxDisabled(true);
        menubar.add(validateItem);
        String rejectURL = this.contributionService.getRejectPublishContributionURL(portalControllerContext, pubInfos.getDocumentPath());
        MenubarItem rejectItem = new MenubarItem("ONLINE_WF_REJECT", bundle.getString("REJECT_PUBLISH"), "glyphicons glyphicons-basic-circle-remove", parent, 14, rejectURL, null, null, null);
        rejectItem.setAjaxDisabled(true);
        menubar.add(rejectItem);
    }

    protected void getLiveContentBrowserLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle) throws CMSException {
        boolean folderish;
        String navigationPath;
        if (cmsContext.getRequest().getRemoteUser() == null) {
            return;
        }
        if (DocumentHelper.isRemoteProxy(cmsContext, pubInfos)) {
            return;
        }
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext.getRequest(), portalControllerContext.getResponse(), portalControllerContext.getPortletCtx());
        Document document = (Document)cmsContext.getDoc();
        if (document == null) {
            navigationPath = cmsContext.getCreationPath();
            Object cmsItemType = null;
            folderish = navigationPath != null;
        } else {
            navigationPath = nuxeoController.getContentPath();
            DocumentType cmsItemType = this.customizer.getCMSItemTypes().get(document.getType());
            boolean bl = folderish = cmsItemType != null && cmsItemType.isFolderish();
        }
        if (!pubInfos.isLiveSpace() && !pubInfos.getSubTypes().isEmpty() && folderish) {
            String browserURL;
            Portal portal = PortalObjectUtils.getPortal((PortalControllerContext)cmsContext.getPortalControllerContext());
            boolean spaceSite = PortalObjectUtils.isSpaceSite((PortalObject)portal);
            try {
                HashMap<String, String> properties = new HashMap<String, String>(1);
                properties.put("osivia.browser.basePath", nuxeoController.getBasePath());
                properties.put("osivia.browser.navigationPath", navigationPath);
                properties.put("osivia.browser.space", String.valueOf(spaceSite));
                browserURL = this.portalUrlFactory.getStartPortletUrl(portalControllerContext, "osivia-portal-browser-portlet-instance", properties, PortalUrlType.POPUP);
            }
            catch (PortalException e) {
                browserURL = "#";
            }
            MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "CMS_EDITION");
            MenubarItem browserItem = new MenubarItem("BROWSE_LIVE_CONTENT", bundle.getString("BROWSE_LIVE_CONTENT"), "glyphicons glyphicons-basic-book-open", (MenubarContainer)parent, 50, browserURL, null, null, "fancyframe_refresh");
            browserItem.setAjaxDisabled(true);
            browserItem.setDivider(true);
            menubar.add(browserItem);
        }
    }

    protected void getSynchronizeLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, List<MenubarItem> menubar, Bundle bundle, ExtendedDocumentInfos extendedInfos) throws CMSException {
        if (cmsContext.getRequest().getRemoteUser() == null) {
            return;
        }
        Document document = (Document)cmsContext.getDoc();
        String path = document.getPath();
        Object command = null;
        Object icon = null;
        if (!extendedInfos.isCanSynchronize() && extendedInfos.isCanUnsynchronize()) {
            MenubarItem synchronizedIndicator = new MenubarItem("SYNCHRONIZED", null, (MenubarContainer)MenubarGroup.CMS, -2, "badge badge-success");
            synchronizedIndicator.setGlyphicon("glyphicons glyphicons-basic-sync");
            synchronizedIndicator.setTooltip(bundle.getString("SYNCHRONIZED"));
            synchronizedIndicator.setState(true);
            menubar.add(synchronizedIndicator);
        }
        MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "OTHER_OPTIONS");
        if (command == null && extendedInfos.getSynchronizationRootPath() != null) {
            String rootURL = this.portalUrlFactory.getCMSUrl(portalControllerContext, null, extendedInfos.getSynchronizationRootPath(), null, null, null, null, null, null, null);
            MenubarItem rootURLItem = new MenubarItem("SYNCHRO_ROOT_URL", bundle.getString("SYNCHRO_ROOT_URL"), null, (MenubarContainer)parent, 12, rootURL, null, null, null);
            rootURLItem.setAjaxDisabled(true);
            rootURLItem.setDivider(true);
            menubar.add(rootURLItem);
        }
    }

    protected void getSubscribeLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, List<MenubarItem> menubar, Bundle bundle, ExtendedDocumentInfos extendedInfos) throws CMSException {
        if (cmsContext.getRequest().getRemoteUser() != null) {
            SubscriptionStatus subscriptionStatus;
            Document document = (Document)cmsContext.getDoc();
            String path = document.getPath();
            if (!"Staple".equals(document.getType()) && !DocumentHelper.hasDraft(document) && (subscriptionStatus = extendedInfos.getSubscriptionStatus()) != null && subscriptionStatus != SubscriptionStatus.NO_SUBSCRIPTIONS) {
                String url = "";
                try {
                    MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "OTHER_OPTIONS");
                    MenubarItem subscribeItem = new MenubarItem("SUBSCRIBE_URL", null, null, (MenubarContainer)parent, 11, url, null, null, null);
                    subscribeItem.setAjaxDisabled(true);
                    subscribeItem.setDivider(true);
                    if (subscriptionStatus != SubscriptionStatus.CAN_SUBSCRIBE && subscriptionStatus != SubscriptionStatus.CAN_UNSUBSCRIBE && subscriptionStatus == SubscriptionStatus.HAS_INHERITED_SUBSCRIPTIONS) {
                        subscribeItem.setUrl("#");
                        subscribeItem.setGlyphicon("glyphicons glyphicons-basic-flag");
                        subscribeItem.setTitle(bundle.getString("INHERITED_SUBSCRIPTION"));
                        subscribeItem.setDisabled(true);
                    }
                    menubar.add(subscribeItem);
                }
                catch (Exception ex) {
                    this.log.warn((Object)ex.getMessage());
                }
            }
        }
    }

    protected void getQuickAccesLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, List<MenubarItem> menubar, Bundle bundle, ExtendedDocumentInfos extendedInfos) throws CMSException {
        Document document = (Document)cmsContext.getDoc();
        String path = document.getPath();
        QuickAccessStatus quickAccessStatus = extendedInfos.getQuickAccessStatus();
        if (quickAccessStatus != null && quickAccessStatus != QuickAccessStatus.CANNOT_ADD_TO_QUICKACCESS) {
            String url = "";
            try {
                MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "OTHER_OPTIONS");
                MenubarItem item = new MenubarItem("QUICKACCESS_URL", null, null, (MenubarContainer)parent, 15, url, null, null, null);
                item.setAjaxDisabled(true);
                if (quickAccessStatus == QuickAccessStatus.CAN_ADD_TO_QUICKACCESS || quickAccessStatus == QuickAccessStatus.CAN_REMOVE_FROM_QUICKACCESS) {
                    // empty if block
                }
                menubar.add(item);
            }
            catch (Exception ex) {
                this.log.warn((Object)ex.getMessage());
            }
        }
    }

    private void getLockLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, List<MenubarItem> menubar, Bundle bundle, ExtendedDocumentInfos extendedInfos) {
        Document document = (Document)cmsContext.getDoc();
        String path = document.getPath();
        LockStatus lockStatus = extendedInfos.getLockStatus();
        if (lockStatus != null && lockStatus != LockStatus.NO_LOCK) {
            String url = "";
            try {
                MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "OTHER_OPTIONS");
                MenubarItem lockItem = new MenubarItem("LOCK_URL", null, null, (MenubarContainer)parent, 14, url, null, null, null);
                lockItem.setAjaxDisabled(true);
                if (lockStatus != LockStatus.CAN_LOCK) {
                    if (lockStatus == LockStatus.CAN_UNLOCK) {
                        menubar.add(this.makeLockedIndicator(cmsContext, bundle, extendedInfos));
                    } else if (lockStatus == LockStatus.LOCKED) {
                        lockItem.setUrl("#");
                        lockItem.setGlyphicon("glyphicons glyphicons-basic-lock");
                        lockItem.setTitle(bundle.getString("INHERITED_LOCK"));
                        lockItem.setDisabled(true);
                        menubar.add(this.makeLockedIndicator(cmsContext, bundle, extendedInfos));
                    }
                }
                menubar.add(lockItem);
            }
            catch (Exception ex) {
                this.log.warn((Object)ex.getMessage());
            }
        }
    }

    protected MenubarItem makeLockedIndicator(CMSServiceCtx cmsContext, Bundle bundle, ExtendedDocumentInfos extendedInfos) {
        MenubarItem lockedIndicator = new MenubarItem("LOCKED", null, (MenubarContainer)MenubarGroup.CMS, -1, "badge badge-warning");
        lockedIndicator.setGlyphicon("glyphicons glyphicons-basic-lock");
        String displayName = this.getUserDisplayName(extendedInfos);
        Object[] args = new Object[]{displayName};
        String tooltip = bundle.getString("LOCKED_BY", args);
        lockedIndicator.setTooltip(tooltip);
        lockedIndicator.setState(true);
        String currentUser = cmsContext.getRequest().getRemoteUser();
        boolean currentUserIsOwner = StringUtils.equals((String)currentUser, (String)extendedInfos.getLockOwner());
        if (currentUserIsOwner) {
            lockedIndicator.setGlyphicon("glyphicons glyphicons-basic-user-lock");
            lockedIndicator.setTooltip(bundle.getString("LOCKED"));
        }
        return lockedIndicator;
    }

    protected String getUserDisplayName(ExtendedDocumentInfos extendedInfos) {
        PersonService personService = (PersonService)DirServiceFactory.getService(PersonService.class);
        Person person = personService.getPerson(extendedInfos.getLockOwner());
        String displayName = person != null && StringUtils.isNotBlank((String)person.getDisplayName()) ? person.getDisplayName() : extendedInfos.getLockOwner();
        return displayName;
    }

    protected void getValidationWfLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle, ExtendedDocumentInfos extendedInfos) throws CMSException {
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        Document document = (Document)cmsContext.getDoc();
        if (!DocumentHelper.isFolder(document) && !"Staple".equals(document.getType()) && pubInfos.isLiveSpace() && !pubInfos.hasDraft()) {
            boolean isValidationWfRunning = extendedInfos.isValidationWorkflowRunning();
            MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "CMS_EDITION");
            MenubarItem item = new MenubarItem("VALIDATION_WF_URL", null, null, (MenubarContainer)parent, 13, null, null, null, "fancyframe_refresh");
            String onClick = this.generateCallbackParams(portalControllerContext, cmsContext);
            item.setOnclick(onClick);
            if (BooleanUtils.isTrue((Boolean)isValidationWfRunning) || "approved".equals(document.getState()) || pubInfos.isEditableByUser()) {
                // empty if block
            }
        }
    }

    private String generateCallbackParams(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext) {
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        String callbackURL = this.portalUrlFactory.getCMSUrl(portalControllerContext, null, "_NEWID_", null, null, "_LIVE_", null, null, null, null);
        String ecmBaseURL = cmsService.getEcmDomain(cmsContext);
        StringBuilder onClick = new StringBuilder();
        onClick.append("javascript:setCallbackFromEcmParams('");
        onClick.append(callbackURL);
        onClick.append("', '");
        onClick.append(ecmBaseURL);
        onClick.append("');");
        return onClick.toString();
    }

    protected void getRemotePublishingLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle, ExtendedDocumentInfos extendedInfos) throws CMSException {
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        Document document = (Document)cmsContext.getDoc();
        if (!DocumentHelper.isFolder(document)) {
            boolean isDraftActivated;
            boolean bl = isDraftActivated = pubInfos.hasDraft() || pubInfos.isDraft();
            if (!isDraftActivated && pubInfos.isRemotePublishable() && pubInfos.isLiveSpace()) {
                String url = "#";
                MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "CMS_EDITION");
                MenubarItem remotePubItem = new MenubarItem("REMOTE_PUBLISHING_URL", bundle.getString("REMOTE_PUBLISHING"), null, (MenubarContainer)parent, 14, "#", null, null, null);
                Boolean isValidationWfRunning = extendedInfos.isValidationWorkflowRunning();
                if (!BooleanUtils.isFalse((Boolean)isValidationWfRunning)) {
                    remotePubItem.setDisabled(true);
                    menubar.add(remotePubItem);
                }
            }
        }
    }

    protected void getRenameLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle) {
        if (DocumentHelper.isRemoteProxy(cmsContext, pubInfos)) {
            return;
        }
        if (pubInfos.isEditableByUser()) {
            Document document = (Document)cmsContext.getDoc();
            HashMap<String, String> windowProperties = new HashMap<String, String>(1);
            windowProperties.put("osivia.cms.uri", document.getPath());
            String renameDocumentUrl = null;
            Object refreshUrl = null;
            try {
                renameDocumentUrl = this.portalUrlFactory.getStartPortletUrl(portalControllerContext, "toutatice-portail-cms-nuxeo-rename-portlet-instance", windowProperties, PortalUrlType.MODAL);
            }
            catch (PortalException portalException) {
                // empty catch block
            }
            if (renameDocumentUrl != null || refreshUrl == null) {
                MenubarDropdown editionDropdown = this.menubarService.getDropdown(portalControllerContext, "CMS_EDITION");
                MenubarItem renameMenubarItem = new MenubarItem("RENAME", bundle.getString("RENAME"), "glyphicons glyphicons-basic-square-edit", (MenubarContainer)editionDropdown, 0, "#", null, null, null);
                renameMenubarItem.getData().put("target", "#osivia-modal");
                renameMenubarItem.getData().put("load-url", renameDocumentUrl);
                renameMenubarItem.getData().put("title", bundle.getString("RENAME_DOCUMENT"));
                menubar.add(renameMenubarItem);
            }
        }
    }

    protected void getEditLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle) throws CMSException {
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        if (cmsContext.getRequest().getRemoteUser() == null) {
            return;
        }
        Document document = (Document)cmsContext.getDoc();
        if (DocumentHelper.isRemoteProxy(cmsContext, pubInfos)) {
            return;
        }
        String id = "EDIT";
        String icon = "glyphicons glyphicons-basic-pencil";
        MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "CMS_EDITION");
        if (pubInfos.isEditableByUser()) {
            DocumentType type = this.customizer.getCMSItemTypes().get(document.getType());
            Object item = null;
            if (type == null || !type.isEditable()) {
                item = null;
            }
            if (item != null) {
                menubar.add((MenubarItem)item);
            }
        }
    }

    protected void getMoveLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle, boolean isTaskbarItem) throws CMSException {
        if (cmsContext.getRequest().getRemoteUser() == null) {
            return;
        }
        if (DocumentHelper.isRemoteProxy(cmsContext, pubInfos)) {
            return;
        }
        Document document = (Document)cmsContext.getDoc();
        boolean authorizedSpace = true;
        if (!NuxeoCompatibility.isVersionGreaterOrEqualsThan((int)NuxeoCompatibility.VERSION_62)) {
            authorizedSpace = pubInfos.isLiveSpace();
        }
        if (authorizedSpace && pubInfos.isEditableByUser() && !pubInfos.isDraft()) {
            NuxeoController nuxeoController = new NuxeoController(portalControllerContext.getRequest(), portalControllerContext.getResponse(), portalControllerContext.getPortletCtx());
            DocumentType cmsItemType = this.customizer.getCMSItemTypes().get(document.getType());
            if (cmsItemType != null && (cmsItemType.isEditable() || "Room".equals(document.getType()))) {
                boolean isMovable = cmsItemType.isMovable();
                if (DocumentHelper.isRemoteProxy(cmsContext, pubInfos)) {
                    isMovable = false;
                }
                if (isMovable) {
                    String url;
                    if (isTaskbarItem) {
                        url = null;
                    } else {
                        try {
                            HashMap<String, String> properties = new HashMap<String, String>();
                            properties.put("osivia.move.documentPath", document.getPath());
                            properties.put("osivia.move.cmsBasePath", nuxeoController.getBasePath());
                            properties.put("osivia.move.acceptedTypes", cmsItemType.getName());
                            url = this.portalUrlFactory.getStartPortletUrl(portalControllerContext, "toutatice-portail-cms-nuxeo-move-portlet-instance", properties, PortalUrlType.POPUP);
                        }
                        catch (PortalException e) {
                            url = null;
                        }
                    }
                    MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "CMS_EDITION");
                    MenubarItem item = new MenubarItem("MOVE", bundle.getString("MOVE"), (MenubarContainer)parent, 2, null);
                    item.setGlyphicon("glyphicons glyphicons-basic-block-move");
                    if (StringUtils.isEmpty(url)) {
                        item.setUrl("#");
                        item.setDisabled(true);
                    } else {
                        item.setUrl(url);
                        item.setHtmlClasses("fancyframe_refresh");
                        item.setAjaxDisabled(true);
                    }
                    menubar.add(item);
                }
            }
        }
    }

    protected void getReorderLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle) throws CMSException {
        DocumentType cmsItemType;
        if (cmsContext.getRequest().getRemoteUser() == null) {
            return;
        }
        Document document = (Document)cmsContext.getDoc();
        boolean authorizedSpace = true;
        if (!NuxeoCompatibility.isVersionGreaterOrEqualsThan((int)NuxeoCompatibility.VERSION_62)) {
            if (DocumentHelper.isRemoteProxy(cmsContext, pubInfos)) {
                return;
            }
            authorizedSpace = pubInfos.isLiveSpace();
        }
        if (authorizedSpace && pubInfos.isEditableByUser() && (cmsItemType = this.customizer.getCMSItemTypes().get(document.getType())) != null && cmsItemType.isOrdered()) {
            String reorderDocumentsURL;
            try {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("osivia.reorder.path", document.getPath());
                reorderDocumentsURL = this.portalUrlFactory.getStartPortletUrl(portalControllerContext, "toutatice-portail-cms-nuxeo-reorder-portlet-instance", properties, PortalUrlType.POPUP);
            }
            catch (PortalException e) {
                reorderDocumentsURL = null;
            }
            if (reorderDocumentsURL != null) {
                MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "CMS_EDITION");
                MenubarItem item = new MenubarItem("REORDER", bundle.getString("REORDER"), "glyphicons glyphicons-basic-sort", (MenubarContainer)parent, 3, reorderDocumentsURL, null, null, "fancyframe_refresh");
                item.setAjaxDisabled(true);
                menubar.add(item);
            }
        }
    }

    protected void getCreateLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle, boolean visible) throws CMSException {
    }

    protected void getDeleteLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle) throws CMSException, PortalException {
    }

    protected void addContextualizationLinkItem(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, List<MenubarItem> menubar, Bundle bundle, String displayName, String url) throws CMSException {
        MenubarItem item = new MenubarItem("CONTEXTUALIZE", bundle.getString("CONTEXTUALIZE_SPACE", new Object[]{displayName}), "glyphicons glyphicons-basic-step-forward", (MenubarContainer)MenubarGroup.SPECIFIC, 1, url, null, null, null);
        item.setAjaxDisabled(true);
        menubar.add(item);
    }

    protected void getContextualizationLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle) throws CMSException {
    }

    protected void addPermaLinkItem(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, List<MenubarItem> menubar, Bundle bundle, String url) throws CMSException {
        String id = cmsContext.getResponse().getNamespace() + "PermalinkModal";
        String htmlContent = this.generatePermalinkModal(bundle, id, url);
        MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "SHARE");
        MenubarItem item = new MenubarItem("PERMALINK", bundle.getString("PERMALINK"), "glyphicons glyphicons-basic-link", (MenubarContainer)parent, 1, "#", null, null, null);
        item.getData().put("toggle", "modal");
        item.getData().put("target", "#" + id);
        item.setAjaxDisabled(true);
        item.setAssociatedHTML(htmlContent);
        menubar.add(item);
    }

    private void addEmailLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle) throws CMSException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String computePermaLinkUrl(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, ExtendedDocumentInfos extendedInfos, List<MenubarItem> menubar, Bundle bundle) throws CMSException {
        String url;
        PortletRequest request = cmsContext.getRequest();
        HashMap<String, String> parameters = null;
        String selectors = request.getParameter("selectors");
        if (selectors != null) {
            parameters = new HashMap<String, String>();
            Map decodedSelectors = PageSelectors.decodeProperties((String)selectors);
            parameters.put("selectors", PageSelectors.encodeProperties((Map)decodedSelectors));
        }
        String currentCtx = cmsContext.getDisplayContext();
        String path = null;
        try {
            cmsContext.setDisplayContext("permLinkCtx");
            path = this.customizer.getContentWebIdPath(cmsContext, pubInfos, extendedInfos);
        }
        finally {
            cmsContext.setDisplayContext(currentCtx);
        }
        String permaLinkType = "cms";
        if (this.hasWebId(cmsContext)) {
            permaLinkType = "share";
        }
        try {
            url = this.portalUrlFactory.getPermaLink(portalControllerContext, null, parameters, path, permaLinkType);
        }
        catch (PortalException e) {
            url = null;
        }
        return ContextualizationHelper.getLivePath(url);
    }

    protected boolean mustDisplayPermalink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, List<MenubarItem> menubar, Bundle bundle) throws CMSException {
        boolean displayPermalink = false;
        if (WindowState.MAXIMIZED.equals((Object)cmsContext.getRequest().getWindowState()) && cmsContext.getDoc() != null) {
            displayPermalink = !DocumentHelper.isLocalPublishLive((Document)cmsContext.getDoc()) && !DocumentHelper.isDraft((Document)cmsContext.getDoc());
        } else {
            Portal portal;
            boolean spaceSite;
            if (ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext)) {
                displayPermalink = true;
            }
            if (spaceSite = PortalObjectUtils.isSpaceSite((PortalObject)(portal = PortalObjectUtils.getPortal((PortalControllerContext)cmsContext.getPortalControllerContext())))) {
                displayPermalink = false;
            }
        }
        return displayPermalink;
    }

    protected void getPermaLinkLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, ExtendedDocumentInfos extendedInfos, List<MenubarItem> menubar, Bundle bundle) throws CMSException {
        if (!this.mustDisplayPermalink(portalControllerContext, cmsContext, menubar, bundle)) {
            return;
        }
        String url = this.computePermaLinkUrl(portalControllerContext, cmsContext, pubInfos, extendedInfos, menubar, bundle);
        if (url != null) {
            this.addPermaLinkItem(portalControllerContext, cmsContext, menubar, bundle, url);
            this.addEmailLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle);
        }
    }

    private String generatePermalinkModal(Bundle bundle, String id, String url) {
        String labelId = id + "Label";
        String linkId = id + "Link";
        Element container = DOM4JUtils.generateDivElement((String)"modal fade", (AccessibilityRoles)AccessibilityRoles.DIALOG);
        DOM4JUtils.addAttribute((Element)container, (String)"id", (String)id);
        DOM4JUtils.addAttribute((Element)container, (String)"tabindex", (String)"-1");
        DOM4JUtils.addAriaAttribute((Element)container, (String)"labelledby", (String)labelId);
        Element document = DOM4JUtils.generateDivElement((String)"modal-dialog", (AccessibilityRoles)AccessibilityRoles.DOCUMENT);
        container.add(document);
        Element content = DOM4JUtils.generateDivElement((String)"modal-content");
        document.add(content);
        Element header = DOM4JUtils.generateDivElement((String)"modal-header");
        content.add(header);
        Element close = DOM4JUtils.generateElement((String)"button", (String)"close", null);
        DOM4JUtils.addAttribute((Element)close, (String)"type", (String)"button");
        DOM4JUtils.addDataAttribute((Element)close, (String)"dismiss", (String)"modal");
        DOM4JUtils.addAriaAttribute((Element)close, (String)"label", (String)bundle.getString("CLOSE"));
        header.add(close);
        Element closeLabel = DOM4JUtils.generateElement((String)"span", null, (String)"&times;");
        DOM4JUtils.addAriaAttribute((Element)closeLabel, (String)"hidden", (String)String.valueOf(true));
        close.add(closeLabel);
        Element title = DOM4JUtils.generateElement((String)"h4", (String)"modal-title", (String)(" " + bundle.getString("PERMALINK")), (String)"glyphicons glyphicons-link", null);
        DOM4JUtils.addAttribute((Element)title, (String)"id", (String)labelId);
        header.add(title);
        Element body = DOM4JUtils.generateDivElement((String)"modal-body");
        content.add(body);
        Element media = DOM4JUtils.generateDivElement((String)"media");
        body.add(media);
        Element mediaBody = DOM4JUtils.generateDivElement((String)"media-body relative");
        media.add(mediaBody);
        Element absolute = DOM4JUtils.generateDivElement((String)"absolute absolute-full");
        mediaBody.add(absolute);
        Element linkContainer = DOM4JUtils.generateDivElement((String)"text-overflow text-middle");
        absolute.add(linkContainer);
        Element link = DOM4JUtils.generateLinkElement((String)url, null, null, null, (String)url);
        DOM4JUtils.addAttribute((Element)link, (String)"id", (String)linkId);
        linkContainer.add(link);
        Element mediaRight = DOM4JUtils.generateDivElement((String)"media-right");
        media.add(mediaRight);
        Element button = DOM4JUtils.generateElement((String)"button", (String)"btn btn-secondary", (String)(" " + bundle.getString("COPY_PERMALINK")), (String)"glyphicons glyphicons-basic-copy", null);
        DOM4JUtils.addAttribute((Element)button, (String)"type", (String)"button");
        DOM4JUtils.addDataAttribute((Element)button, (String)"clipboard-target", (String)("#" + linkId));
        mediaRight.add(button);
        return DOM4JUtils.writeCompact((Element)container);
    }

    public IMenubarService getMenubarService() {
        return this.menubarService;
    }

    public ICMSServiceLocator getCmsServiceLocator() {
        return this.cmsServiceLocator;
    }

    public IPortalUrlFactory getPortalUrlFactory() {
        return this.portalUrlFactory;
    }

    public DefaultCMSCustomizer getCustomizer() {
        return this.customizer;
    }

    public IContributionService getContributionService() {
        return this.contributionService;
    }

    public ITaskbarService getTaskbarService() {
        return this.taskbarService;
    }

    public IBundleFactory getBundleFactory() {
        return this.bundleFactory;
    }
}

