/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.document;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.cms.IDGenerator;

public class ShareLinkActivationCommand
implements INuxeoCommand {
    private static final String DEFAULT_FORMAT = "default";
    private final Document doc;
    boolean activate;

    public ShareLinkActivationCommand(Document doc, boolean activate) {
        this.doc = doc;
        this.activate = activate;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        DocumentService documentService = (DocumentService)nuxeoSession.getAdapter(DocumentService.class);
        PropertyMap properties = new PropertyMap();
        if (this.activate) {
            PropertyList targets;
            String shareId = this.doc.getProperties().getString("rshr:linkId");
            if (StringUtils.isEmpty((String)shareId)) {
                shareId = IDGenerator.generateId();
                properties.set("rshr:linkId", shareId);
            }
            if ((targets = this.doc.getProperties().getList("rshr:targets")) == null || targets.size() == 0) {
                properties.set("rshr:publicLink", Boolean.valueOf(true));
            }
        }
        properties.set("rshr:enabledLink", Boolean.valueOf(this.activate));
        documentService.update((DocRef)this.doc, properties);
        return null;
    }

    public String getId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(" : ");
        builder.append(this.doc.getPath());
        return builder.toString();
    }
}

