/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.formFilters;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.Blobs;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.portlet.model.UploadedFile;
import org.osivia.portal.api.portlet.model.UploadedFileMetadata;

public abstract class AbstractRecordCommand
implements INuxeoCommand {
    private static final String FILES_PROPERTY = "files:files";
    private final String path;
    private final PropertyMap properties;
    private final Collection<UploadedFile> uploadedFiles;

    public AbstractRecordCommand(String path, PropertyMap properties, Collection<UploadedFile> uploadedFiles) {
        this.path = path;
        this.properties = properties;
        this.uploadedFiles = uploadedFiles;
    }

    public String getId() {
        return null;
    }

    protected void updateBlobs(DocumentService documentService, Document document) throws Exception {
        if (CollectionUtils.isNotEmpty((Collection)this.uploadedFiles)) {
            ArrayList<FileBlob> blobs = new ArrayList<FileBlob>(this.uploadedFiles.size());
            TreeSet removedIndexes = new TreeSet(Collections.reverseOrder());
            for (UploadedFile uploadedFile : this.uploadedFiles) {
                File temporaryFile = uploadedFile.getTemporaryFile();
                UploadedFileMetadata metadata = uploadedFile.getTemporaryMetadata();
                if (uploadedFile.getIndex() != null && (uploadedFile.isDeleted() || temporaryFile != null)) {
                    removedIndexes.add(uploadedFile.getIndex());
                }
                if (temporaryFile == null) continue;
                String fileName = metadata.getFileName();
                String mimeType = metadata.getMimeType() == null ? null : metadata.getMimeType().getBaseType();
                FileBlob blob = new FileBlob(temporaryFile, fileName, mimeType);
                blobs.add(blob);
            }
            for (Integer index : removedIndexes) {
                StringBuilder xpath = new StringBuilder();
                xpath.append(FILES_PROPERTY);
                xpath.append("/item[");
                xpath.append(index);
                xpath.append("]");
                documentService.removeBlob((DocRef)document, xpath.toString());
            }
            if (!blobs.isEmpty()) {
                documentService.setBlobs((DocRef)document, new Blobs(blobs), FILES_PROPERTY);
            }
            for (UploadedFile uploadedFile : this.uploadedFiles) {
                if (uploadedFile.getTemporaryFile() == null) continue;
                uploadedFile.getTemporaryFile().delete();
            }
        }
    }

    protected String getPath() {
        return this.path;
    }

    protected PropertyMap getProperties() {
        return this.properties;
    }

    protected Collection<UploadedFile> getUploadedFiles() {
        return this.uploadedFiles;
    }
}

