/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.formFilters;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterContext;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterException;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterExecutor;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterParameterType;
import fr.toutatice.portail.cms.nuxeo.api.forms.IFormsService;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.services.procedure.formFilters.CreateRecordCommand;
import org.osivia.services.procedure.formFilters.RecordFormFilter;

public class CreateRecordFilter
extends RecordFormFilter {
    public static final String ID = "CreateRecordFilter";
    private static final String LABEL_KEY = "CREATE_RECORD_FILTER_LABEL";
    private static final String DESCRIPTION_KEY = "CREATE_RECORD_FILTER_DESCRIPTION";
    private static final String NOTIFICATION_KEY = "RECORD_CREATED_NOTIFICATION";
    private final IBundleFactory bundleFactory;
    private final INuxeoService nuxeoService;

    public CreateRecordFilter() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
        this.nuxeoService = (INuxeoService)Locator.findMBean(INuxeoService.class, (String)"osivia:service=NuxeoService");
    }

    public String getId() {
        return ID;
    }

    public String getLabelKey() {
        return LABEL_KEY;
    }

    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    public Map<String, FormFilterParameterType> getParameters() {
        return null;
    }

    public boolean hasChildren() {
        return false;
    }

    public void execute(FormFilterContext context, FormFilterExecutor executor) throws FormFilterException, PortalException {
        IFormsService formsService = this.nuxeoService.getFormsService();
        PortalControllerContext portalControllerContext = context.getPortalControllerContext();
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        String fetchPath = NuxeoController.webIdToFetchPath((String)context.getModelWebId());
        NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(fetchPath);
        Document recordFolder = documentContext.getDocument();
        PropertyMap properties = recordFolder.getProperties();
        PropertyList globalVariablesReferences = this.getGlobalVariablesReferences("formulaire", properties);
        Map uploadedFiles = context.getUploadedFiles();
        PropertyMap createProperties = new PropertyMap();
        Map variables = this.getVariables(context, globalVariablesReferences, uploadedFiles);
        createProperties.set("rcd:globalVariablesValues", formsService.convertVariablesToJson(portalControllerContext, variables));
        createProperties.set("rcd:procedureModelWebId", context.getModelWebId());
        String title = (String)variables.get("_title");
        if (StringUtils.isNotBlank((String)title)) {
            createProperties.set("dc:title", title);
        }
        CreateRecordCommand command = new CreateRecordCommand(recordFolder.getPath(), createProperties, uploadedFiles.values());
        nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
        context.getVariables().put("_redirectCmsPath", recordFolder.getPath());
        context.getVariables().put("_displayContext", "menu");
        context.getVariables().put("_notificationMessage", this.bundleFactory.getBundle(nuxeoController.getRequest().getLocale()).getString(NOTIFICATION_KEY));
    }
}

