/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.formFilters;

import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilter;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.portlet.model.UploadedFile;

public abstract class RecordFormFilter
implements FormFilter {
    protected PropertyList getGlobalVariablesReferences(String startingStep, PropertyMap properties) {
        PropertyList stepsList = properties.getList("pcd:steps");
        if (stepsList != null && CollectionUtils.isNotEmpty((Collection)stepsList.list())) {
            for (Object stepO : stepsList.list()) {
                PropertyMap stepM = (PropertyMap)stepO;
                if (!StringUtils.equals((String)stepM.getString("reference"), (String)startingStep)) continue;
                return stepM.getList("globalVariablesReferences");
            }
        }
        return null;
    }

    protected Map<String, String> getVariables(FormFilterContext context, PropertyList globalVariablesReferences, Map<String, UploadedFile> uploadedFiles) throws PortalException {
        HashMap<String, String> variables = new HashMap<String, String>();
        for (Object e : globalVariablesReferences.list()) {
            PropertyMap variableREfM = (PropertyMap)e;
            String variableName = variableREfM.getString("variableName");
            variables.put(variableName, (String)context.getVariables().get(variableName));
        }
        if (MapUtils.isNotEmpty(uploadedFiles)) {
            for (Map.Entry entry : uploadedFiles.entrySet()) {
                String digest;
                String variableName = (String)entry.getKey();
                UploadedFile uploadedFile = (UploadedFile)entry.getValue();
                File temporaryFile = uploadedFile.getTemporaryFile();
                if (uploadedFile.isDeleted()) {
                    variables.put(variableName, null);
                    continue;
                }
                if (temporaryFile == null) continue;
                try {
                    digest = this.getDigest(temporaryFile);
                }
                catch (IOException e) {
                    throw new PortalException((Exception)e);
                }
                JSONObject object = new JSONObject();
                object.put((Object)"digest", (Object)digest);
                object.put((Object)"fileName", (Object)uploadedFile.getTemporaryMetadata().getFileName());
                variables.put(variableName, object.toString());
            }
        }
        return variables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getDigest(File file) throws IOException {
        String digest;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            digest = DigestUtils.md5Hex((InputStream)inputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return digest;
    }
}

