/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.portlet.command;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.osivia.services.procedure.portlet.model.NuxeoOperationEnum;

public class ListProcedureInstancesByModelListCommand
implements INuxeoCommand {
    private static final String select = "SELECT * FROM ProcedureInstance";
    private static final String wherePath = " WHERE ecm:path startswith '";
    private static final String end = "'";
    private static final String whereWebId = " AND pi:procedureModelWebId = '";
    private static final String whereEndStep = " AND pi:currentStep <> 'endStep'";
    private String path;
    private String modelWebId;
    private boolean includeEnded;

    public ListProcedureInstancesByModelListCommand(String path, String modelWebId) {
        this.path = path;
        this.modelWebId = modelWebId;
    }

    public ListProcedureInstancesByModelListCommand(String path, String modelWebId, boolean includeEnded) {
        this.path = path;
        this.modelWebId = modelWebId;
        this.includeEnded = includeEnded;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        OperationRequest request = nuxeoSession.newRequest(NuxeoOperationEnum.QueryElasticSearch.getId());
        request.setHeader("X-NXDocumentProperties", "*");
        StringBuilder queryb = new StringBuilder(select.concat(wherePath).concat(this.path).concat(end).concat(whereWebId).concat(this.modelWebId).concat(end));
        if (!this.includeEnded) {
            queryb.append(whereEndStep);
        }
        request.set("query", (Object)queryb.toString());
        return request.execute();
    }

    public String getId() {
        return "ListProcedureInstancesByModelListCommand/" + this.path + "/" + this.modelWebId;
    }
}

