/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.portlet.drools;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.osivia.services.procedure.portlet.model.ProcedureModel;
import org.osivia.services.procedure.portlet.model.Variable;
import org.osivia.services.procedure.portlet.model.VariableTypesAllEnum;

public class Datas {
    public Map<String, String> values;
    public Map<String, Datas> convertedValues;
    private ProcedureModel model;

    public static Date getCurrentDate() {
        return new Date();
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    public Object getValue(String name) throws ParseException {
        Object res = this.getValues().get(name);
        Variable type = (Variable)this.model.getVariables().get(name);
        if (VariableTypesAllEnum.DATE.equals((Object)type.getType())) {
            SimpleDateFormat sdfmt1 = new SimpleDateFormat("dd/MM/yyyy");
            res = !StringUtils.isEmpty((String)((String)res)) ? sdfmt1.parse((String)res) : null;
        }
        if (VariableTypesAllEnum.NUMBER.equals((Object)type.getType())) {
            Long val = new Long((String)res);
            return val;
        }
        if (VariableTypesAllEnum.FIELDLIST.equals((Object)type.getType())) {
            if (res != null) {
                JSONArray json = JSONArray.fromObject(res);
                ArrayList<Datas> list = new ArrayList<Datas>(json.size());
                for (int i = 0; i < json.size(); ++i) {
                    JSONObject jsonObject = json.getJSONObject(i);
                    HashMap<String, String> childs = new HashMap<String, String>();
                    if (jsonObject != null) {
                        Iterator itr = jsonObject.keys();
                        while (itr.hasNext()) {
                            String key = (String)itr.next();
                            childs.put(key, jsonObject.getString(key));
                        }
                    }
                    list.add(new Datas(childs, this.model));
                }
                return list;
            }
            return new ArrayList();
        }
        return res;
    }

    public void setValue(String name, Object value) throws ParseException {
        this.getValues().put(name, this.convertValue(name, value));
    }

    private String convertValue(String name, Object value) {
        Variable type = (Variable)this.model.getVariables().get(name);
        String res = null;
        if (type != null) {
            if (VariableTypesAllEnum.DATE.equals((Object)type.getType())) {
                SimpleDateFormat sdfmt1 = new SimpleDateFormat("dd/MM/yyyy");
                res = sdfmt1.format((Date)value);
            }
            if (VariableTypesAllEnum.NUMBER.equals((Object)type.getType()) && value instanceof Double) {
                DecimalFormat format = new DecimalFormat();
                format.setDecimalSeparatorAlwaysShown(false);
                format.setGroupingUsed(false);
                res = format.format(value);
            }
        }
        if (res == null) {
            res = value.toString();
        }
        return res;
    }

    public void setRelevant(String name, boolean value) throws ParseException {
        this.getValues().put("osivia." + name + ".applicable", Boolean.toString(value));
    }

    public void setValue(String name, String field, Object value) throws ParseException {
        this.getValues().put("osivia." + name + "." + field, this.convertValue(field, value));
    }

    public Datas(Map<String, String> values, ProcedureModel model) {
        this.values = values;
        this.model = model;
    }
}

