/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.portlet.model;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.services.procedure.portlet.model.Action;
import org.osivia.services.procedure.portlet.model.Field;
import org.osivia.services.procedure.portlet.model.Variable;

@JsonAutoDetect(isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, creatorVisibility=JsonAutoDetect.Visibility.NONE)
public class Step
implements Comparable<Step> {
    private static final String DEFAULT_NOTIFICATION_MSG = "${document:linkWithText(taskPath,taskName)}";
    @JsonProperty(value="name")
    private String stepName;
    @JsonIgnore
    private List<Field> fields;
    @JsonProperty(value="globalVariablesReferences")
    private Set<Field> fieldsSet;
    @JsonProperty(value="actions")
    private List<Action> actions;
    @JsonProperty(value="initAction")
    private Action initAction;
    @JsonProperty(value="index")
    private Integer index;
    @JsonProperty(value="reference")
    private String reference;
    @JsonIgnore
    private String oldReference;
    @JsonProperty(value="actors")
    private List<String> actors;
    @JsonProperty(value="notifiable")
    private Boolean notifiable;
    @JsonProperty(value="notifEmail")
    private Boolean notifEmail;
    @JsonProperty(value="acquitable")
    private Boolean acquitable;
    @JsonProperty(value="closable")
    private Boolean closable;
    @JsonProperty(value="actionIdClosable")
    private String actionIdClosable;
    @JsonProperty(value="stringMsg")
    private String stringMsg;
    @JsonProperty(value="actionIdYes")
    private String actionIdYes;
    @JsonProperty(value="actionIdNo")
    private String actionIdNo;
    @JsonProperty(value="actionIdDefault")
    private String actionIdDefault;
    @JsonProperty(value="endStepMsg")
    private String endStepMsg;

    public Step() {
        this.fields = new ArrayList();
        this.actions = new ArrayList();
    }

    public Step(PropertyMap stepM, Map<String, Variable> variables, NuxeoController nuxeoController) {
        PropertyList actorsObjectsList;
        PropertyMap initActionPmap;
        this.fields = new ArrayList();
        this.actions = new ArrayList();
        PropertyList gvvList = stepM.getList("globalVariablesReferences");
        if (gvvList != null) {
            HashMap<String, Field> fieldMap = new HashMap<String, Field>();
            for (Object gvvO : gvvList.list()) {
                PropertyMap gvvMap = (PropertyMap)gvvO;
                Field field = new Field(gvvMap, variables);
                fieldMap.put(field.getPath(), field);
            }
            boolean completed = false;
            int i = 0;
            while (!completed) {
                String fieldIndex = String.valueOf(i);
                Field mapField = (Field)fieldMap.get(fieldIndex);
                if (mapField != null) {
                    this.fillField(fieldMap, mapField);
                    ArrayList fieldsList = this.getFields();
                    if (fieldsList == null) {
                        fieldsList = new ArrayList();
                    }
                    this.getFields().add(mapField);
                    ++i;
                    continue;
                }
                completed = true;
            }
        }
        Action action = (initActionPmap = stepM.getMap("initAction")) != null ? new Action(initActionPmap, nuxeoController) : new Action();
        this.setInitAction(action);
        PropertyList actionsList = stepM.getList("actions");
        if (actionsList != null) {
            for (Object actionO : actionsList.list()) {
                PropertyMap actionN = (PropertyMap)actionO;
                action = new Action(actionN, nuxeoController);
                this.getActions().add(action);
            }
        }
        if ((actorsObjectsList = stepM.getList("actors")) != null) {
            for (Object actorsObject : actorsObjectsList.list()) {
                this.getActors().add((String)actorsObject);
            }
        }
        this.setStepName(stepM.getString("name"));
        this.setIndex(Integer.valueOf(stepM.getLong("index").intValue()));
        this.setReference(stepM.getString("reference"));
        this.setOldReference(stepM.getString("reference"));
        this.setNotifiable(Boolean.valueOf(BooleanUtils.isTrue((Boolean)stepM.getBoolean("notifiable"))));
        this.setNotifEmail(Boolean.valueOf(BooleanUtils.isTrue((Boolean)stepM.getBoolean("notifEmail"))));
        this.setClosable(Boolean.valueOf(BooleanUtils.isTrue((Boolean)stepM.getBoolean("closable"))));
        this.setAcquitable(Boolean.valueOf(BooleanUtils.isTrue((Boolean)stepM.getBoolean("acquitable"))));
        this.setStringMsg(stepM.getString("stringMsg"));
        this.setActionIdYes(stepM.getString("actionIdYes"));
        this.setActionIdNo(stepM.getString("actionIdNo"));
        this.setActionIdDefault(stepM.getString("actionIdDefault"));
        this.setActionIdClosable(stepM.getString("actionIdClosable"));
        this.setEndStepMsg(stepM.getString("endStepMsg"));
    }

    public Step(Step step) {
        this.setAcquitable(step.getAcquitable());
        this.setActionIdClosable(step.getActionIdClosable());
        this.setActionIdDefault(step.getActionIdDefault());
        this.setActionIdNo(step.getActionIdNo());
        this.setActionIdYes(step.getActionIdYes());
        this.getActions().addAll(step.getActions());
        this.getActors().addAll(step.getActors());
        this.setClosable(step.getClosable());
        this.setEndStepMsg(step.getEndStepMsg());
        this.getFields().addAll(step.getFields());
        this.getFieldsSet().addAll(step.getFieldsSet());
        this.setIndex(step.getIndex());
        this.setInitAction(step.getInitAction());
        this.setNotifEmail(step.getNotifEmail());
        this.setNotifiable(step.getNotifiable());
        this.setOldReference(step.getOldReference());
        this.setReference(step.getReference());
        this.setStepName(step.getStepName());
        this.setStringMsg(step.getStringMsg());
    }

    private void fillField(Map<String, Field> fieldMap, Field field) {
        boolean completed = false;
        int i = 0;
        while (!completed) {
            String fieldIndex = String.valueOf(i);
            Field mapField = fieldMap.get(field.getPath() + "," + fieldIndex);
            if (mapField != null) {
                this.fillField(fieldMap, mapField);
                if (field.getFields() == null) {
                    field.setFields(new ArrayList());
                }
                field.getFields().add(mapField);
                ++i;
                continue;
            }
            completed = true;
        }
    }

    public Step(Integer index, String reference) {
        this.fields = new ArrayList();
        this.actions = new ArrayList();
        this.initAction = new Action();
        this.setIndex(index);
        this.setReference(reference);
        this.setNotifiable(Boolean.valueOf(true));
        this.setStringMsg(DEFAULT_NOTIFICATION_MSG);
    }

    public String getNextPath() {
        int nextPath;
        if (CollectionUtils.isEmpty((Collection)this.getFields())) {
            nextPath = 0;
        } else {
            int lastPath = Integer.parseInt(((Field)this.getFields().get(this.getFields().size() - 1)).getPath());
            nextPath = lastPath++;
        }
        return String.valueOf(nextPath);
    }

    public void addAction() {
        HashSet<String> actionIds = new HashSet<String>(this.actions.size());
        for (Action action : this.actions) {
            actionIds.add(action.getActionId());
        }
        String actionId = this.reference + actionIds.size();
        int i = 0;
        while (!this.isUnique(actionId, actionIds)) {
            int idRef = actionIds.size() + ++i;
            actionId = this.reference + String.valueOf(idRef);
        }
        this.actions.add(new Action(actionId));
    }

    private boolean isUnique(String stringToTest, Set<String> setToCompare) {
        for (String stringToCompare : setToCompare) {
            if (!StringUtils.equals((String)stringToTest, (String)stringToCompare)) continue;
            return false;
        }
        return true;
    }

    public List<Field> getFields() {
        if (this.fields == null) {
            this.fields = new ArrayList();
        }
        return this.fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public List<Action> getActions() {
        if (this.actions == null) {
            this.actions = new ArrayList();
        }
        return this.actions;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public String getStepName() {
        return this.stepName;
    }

    public void setStepName(String stepName) {
        this.stepName = stepName;
    }

    @Override
    public int compareTo(Step step) {
        return this.getIndex().compareTo(step.getIndex());
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getOldReference() {
        return this.oldReference;
    }

    public void setOldReference(String oldReference) {
        this.oldReference = oldReference;
    }

    public Set<Field> getFieldsSet() {
        if (this.fieldsSet == null) {
            this.fieldsSet = new HashSet();
        }
        return this.fieldsSet;
    }

    public void setFieldsSet(Set<Field> fieldsSet) {
        this.fieldsSet = fieldsSet;
    }

    public Boolean getNotifiable() {
        return this.notifiable;
    }

    public void setNotifiable(Boolean notifiable) {
        this.notifiable = notifiable;
    }

    public Boolean getAcquitable() {
        return this.acquitable;
    }

    public void setAcquitable(Boolean acquitable) {
        this.acquitable = acquitable;
    }

    public String getStringMsg() {
        return this.stringMsg;
    }

    public void setStringMsg(String stringMsg) {
        this.stringMsg = stringMsg;
    }

    public String getActionIdYes() {
        return this.actionIdYes;
    }

    public void setActionIdYes(String actionIdYes) {
        this.actionIdYes = actionIdYes;
    }

    public String getActionIdNo() {
        return this.actionIdNo;
    }

    public void setActionIdNo(String actionIdNo) {
        this.actionIdNo = actionIdNo;
    }

    public String getActionIdDefault() {
        return this.actionIdDefault;
    }

    public void setActionIdDefault(String actionIdDefault) {
        this.actionIdDefault = actionIdDefault;
    }

    public Boolean getClosable() {
        return this.closable;
    }

    public void setClosable(Boolean closable) {
        this.closable = closable;
    }

    public String getActionIdClosable() {
        return this.actionIdClosable;
    }

    public void setActionIdClosable(String actionIdClosable) {
        this.actionIdClosable = actionIdClosable;
    }

    public String getEndStepMsg() {
        return this.endStepMsg;
    }

    public void setEndStepMsg(String endStepMsg) {
        this.endStepMsg = endStepMsg;
    }

    public Boolean getNotifEmail() {
        return this.notifEmail;
    }

    public void setNotifEmail(Boolean notifEmail) {
        this.notifEmail = notifEmail;
    }

    public Action getInitAction() {
        return this.initAction;
    }

    public void setInitAction(Action initAction) {
        this.initAction = initAction;
    }

    public List<String> getActors() {
        if (this.actors == null) {
            this.actors = new ArrayList();
        }
        return this.actors;
    }

    public void setActors(List<String> actors) {
        this.actors = actors;
    }
}

