/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.portlet.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.osivia.services.procedure.portlet.model.AddField;
import org.osivia.services.procedure.portlet.model.Field;
import org.osivia.services.procedure.portlet.model.VariableTypesAllEnum;

@JsonAutoDetect(isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, creatorVisibility=JsonAutoDetect.Visibility.NONE)
public class Variable
implements Comparable<Variable> {
    public static final Variable DC_CREATOR = new Variable("dc:creator", "Cr\u00e9\u00e9 par", VariableTypesAllEnum.TEXT, null);
    public static final Variable DC_CREATED = new Variable("dc:created", "Cr\u00e9\u00e9 le", VariableTypesAllEnum.TEXT, null);
    public static final Variable DC_LAST_CONTRIBUTOR = new Variable("dc:lastContributor", "Modifi\u00e9 par", VariableTypesAllEnum.TEXT, null);
    public static final Variable DC_MODIFIED = new Variable("dc:modified", "Modifi\u00e9 le", VariableTypesAllEnum.TEXT, null);
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="label")
    private String label;
    @JsonProperty(value="type")
    private VariableTypesAllEnum type;
    @JsonProperty(value="varOptions")
    private String varOptions;
    @JsonIgnore
    private Map<String, List<Field>> usedInFields;

    public Variable() {
    }

    public Variable(Field field) {
        this.name = field.getName();
        this.label = field.getLabel();
        this.type = field.getType();
        this.varOptions = field.getVarOptions();
    }

    public Variable(AddField field) {
        this.name = field.getVariableName();
        this.label = field.getLabel();
        this.type = field.getType();
        this.varOptions = field.getVarOptions();
    }

    public Variable(String name, String label, VariableTypesAllEnum type, String varOptions) {
        this.name = name;
        this.label = label;
        this.type = type;
        this.varOptions = varOptions;
    }

    public Variable(Variable variable) {
        this.setLabel(variable.getLabel());
        this.setName(variable.getName());
        this.setType(variable.getType());
        this.setVarOptions(variable.getVarOptions());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public VariableTypesAllEnum getType() {
        return this.type;
    }

    public void setType(VariableTypesAllEnum type) {
        this.type = type;
    }

    public String getVarOptions() {
        return this.varOptions;
    }

    public void setVarOptions(String varOptions) {
        this.varOptions = varOptions;
    }

    public Map<String, List<Field>> getUsedInFields() {
        if (this.usedInFields == null) {
            this.usedInFields = new HashMap();
        }
        return this.usedInFields;
    }

    public void setUsedInFields(Map<String, List<Field>> usedInFields) {
        this.usedInFields = usedInFields;
    }

    @Override
    public int compareTo(Variable variable) {
        return this.getName().compareTo(variable.getName());
    }
}

