/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.portlet.service.impl;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.forms.IFormsService;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.urls.PortalUrlType;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.procedure.portlet.command.CreateDocumentCommand;
import org.osivia.services.procedure.portlet.command.DeleteDocumentCommand;
import org.osivia.services.procedure.portlet.command.ListModelsContainerCommand;
import org.osivia.services.procedure.portlet.command.ListProcedureInstancesByModelListCommand;
import org.osivia.services.procedure.portlet.command.ListProceduresModelsCommand;
import org.osivia.services.procedure.portlet.command.ListRecordTypesCommand;
import org.osivia.services.procedure.portlet.command.ListRecordsCommand;
import org.osivia.services.procedure.portlet.command.LoadVocabularyCommand;
import org.osivia.services.procedure.portlet.command.RetrieveDocumentByIdCommand;
import org.osivia.services.procedure.portlet.command.RetrieveProcedureByStepNameCommand;
import org.osivia.services.procedure.portlet.command.UpdateDocumentCommand;
import org.osivia.services.procedure.portlet.model.DocumentTypeEnum;
import org.osivia.services.procedure.portlet.model.Field;
import org.osivia.services.procedure.portlet.model.Form;
import org.osivia.services.procedure.portlet.model.ProcedureInstance;
import org.osivia.services.procedure.portlet.model.ProcedureModel;
import org.osivia.services.procedure.portlet.model.ProcedureUploadedFile;
import org.osivia.services.procedure.portlet.model.ProcedureUploadedFileMetadata;
import org.osivia.services.procedure.portlet.model.Record;
import org.osivia.services.procedure.portlet.model.Step;
import org.osivia.services.procedure.portlet.model.VariableTypesAllEnum;
import org.osivia.services.procedure.portlet.model.WebIdException;
import org.osivia.services.procedure.portlet.service.IProcedureService;
import org.osivia.services.procedure.portlet.util.VocabularySelect2Util;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ProcedureServiceImpl
implements IProcedureService {
    private static final Pattern WEBID_ERROR = Pattern.compile("WebId: .+ already exists\\.");
    private static final String TEMPORARY_FILE_PREFIX = "procedure-file-";
    private static final String TEMPORARY_FILE_SUFFIX = ".tmp";
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private INuxeoService nuxeoService;
    @Autowired
    private DocumentDAO documentDao;

    public ProcedureModel createProcedure(NuxeoController nuxeoController, ProcedureModel procedureModel, String procedurepath) throws PortletException, WebIdException {
        try {
            ListModelsContainerCommand command = new ListModelsContainerCommand(procedurepath);
            Document container = ((Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command)).get(0);
            DocumentTypeEnum type = StringUtils.isNotBlank((String)procedureModel.getProcedureType()) ? DocumentTypeEnum.get((String)procedureModel.getProcedureType()) : DocumentTypeEnum.PROCEDUREMODEL;
            command = new CreateDocumentCommand(container, this.buildProperties(nuxeoController.getPortalCtx(), procedureModel), type);
            Document procedureModelInstance = (Document)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
            procedureModel = new ProcedureModel(procedureModelInstance, nuxeoController);
            return procedureModel;
        }
        catch (NuxeoException e) {
            String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
            if (WEBID_ERROR.matcher(errorMessage).matches()) {
                throw new WebIdException();
            }
            throw new PortletException((Throwable)e);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public ProcedureModel retrieveProcedureByWebId(NuxeoController nuxeoController, String webId) throws PortletException {
        NuxeoController nuxeoController2 = new NuxeoController(nuxeoController.getPortalCtx());
        nuxeoController2.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController2.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
        NuxeoDocumentContext documentContext = nuxeoController2.getDocumentContext(webId);
        return new ProcedureModel(documentContext.getDenormalizedDocument(), nuxeoController2);
    }

    public List<ProcedureInstance> retrieveProceduresInstanceByModel(NuxeoController nuxeoController, ProcedureModel procedureModel) {
        ListProcedureInstancesByModelListCommand command = new ListProcedureInstancesByModelListCommand(procedureModel.getPath(), procedureModel.getCurrentWebId(), false);
        Documents documents = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
        ArrayList<ProcedureInstance> procedureInstanceList = new ArrayList<ProcedureInstance>(documents.size());
        for (Document document : documents) {
            ProcedureInstance procedureInstance = new ProcedureInstance(document);
            procedureInstance.setUrl(nuxeoController.getLink(document).getUrl());
            procedureInstanceList.add(procedureInstance);
        }
        return procedureInstanceList;
    }

    public ProcedureModel updateProcedure(NuxeoController nuxeoController, ProcedureModel procedureModel) throws PortletException, WebIdException {
        ProcedureModel model;
        try {
            String webId = procedureModel.getCurrentWebId();
            NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(webId);
            Document denormalizedDocument = documentContext.getDenormalizedDocument();
            UpdateDocumentCommand command = new UpdateDocumentCommand(denormalizedDocument, this.buildProperties(nuxeoController.getPortalCtx(), procedureModel));
            Document procedureModelInstance = (Document)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
            model = new ProcedureModel(procedureModelInstance, nuxeoController);
        }
        catch (NuxeoException e) {
            String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
            if (errorMessage != null && WEBID_ERROR.matcher(errorMessage).matches()) {
                throw new WebIdException();
            }
            throw new PortletException((Throwable)e);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        return model;
    }

    private PropertyMap buildProperties(PortalControllerContext portalControllerContext, ProcedureModel procedureModel) throws PortletException {
        IFormsService formsService = this.nuxeoService.getFormsService();
        PropertyMap propMap = new PropertyMap();
        try {
            String newWebId;
            propMap.set("dc:title", procedureModel.getName());
            String string = newWebId = StringUtils.isNotBlank((String)procedureModel.getNewWebId()) ? "procedure_" + procedureModel.getNewWebId() : null;
            if (newWebId != null) {
                propMap.set("ttc:webid", newWebId);
            }
            propMap.set("pcd:webIdParent", procedureModel.getWebIdParent());
            propMap.set("pcd:steps", formsService.convertToJson(portalControllerContext, (Object)procedureModel.getSteps()));
            procedureModel.updateVariables();
            propMap.set("pcd:globalVariablesDefinitions", formsService.convertToJson(portalControllerContext, procedureModel.getVariables().values()));
            propMap.set("pcd:startingStep", procedureModel.getStartingStep());
            propMap.set("pcd:procedureObjects", formsService.convertToJson(portalControllerContext, (Object)procedureModel.getProcedureObjects()));
            propMap.set("pcd:dashboards", formsService.convertToJson(portalControllerContext, (Object)procedureModel.getDashboards()));
            HashMap<String, String> rules = new HashMap<String, String>();
            rules.put("rules", procedureModel.getRules());
            propMap.set("pcd:businessRules", formsService.convertToJson(portalControllerContext, rules));
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        return propMap;
    }

    public void deleteProcedure(NuxeoController nuxeoController, ProcedureModel procedureModel) throws PortletException {
        try {
            String webId = procedureModel.getCurrentWebId();
            NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(webId);
            Document currentDocument = documentContext.getDenormalizedDocument();
            DeleteDocumentCommand command = new DeleteDocumentCommand(currentDocument);
            nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public ProcedureInstance retrieveProcedureInstanceByWebId(NuxeoController nuxeoController, String webId) throws PortletException {
        ProcedureInstance procedureInstance;
        int savedAuthType = nuxeoController.getAuthType();
        int savedCacheType = nuxeoController.getCacheType();
        try {
            nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
            nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
            NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(webId);
            Document denormalizedDocument = documentContext.getDenormalizedDocument();
            procedureInstance = new ProcedureInstance(denormalizedDocument);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        finally {
            nuxeoController.setAuthType(savedAuthType);
            nuxeoController.setCacheType(savedCacheType);
        }
        return procedureInstance;
    }

    public Record retrieveRecordInstanceByWebId(NuxeoController nuxeoController, String webId) throws PortletException {
        NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(webId);
        return new Record(documentContext.getDenormalizedDocument());
    }

    public ProcedureInstance retrieveProcedureInstanceById(NuxeoController nuxeoController, String uuid) throws PortletException {
        RetrieveDocumentByIdCommand command = new RetrieveDocumentByIdCommand(uuid);
        Document currentDocument = ((Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command)).get(0);
        PropertyMap properties = currentDocument.getProperties();
        PropertyMap procedureInstanceMap = properties.getMap("nt:pi");
        String piWebId = procedureInstanceMap.getString("ttc:webid");
        return this.retrieveProcedureInstanceByWebId(nuxeoController, piWebId);
    }

    public List<ProcedureModel> listProcedures(NuxeoController nuxeoController, String procedurepath) throws PortletException {
        ArrayList<ProcedureModel> procedureModels;
        block5: {
            procedureModels = new ArrayList<ProcedureModel>();
            try {
                Document modelsContainer;
                ListModelsContainerCommand command = new ListModelsContainerCommand(procedurepath);
                Documents documentList = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
                if (documentList == null || documentList.isEmpty() || (documentList = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)(command = new ListProceduresModelsCommand((modelsContainer = documentList.get(0)).getPath())))) == null || documentList.isEmpty()) break block5;
                for (Document document : documentList) {
                    ProcedureModel procedureModel = new ProcedureModel(document, nuxeoController);
                    try {
                        procedureModel.setUrl(this.getEditUrl(nuxeoController, procedureModel, procedurepath));
                    }
                    catch (PortalException e) {
                        new PortletException((Throwable)e);
                    }
                    procedureModels.add(procedureModel);
                }
            }
            catch (Exception e) {
                throw new PortletException((Throwable)e);
            }
        }
        return procedureModels;
    }

    private String getEditUrl(NuxeoController nuxeoController, ProcedureModel procedureModel, String procedurePath) throws PortalException {
        String startPortletUrl = null;
        if (StringUtils.isNotBlank((String)procedurePath) && nuxeoController.getDocumentContext(procedurePath).getPermissions().isEditable()) {
            Map windowProperties = StringUtils.equals((String)procedureModel.getProcedureType(), (String)DocumentTypeEnum.RECORDFOLDER.getDocType()) ? this.getWindowProperties(procedurePath, "adminrecord", procedureModel.getProcedureType()) : this.getWindowProperties(procedurePath, "adminproc", procedureModel.getProcedureType());
            windowProperties.put("osivia.services.procedure.webid", procedureModel.getCurrentWebId());
            windowProperties.put("osivia.title", "\u00c9diter une procedure");
            startPortletUrl = nuxeoController.getPortalUrlFactory().getStartPortletUrl(nuxeoController.getPortalCtx(), "osivia-services-procedure-portletInstance", windowProperties, PortalUrlType.DEFAULT);
        }
        return startPortletUrl;
    }

    private Map<String, String> getWindowProperties(String procedurePath, String displayContext, String procedureType) throws PortalException {
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.doctype", procedureType);
        windowProperties.put("osivia.services.procedure.procedurePath", procedurePath);
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "true");
        windowProperties.put("osivia.ajaxLink", "1");
        windowProperties.put("osivia.procedure.admin", displayContext);
        return windowProperties;
    }

    public String getAddUrl(NuxeoController nuxeoController, String procedurePath, String displayContext, String procedureType) throws PortletException {
        try {
            String startPortletUrl = null;
            if (StringUtils.isNotBlank((String)procedurePath) && nuxeoController.getDocumentContext(procedurePath).getPermissions().isEditable()) {
                Map windowProperties = this.getWindowProperties(procedurePath, displayContext, procedureType);
                windowProperties.put("osivia.title", "Cr\u00e9er une procedure");
                startPortletUrl = nuxeoController.getPortalUrlFactory().getStartPortletUrl(nuxeoController.getPortalCtx(), "osivia-services-procedure-portletInstance", windowProperties, PortalUrlType.DEFAULT);
            }
            return startPortletUrl;
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
    }

    public String getCloseUrl(PortalControllerContext portalControllerContext) throws PortletException {
        String url;
        PortletRequest request = portalControllerContext.getRequest();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        boolean contextualization = "1".equals(window.getProperty("osivia.cms.contextualization"));
        try {
            url = contextualization ? nuxeoController.getPortalUrlFactory().getDestroyCurrentPageUrl(portalControllerContext) : nuxeoController.getPortalUrlFactory().getBackURL(portalControllerContext, false);
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        return url;
    }

    public List<Map<String, String>> retrieveStepsByName(NuxeoController nuxeoController, String filter) {
        Documents procedures = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)new RetrieveProcedureByStepNameCommand(filter));
        ArrayList results = null;
        if (procedures != null) {
            results = new ArrayList(procedures.size());
            HashMap<String, String> stepResult = new HashMap<String, String>(2);
            for (Document document : procedures) {
                ProcedureModel procedureModel = new ProcedureModel(document, nuxeoController);
                for (Step step : procedureModel.getSteps()) {
                    if (!StringUtils.contains((String)step.getStepName(), (String)filter)) continue;
                    stepResult.put("id", step.getReference());
                    stepResult.put("text", step.getStepName());
                    results.add(stepResult);
                }
            }
        }
        return results;
    }

    public List<ProcedureModel> retrieveProcedureModels(NuxeoController nuxeoController, String procedurepath, String filter) throws PortletException {
        ArrayList<ProcedureModel> procedureModels = new ArrayList<ProcedureModel>();
        Documents documentList = null;
        if (StringUtils.isNotBlank((String)filter)) {
            filter = "AND dc:title LIKE '%".concat(filter).concat("%'");
            documentList = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)new ListProceduresModelsCommand(procedurepath, filter));
        } else {
            documentList = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)new ListProceduresModelsCommand(procedurepath));
        }
        if (documentList != null) {
            for (Document document : documentList) {
                procedureModels.add(new ProcedureModel(document, nuxeoController));
            }
        }
        return procedureModels;
    }

    private void updateFiles(NuxeoController nuxeoController, Form form) {
        ProcedureInstance procedureInstance = form.getProcedureInstance();
        Record record = form.getRecord();
        Object document = record != null ? record.getOriginalDocument() : (procedureInstance != null ? procedureInstance.getOriginalDocument() : null);
        if (document != null) {
            Map variables = record != null ? record.getGlobalVariablesValues() : (procedureInstance != null ? procedureInstance.getGlobalVariablesValues() : null);
            PropertyList files = document.getProperties().getList("files:files");
            List fields = form.getTheCurrentStep().getFields();
            if (MapUtils.isNotEmpty((Map)variables) && files != null && !files.isEmpty() && CollectionUtils.isNotEmpty((Collection)fields)) {
                HashMap uploadedFiles = new HashMap();
                for (Field field : fields) {
                    String value = (String)variables.get(field.getName());
                    if (!StringUtils.isNotEmpty((String)value)) continue;
                    this.updateFieldFile(nuxeoController, document, files, uploadedFiles, field, null, value);
                }
                form.getUploadedFiles().putAll(uploadedFiles);
            }
        }
    }

    private void updateFieldFile(NuxeoController nuxeoController, Document document, PropertyList files, Map<String, ProcedureUploadedFile> uploadedFiles, Field field, Integer index, String value) {
        if (VariableTypesAllEnum.FILE.equals((Object)field.getType()) || VariableTypesAllEnum.PICTURE.equals((Object)field.getType())) {
            ProcedureUploadedFile uploadedFile;
            JSONObject jsonValue;
            if (StringUtils.isEmpty((String)value)) {
                jsonValue = null;
            } else {
                try {
                    jsonValue = JSONObject.fromObject((Object)value);
                }
                catch (JSONException e) {
                    jsonValue = null;
                }
            }
            if (jsonValue != null && !jsonValue.isNullObject() && (uploadedFile = this.jsonObjectToFile(nuxeoController, document, files, jsonValue)) != null) {
                String uploadedFileKey = field.getName();
                if (index != null) {
                    uploadedFileKey = ProcedureServiceImpl.getFileKey((String)Integer.toString(index), (Field)field);
                }
                uploadedFiles.put(uploadedFileKey, uploadedFile);
            }
        } else if (VariableTypesAllEnum.FIELDLIST.equals((Object)field.getType())) {
            JSONArray jsonArray;
            if (StringUtils.isEmpty((String)value)) {
                jsonArray = null;
            } else {
                try {
                    jsonArray = JSONArray.fromObject((Object)value);
                }
                catch (JSONException e) {
                    jsonArray = null;
                }
            }
            if (jsonArray != null && !jsonArray.isEmpty()) {
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    for (Field nestedField : field.getFields()) {
                        String nestedValue;
                        if (!jsonObject.has(nestedField.getName()) || !StringUtils.isNotEmpty((String)(nestedValue = jsonObject.getString(nestedField.getName())))) continue;
                        this.updateFieldFile(nuxeoController, document, files, uploadedFiles, nestedField, Integer.valueOf(i), nestedValue);
                    }
                }
            }
        }
    }

    private ProcedureUploadedFile jsonObjectToFile(NuxeoController nuxeoController, Document document, PropertyList files, JSONObject jsonObject) {
        ProcedureUploadedFile uploadedFile;
        String fileName = jsonObject.getString("fileName");
        String digest = jsonObject.getString("digest");
        PropertyMap file = null;
        int index = 0;
        while (file == null && index < files.size()) {
            PropertyMap map = files.getMap(index).getMap("file");
            if (StringUtils.equals((String)map.getString("name"), (String)fileName) && StringUtils.equals((String)map.getString("digest"), (String)digest)) {
                file = map;
                continue;
            }
            ++index;
        }
        if (file == null) {
            uploadedFile = null;
        } else {
            MimeType mimeType;
            String url = nuxeoController.createAttachedFileLink(document.getPath(), String.valueOf(index));
            try {
                mimeType = new MimeType(file.getString("mime-type"));
            }
            catch (Exception e) {
                mimeType = null;
            }
            String icon = this.documentDao.getIcon(mimeType);
            uploadedFile = (ProcedureUploadedFile)this.applicationContext.getBean(ProcedureUploadedFile.class);
            uploadedFile.setUrl(url);
            uploadedFile.setIndex(Integer.valueOf(index));
            ProcedureUploadedFileMetadata metadata = (ProcedureUploadedFileMetadata)this.applicationContext.getBean(ProcedureUploadedFileMetadata.class);
            metadata.setFileName(fileName);
            metadata.setMimeType(mimeType);
            metadata.setIcon(icon);
            uploadedFile.setOriginalMetadata(metadata);
        }
        return uploadedFile;
    }

    public void updateData(NuxeoController nuxeoController, Form form) throws PortletException {
        this.updateFiles(nuxeoController, form);
    }

    public JSONArray searchVocabularyValues(PortalControllerContext portalControllerContext, String vocabularyId, String filter) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        nuxeoController.setCacheTimeOut(TimeUnit.HOURS.toMillis(1L));
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
        JSONArray results = new JSONArray();
        LoadVocabularyCommand command = new LoadVocabularyCommand(vocabularyId);
        Object object = nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
        if (object instanceof Blob) {
            Blob blob = (Blob)object;
            try {
                String content = IOUtils.toString((InputStream)blob.getStream(), (String)"UTF-8");
                JSONArray array = JSONArray.fromObject((Object)content);
                results = VocabularySelect2Util.parse((JSONArray)array, (String)filter);
            }
            catch (IOException e) {
                throw new PortletException((Throwable)e);
            }
        }
        return results;
    }

    public Map<String, String> getRecordTypes(PortalControllerContext portalControllerContext) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        String basePath = nuxeoController.getBasePath();
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(ListRecordTypesCommand.class, new Object[]{basePath});
        Documents documents = (Documents)nuxeoController.executeNuxeoCommand(command);
        HashMap<String, String> recordTypes = new HashMap<String, String>(documents.size());
        for (Document document : documents) {
            String webId = document.getString("ttc:webid");
            String displayName = StringUtils.defaultIfBlank((String)document.getTitle(), (String)document.getId());
            if (!StringUtils.isNotEmpty((String)webId)) continue;
            recordTypes.put(webId, displayName);
        }
        return recordTypes;
    }

    public JSONArray searchRecords(PortalControllerContext portalControllerContext, String recordFolderWebId, String filter) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        String basePath = nuxeoController.getBasePath();
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(ListRecordsCommand.class, new Object[]{basePath, recordFolderWebId, filter});
        Documents documents = (Documents)nuxeoController.executeNuxeoCommand(command);
        JSONArray results = new JSONArray();
        for (Document document : documents) {
            JSONObject object = new JSONObject();
            object.put((Object)"id", (Object)document.getString("ttc:webid"));
            object.put((Object)"text", (Object)StringUtils.defaultIfBlank((String)document.getTitle(), (String)document.getId()));
            results.add((Object)object);
        }
        return results;
    }

    public void uploadFile(PortalControllerContext portalControllerContext, Form form) throws PortletException, IOException {
        Map uploadedFiles = form.getUploadedFiles();
        for (Map.Entry entry : uploadedFiles.entrySet()) {
            MimeType mimeType;
            ProcedureUploadedFile uploadedFile = (ProcedureUploadedFile)entry.getValue();
            MultipartFile multipartFile = uploadedFile.getUpload();
            if (multipartFile == null || multipartFile.isEmpty()) continue;
            File temporaryFile = uploadedFile.getTemporaryFile();
            if (temporaryFile != null) {
                temporaryFile.delete();
            }
            temporaryFile = File.createTempFile("procedure-file-", ".tmp");
            temporaryFile.deleteOnExit();
            multipartFile.transferTo(temporaryFile);
            uploadedFile.setTemporaryFile(temporaryFile);
            ProcedureUploadedFileMetadata metadata = (ProcedureUploadedFileMetadata)this.applicationContext.getBean(ProcedureUploadedFileMetadata.class);
            metadata.setFileName(multipartFile.getOriginalFilename());
            try {
                mimeType = new MimeType(multipartFile.getContentType());
            }
            catch (MimeTypeParseException e) {
                mimeType = null;
            }
            metadata.setMimeType(mimeType);
            String icon = this.documentDao.getIcon(mimeType);
            metadata.setIcon(icon);
            uploadedFile.setTemporaryMetadata(metadata);
            uploadedFile.setDeleted(false);
        }
    }

    public void deleteFile(PortalControllerContext portalControllerContext, Form form, String variableName) throws PortletException, IOException {
        String uploadedFileKey;
        Map uploadedFiles = form.getUploadedFiles();
        ProcedureUploadedFile uploadedFile = (ProcedureUploadedFile)uploadedFiles.get(uploadedFileKey = variableName);
        if (uploadedFile != null) {
            File temporaryFile = uploadedFile.getTemporaryFile();
            if (temporaryFile != null) {
                temporaryFile.delete();
                uploadedFile.setTemporaryFile(null);
            }
            uploadedFile.setTemporaryMetadata(null);
            uploadedFile.setDeleted(true);
        }
    }

    public void picturePreview(PortalControllerContext portalControllerContext, Form form, String variableName) throws PortletException, IOException {
        ResourceResponse response = (ResourceResponse)portalControllerContext.getResponse();
        Map uploadedFiles = form.getUploadedFiles();
        ProcedureUploadedFile uploadedFile = (ProcedureUploadedFile)uploadedFiles.get(variableName);
        OutputStream outputStream = response.getPortletOutputStream();
        if (uploadedFile != null) {
            File temporaryFile = uploadedFile.getTemporaryFile();
            Long size = new Long(temporaryFile.length());
            response.setContentLength(size.intValue());
            String contentType = response.getContentType();
            response.setContentType(contentType);
            response.setCharacterEncoding("UTF-8");
            response.getCacheControl().setExpirationTime(0);
            FileInputStream inputSteam = new FileInputStream(temporaryFile);
            IOUtils.copy((InputStream)inputSteam, (OutputStream)outputStream);
            IOUtils.closeQuietly((InputStream)inputSteam);
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    public static String getFileKey(String rowIndex, Field nestedField) {
        return nestedField.getName() + "_" + nestedField.getPath() + "|" + rowIndex;
    }
}

