/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.portlet.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.osivia.services.procedure.portlet.model.FilePath;
import org.osivia.services.procedure.portlet.model.ObjetMetier;
import org.osivia.services.procedure.portlet.model.ProcedureInstance;
import org.osivia.services.procedure.portlet.model.ProcedureModel;
import org.osivia.services.procedure.portlet.model.ProcedureObjectInstance;

public class ObjetMetierUtil {
    public static final Pattern objectPattern = Pattern.compile("^ecm:\\/\\/([\\w.]+)\\/([\\w.:]+)");

    private ObjetMetierUtil() {
    }

    public static Map<String, ObjetMetier> buildObjetMetiers(ProcedureModel procedureModel, ProcedureInstance procedureInstance) {
        HashMap<String, ObjetMetier> objetMetiers = new HashMap<String, ObjetMetier>();
        TreeSet<String> fileContentToDelete = new TreeSet<String>();
        Iterator gvvI = procedureInstance.getGlobalVariablesValues().entrySet().iterator();
        while (gvvI.hasNext()) {
            Map.Entry gvv = gvvI.next();
            Matcher matcher = objectPattern.matcher((CharSequence)gvv.getKey());
            if (!matcher.matches()) continue;
            String objectName = matcher.group(1);
            String objectProperty = matcher.group(2);
            String fileContentName = "ecm://" + objectName + "/file:content";
            if (!procedureInstance.getFilesPath().containsKey(fileContentName)) continue;
            ObjetMetier objetMetier = (ObjetMetier)objetMetiers.get(objectName);
            if (objetMetier != null) {
                objetMetier.getProperties().set(objectProperty, (String)gvv.getValue());
                continue;
            }
            objetMetiers.put(objectName, new ObjetMetier(procedureModel.getProcedureObject(objectName), (ProcedureObjectInstance)procedureInstance.getProcedureObjects().get(objectName), (FilePath)procedureInstance.getFilesPath().get(fileContentName)));
            ((ObjetMetier)objetMetiers.get(objectName)).getProperties().set(objectProperty, (String)gvv.getValue());
            gvvI.remove();
            fileContentToDelete.add(fileContentName);
        }
        for (String toDelete : fileContentToDelete) {
            procedureInstance.getFilesPath().remove(toDelete);
        }
        return objetMetiers;
    }

    public static boolean isObject(String string) {
        return objectPattern.matcher(string).matches();
    }

    public static String getObjectProperty(String string) {
        Matcher matcher = objectPattern.matcher(string);
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return null;
    }

    public static String getObjectName(String string) {
        Matcher matcher = objectPattern.matcher(string);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public static boolean isContent(String string) {
        Matcher matcher = objectPattern.matcher(string);
        if (matcher.matches()) {
            return StringUtils.equals((String)matcher.group(2), (String)"file:content");
        }
        return false;
    }
}

