/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.portlet.util;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;
import javax.portlet.PortletException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.osivia.services.procedure.portlet.model.Action;
import org.osivia.services.procedure.portlet.model.Field;
import org.osivia.services.procedure.portlet.model.Filter;
import org.osivia.services.procedure.portlet.model.Step;
import org.osivia.services.procedure.portlet.model.Variable;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProcedureUtils {
    private static final Pattern ICDMpattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
    private static final Pattern NOT_ALPHANUMERIC_PATTERN = Pattern.compile("[^\\p{Alnum}]", 256);

    private ProcedureUtils() {
    }

    public static void fillUsedInFields(List<Variable> sortedVariables, List<Step> stepList) {
        if (CollectionUtils.isNotEmpty(stepList)) {
            for (Step step : stepList) {
                ProcedureUtils.fillUsedInFields(sortedVariables, (List)step.getFields(), (String)step.getStepName());
            }
        }
    }

    private static void fillUsedInFields(List<Variable> sortedVariables, List<Field> fields, String stepName) {
        if (CollectionUtils.isNotEmpty(fields)) {
            for (Field field : fields) {
                Variable variable = ProcedureUtils.getVariableByName(sortedVariables, (String)field.getName());
                if (variable != null) {
                    ArrayList<Field> stepFields = (ArrayList<Field>)variable.getUsedInFields().get(stepName);
                    if (stepFields == null) {
                        stepFields = new ArrayList<Field>();
                    }
                    stepFields.add(field);
                    variable.getUsedInFields().put(stepName, stepFields);
                }
                ProcedureUtils.fillUsedInFields(sortedVariables, (List)field.getFields(), (String)stepName);
            }
        }
    }

    private static Variable getVariableByName(List<Variable> sortedVariables, String variableName) {
        if (CollectionUtils.isNotEmpty(sortedVariables)) {
            for (Variable variable : sortedVariables) {
                if (!StringUtils.equals((String)variableName, (String)variable.getName())) continue;
                return variable;
            }
        }
        return null;
    }

    public static void removeFieldsByFieldPath(Step step, String fieldPath) {
        if (ProcedureUtils.removeFieldsByFieldPath((List)step.getFields(), (String)fieldPath)) {
            ProcedureUtils.updateFieldsPath((List)step.getFields(), (String)"");
        }
    }

    private static boolean removeFieldsByFieldPath(List<Field> list, String fieldPath) {
        if (list != null) {
            ListIterator<Field> filtersI = list.listIterator();
            while (filtersI.hasNext()) {
                Field field = filtersI.next();
                if (StringUtils.equals((String)field.getPath(), (String)fieldPath)) {
                    filtersI.remove();
                    return true;
                }
                if (!ProcedureUtils.removeFieldsByFieldPath((List)field.getFields(), (String)fieldPath)) continue;
                return true;
            }
        }
        return false;
    }

    public static void updateFieldsPath(List<Field> list, String currentPath) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String newPath = currentPath.length() > 0 ? currentPath.concat(",").concat(String.valueOf(i)) : String.valueOf(i);
                list.get(i).setPath(newPath);
                ProcedureUtils.updateFieldsPath((List)list.get(i).getFields(), (String)newPath);
            }
        }
    }

    public static void rebuildAction(Action action) {
        HashMap allFiltersMap = new HashMap();
        ProcedureUtils.addAllFilters(allFiltersMap, (List)action.getFilters());
        ProcedureUtils.rebuildAction(allFiltersMap, (Action)action);
    }

    private static void addAllFilters(Map<String, List<Filter>> allFiltersMap, List<Filter> filters) {
        if (filters != null) {
            for (Filter filter : filters) {
                if (filter.getFilterPath() == null) continue;
                String parentPath = filter.getFilterPath().length() > 1 ? StringUtils.substringBeforeLast((String)filter.getFilterPath(), (String)",") : "";
                List<Filter> parentFilters = allFiltersMap.get(parentPath);
                if (parentFilters == null) {
                    parentFilters = new ArrayList<Filter>();
                }
                filter.setFilterInstanceId(filter.getFilterId().concat(filter.getFilterPath()));
                parentFilters.add(filter);
                Collections.sort(parentFilters);
                allFiltersMap.put(parentPath, parentFilters);
                ProcedureUtils.addAllFilters(allFiltersMap, (List)filter.getFilters());
            }
        }
    }

    private static void rebuildAction(Map<String, List<Filter>> allFiltersMap, Action action) {
        ArrayList<Filter> baseFilters = new ArrayList<Filter>();
        List<Filter> filtersList = allFiltersMap.get("");
        if (filtersList != null) {
            baseFilters.addAll(filtersList);
            Collections.sort(baseFilters);
        }
        ProcedureUtils.rebuildFilters(allFiltersMap, baseFilters);
        action.setFilters(baseFilters);
    }

    private static void rebuildFilters(Map<String, List<Filter>> allFiltersMap, List<Filter> baseFilters) {
        if (baseFilters != null) {
            for (Filter filter : baseFilters) {
                filter.setFilters(allFiltersMap.get(filter.getFilterPath()));
                ProcedureUtils.rebuildFilters(allFiltersMap, (List)filter.getFilters());
            }
        }
    }

    public static Filter getFilterByFilterPath(List<Filter> filtersList, String selectedFilterPath) {
        Filter returnFilter = null;
        if (filtersList != null) {
            for (Filter filter : filtersList) {
                Filter filterbyId;
                if (StringUtils.equals((String)filter.getFilterPath(), (String)selectedFilterPath)) {
                    returnFilter = filter;
                }
                if ((filterbyId = ProcedureUtils.getFilterByFilterPath((List)filter.getFilters(), (String)selectedFilterPath)) == null) continue;
                returnFilter = filterbyId;
            }
        }
        return returnFilter;
    }

    public static void updateFilter(List<Filter> filtersList, Filter filterUpdate) {
        if (filtersList != null) {
            for (Filter filter : filtersList) {
                if (StringUtils.equals((String)filter.getFilterPath(), (String)filterUpdate.getFilterPath())) {
                    filter.updateFilter(filterUpdate);
                    return;
                }
                ProcedureUtils.updateFilter((List)filter.getFilters(), (Filter)filterUpdate);
            }
        }
    }

    private static boolean removeFilterByFilterPath(List<Filter> filters, String filterPath) {
        if (filters != null) {
            ListIterator<Filter> filtersI = filters.listIterator();
            while (filtersI.hasNext()) {
                Filter filter = filtersI.next();
                if (StringUtils.equals((String)filter.getFilterPath(), (String)filterPath)) {
                    filtersI.remove();
                    return true;
                }
                if (!ProcedureUtils.removeFilterByFilterPath((List)filter.getFilters(), (String)filterPath)) continue;
                return true;
            }
        }
        return false;
    }

    public static void removeFilterByFilterPath(Action action, String filterPath) {
        if (ProcedureUtils.removeFilterByFilterPath((List)action.getFilters(), (String)filterPath)) {
            ProcedureUtils.updateFiltersPath((List)action.getFilters(), (String)"");
        }
    }

    public static void updateFiltersPath(List<Filter> filters, String currentPath) {
        if (filters != null) {
            for (int i = 0; i < filters.size(); ++i) {
                String newPath = currentPath.length() > 0 ? currentPath.concat(",").concat(String.valueOf(i)) : String.valueOf(i);
                filters.get(i).updateFilterPath(newPath);
                ProcedureUtils.updateFiltersPath((List)filters.get(i).getFilters(), (String)newPath);
            }
        }
    }

    public static Field getFieldByFieldPath(List<Field> fields, String selectedFieldPath) {
        Field returnField = null;
        if (fields != null) {
            for (Field field : fields) {
                Field fieldByPath;
                if (StringUtils.equals((String)field.getPath(), (String)selectedFieldPath)) {
                    returnField = field;
                }
                if ((fieldByPath = ProcedureUtils.getFieldByFieldPath((List)field.getFields(), (String)selectedFieldPath)) == null) continue;
                returnField = fieldByPath;
            }
        }
        return returnField;
    }

    public static void rebuildStep(Step step) {
        HashMap allFieldsMap = new HashMap();
        ProcedureUtils.addAllFields(allFieldsMap, (List)step.getFields());
        ProcedureUtils.rebuildStep(allFieldsMap, (Step)step);
    }

    private static void addAllFields(Map<String, List<Field>> allFieldsMap, List<Field> fields) {
        if (fields != null) {
            for (Field field : fields) {
                if (field.getPath() == null) continue;
                String parentPath = StringUtils.split((String)field.getPath(), (char)',').length > 1 ? StringUtils.substringBeforeLast((String)field.getPath(), (String)",") : "";
                List<Field> parentFields = allFieldsMap.get(parentPath);
                if (parentFields == null) {
                    parentFields = new ArrayList<Field>();
                }
                parentFields.add(field);
                Collections.sort(parentFields);
                allFieldsMap.put(parentPath, parentFields);
                ProcedureUtils.addAllFields(allFieldsMap, (List)field.getFields());
            }
        }
    }

    private static void rebuildStep(Map<String, List<Field>> allFieldsMap, Step step) {
        ArrayList<Field> baseFields = new ArrayList<Field>();
        List<Field> fieldList = allFieldsMap.get("");
        if (fieldList != null) {
            baseFields.addAll(fieldList);
            Collections.sort(baseFields);
        }
        ProcedureUtils.rebuildFields(allFieldsMap, baseFields);
        step.setFields(baseFields);
    }

    private static void rebuildFields(Map<String, List<Field>> allFieldsMap, List<Field> fields) {
        if (fields != null) {
            for (Field field : fields) {
                field.setFields(allFieldsMap.get(field.getPath()));
                ProcedureUtils.rebuildFields(allFieldsMap, (List)field.getFields());
            }
        }
    }

    public static Field getFieldByPath(List<Field> fields, String[] path) {
        Integer index = Integer.parseInt(path[0]);
        if (path.length == 1 && fields != null) {
            ListIterator<Field> listIterator = fields.listIterator();
            while (listIterator.hasNext()) {
                Field field = listIterator.next();
                String[] pathArray = StringUtils.split((String)field.getPath(), (char)',');
                if (pathArray.length <= 0 || Integer.parseInt(pathArray[pathArray.length - 1]) != index) continue;
                return field;
            }
        } else {
            Field nestedField = fields.get(index);
            path = (String[])ArrayUtils.remove((Object[])path, (int)0);
            return ProcedureUtils.getFieldByPath((List)nestedField.getFields(), (String[])path);
        }
        return null;
    }

    public static String buildUniqueVariableName(Map<String, Variable> variables, String varName) throws PortletException {
        String uniqueVarName;
        varName = ProcedureUtils.normalizeVariableName((String)varName);
        int i = 0;
        String string = uniqueVarName = StringUtils.isNotBlank((String)varName) ? varName : varName + i;
        while (variables.containsKey(uniqueVarName)) {
            uniqueVarName = varName + i;
            ++i;
        }
        return uniqueVarName;
    }

    public static String normalizeVariableName(String varName) {
        varName = StringUtils.deleteWhitespace((String)varName);
        varName = ProcedureUtils.normalizeAccents((String)varName);
        varName = NOT_ALPHANUMERIC_PATTERN.matcher(varName).replaceAll("");
        varName = varName.toLowerCase();
        return varName;
    }

    private static String normalizeAccents(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder decomposed = new StringBuilder(Normalizer.normalize(input, Normalizer.Form.NFD));
        ProcedureUtils.convertRemainingAccentCharacters((StringBuilder)decomposed);
        return ICDMpattern.matcher(decomposed).replaceAll("");
    }

    private static void convertRemainingAccentCharacters(StringBuilder decomposed) {
        for (int i = 0; i < decomposed.length(); ++i) {
            if (decomposed.charAt(i) == '\u0141') {
                decomposed.deleteCharAt(i);
                decomposed.insert(i, 'L');
                continue;
            }
            if (decomposed.charAt(i) != '\u0142') continue;
            decomposed.deleteCharAt(i);
            decomposed.insert(i, 'l');
        }
    }
}

