/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.binary.metadata.test;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.test.annotations.RepositoryInit;

public class BinaryMetadataServerInit
implements RepositoryInit {
    public static DocumentModel getFile(int index, CoreSession session) {
        return session.getDocument((DocumentRef)new PathRef("/folder/file_" + index));
    }

    public void populate(CoreSession session) {
        DocumentModel doc = session.createDocumentModel("/", "folder", "Folder");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"Folder"));
        session.createDocument(doc);
        for (int i = 0; i < 5; ++i) {
            doc = session.createDocumentModel("/folder", "file_" + i, "File");
            doc.setPropertyValue("dc:title", (Serializable)((Object)("file " + i)));
            doc = session.createDocument(doc);
        }
        try {
            doc = BinaryMetadataServerInit.getFile(0, session);
            File binary = FileUtils.getResourceFileFromContext((String)"data/twist.mp3");
            Blob fb = Blobs.createBlob((File)binary);
            fb.setMimeType("audio/mpeg3");
            DocumentHelper.addBlob((Property)doc.getProperty("file:content"), (Blob)fb);
            session.saveDocument(doc);
            doc = BinaryMetadataServerInit.getFile(1, session);
            binary = FileUtils.getResourceFileFromContext((String)"data/hello.pdf");
            fb = Blobs.createBlob((File)binary);
            fb.setMimeType("application/pdf");
            DocumentHelper.addBlob((Property)doc.getProperty("file:content"), (Blob)fb);
            session.saveDocument(doc);
            doc = BinaryMetadataServerInit.getFile(2, session);
            binary = FileUtils.getResourceFileFromContext((String)"data/training.png");
            fb = Blobs.createBlob((File)binary);
            fb.setMimeType("image/png");
            DocumentHelper.addBlob((Property)doc.getProperty("file:content"), (Blob)fb);
            session.saveDocument(doc);
            doc = BinaryMetadataServerInit.getFile(3, session);
            binary = FileUtils.getResourceFileFromContext((String)"data/montagehp.psd");
            fb = Blobs.createBlob((File)binary);
            fb.setMimeType("application/octet-stream");
            DocumentHelper.addBlob((Property)doc.getProperty("file:content"), (Blob)fb);
            session.saveDocument(doc);
            doc = BinaryMetadataServerInit.getFile(4, session);
            binary = FileUtils.getResourceFileFromContext((String)"data/china.jpg");
            fb = Blobs.createBlob((File)binary);
            fb.setMimeType("image/jpeg");
            DocumentHelper.addBlob((Property)doc.getProperty("file:content"), (Blob)fb);
            session.saveDocument(doc);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        session.save();
    }
}

