/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.binary.metadata.test;

import java.io.Serializable;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.binary.metadata.test.BaseBinaryMetadataTest;
import org.nuxeo.binary.metadata.test.BinaryMetadataFeature;
import org.nuxeo.binary.metadata.test.BinaryMetadataServerInit;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={BinaryMetadataFeature.class})
@Deploy(value={"org.nuxeo.binary.metadata:binary-metadata-readonly-test.xml"})
@RepositoryConfig(cleanup=Granularity.METHOD, init=BinaryMetadataServerInit.class)
public class TestBinaryMetadataDataMappingReadOnly
extends BaseBinaryMetadataTest {
    @Test
    public void itShouldHandleReadonlyMappingAttribute() {
        DocumentModel pdfDoc = BinaryMetadataServerInit.getFile(1, this.session);
        this.binaryMetadataService.writeMetadata(pdfDoc);
        this.session.saveDocument(pdfDoc);
        pdfDoc = BinaryMetadataServerInit.getFile(1, this.session);
        Assert.assertEquals((Object)"en-US", (Object)pdfDoc.getPropertyValue("dc:title"));
        Assert.assertEquals((Object)"OpenOffice.org 3.2", (Object)pdfDoc.getPropertyValue("dc:source"));
        pdfDoc.setPropertyValue("dc:title", (Serializable)((Object)"New Title"));
        pdfDoc.setPropertyValue("dc:source", (Serializable)((Object)"New Source"));
        pdfDoc = this.session.saveDocument(pdfDoc);
        pdfDoc = this.session.getDocument(pdfDoc.getRef());
        Blob blob = (Blob)pdfDoc.getPropertyValue("file:content");
        Map blobProperties = this.binaryMetadataService.readMetadata(blob, true);
        Assert.assertNotNull((Object)blobProperties);
        Assert.assertEquals((Object)"en-US", (Object)blobProperties.get("Language").toString());
        Assert.assertEquals((Object)"New Source", (Object)blobProperties.get("Producer").toString());
    }
}

