/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.binary.metadata.test;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.logging.log4j.core.LogEvent;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.binary.metadata.internals.BinaryMetadataServiceImpl;
import org.nuxeo.binary.metadata.test.BaseBinaryMetadataTest;
import org.nuxeo.binary.metadata.test.BinaryMetadataFeature;
import org.nuxeo.binary.metadata.test.BinaryMetadataServerInit;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LogCaptureFeature;
import org.nuxeo.runtime.test.runner.LogFeature;

@RunWith(value=FeaturesRunner.class)
@Features(value={BinaryMetadataFeature.class, LogFeature.class, LogCaptureFeature.class})
@Deploys(value={@Deploy(value={"org.nuxeo.binary.metadata:binary-metadata-contrib-test.xml"}), @Deploy(value={"org.nuxeo.binary.metadata:binary-metadata-disable-listener.xml"}), @Deploy(value={"org.nuxeo.binary.metadata:binary-metadata-contrib-pdf-test.xml"}), @Deploy(value={"org.nuxeo.binary.metadata:binary-metadata-contrib-lists.xml"})})
@RepositoryConfig(cleanup=Granularity.METHOD, init=BinaryMetadataServerInit.class)
public class TestBinaryMetadataService
extends BaseBinaryMetadataTest {
    private static Map<String, Object> inputPSDMetadata;
    private static List<String> musicMetadata;
    private static List<String> PSDMetadata;
    @Inject
    protected LogCaptureFeature.Result logCaptureResult;

    @BeforeClass
    public static void init() throws ParseException {
        inputPSDMetadata = new HashMap<String, Object>();
        inputPSDMetadata.put("EXIF:ImageHeight", "200");
        inputPSDMetadata.put("EXIF:Software", "Nuxeo");
        inputPSDMetadata.put("IPTC:Keywords", new String[]{"keyword1", "keyword2"});
        inputPSDMetadata.put("IPTC:Keywords", new String[]{"keyword1", "keyword2"});
        Date date = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss").parse("2018:06:15 00:00:00");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        inputPSDMetadata.put("EXIF:DateTimeOriginal", calendar);
        musicMetadata = new ArrayList<String>();
        musicMetadata.add("ID3:Title");
        musicMetadata.add("ID3:Lyrics-por");
        musicMetadata.add("ID3:Publisher");
        musicMetadata.add("ID3:Comment");
        PSDMetadata = new ArrayList<String>();
        PSDMetadata.add("EXIF:ImageHeight");
        PSDMetadata.add("EXIF:Software");
        PSDMetadata.add("IPTC:Keywords");
        PSDMetadata.add("EXIF:DateTimeOriginal");
    }

    @Test
    public void itShouldExtractSingleKeywordToStringList() throws PropertyException, IOException {
        File binary = FileUtils.getResourceFileFromContext((String)"data/iptc_one_keyword.jpg");
        DocumentModel doc = this.session.createDocumentModel("/folder", "file_1000", "File");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"file_1000"));
        doc.setPropertyValue("file:content", (Serializable)Blobs.createBlob((File)binary));
        this.binaryMetadataService.writeMetadata(doc, "IPTC-ONE-KW");
        String[] subjects = (String[])doc.getPropertyValue("dc:subjects");
        Assert.assertEquals((long)1L, (long)subjects.length);
    }

    @Test
    public void itShouldExtractKeywordListToStringList() throws PropertyException, IOException {
        File binary = FileUtils.getResourceFileFromContext((String)"data/Budget-Example.xlsx");
        DocumentModel doc = this.session.createDocumentModel("/folder", "file_2000", "File");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"file_2000"));
        doc.setPropertyValue("file:content", (Serializable)Blobs.createBlob((File)binary));
        this.binaryMetadataService.writeMetadata(doc, "EXCEL-TITLES-OF-PARTS-TO-SUBJECTS");
        String[] subjects = (String[])doc.getPropertyValue("dc:subjects");
        Assert.assertEquals((long)4L, (long)subjects.length);
        Assert.assertEquals(Arrays.asList("Example", "Hop", "Sheet2", "Chart Data"), Arrays.asList(subjects));
    }

    @Test
    public void itShouldExtractKeywordListToString() throws PropertyException, IOException {
        File binary = FileUtils.getResourceFileFromContext((String)"data/Budget-Example.xlsx");
        DocumentModel doc = this.session.createDocumentModel("/folder", "file_3000", "File");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"file_3000"));
        doc.setPropertyValue("file:content", (Serializable)Blobs.createBlob((File)binary));
        this.binaryMetadataService.writeMetadata(doc, "EXCEL-TITLES-OF-PARTS-TO-FORMAT");
        String format = (String)((Object)doc.getPropertyValue("dc:format"));
        Assert.assertEquals((Object)"[Example, Hop, Sheet2, Chart Data]", (Object)format);
    }

    @Test
    public void itShouldExtractAllMetadataFromBinary() {
        DocumentModel musicFile = BinaryMetadataServerInit.getFile(0, this.session);
        BlobHolder musicBlobHolder = (BlobHolder)musicFile.getAdapter(BlobHolder.class);
        Map blobProperties = this.binaryMetadataService.readMetadata(musicBlobHolder.getBlob(), false);
        Assert.assertNotNull((Object)blobProperties);
        Assert.assertEquals((Object)"Twist", (Object)blobProperties.get("ID3:Title").toString());
        Assert.assertEquals((Object)"Divine Recordings", (Object)blobProperties.get("ID3:Publisher").toString());
    }

    @Test
    public void itShouldExtractGivenMetadataFromBinary() {
        DocumentModel musicFile = BinaryMetadataServerInit.getFile(0, this.session);
        BlobHolder musicBlobHolder = (BlobHolder)musicFile.getAdapter(BlobHolder.class);
        Map blobProperties = this.binaryMetadataService.readMetadata(musicBlobHolder.getBlob(), musicMetadata, false);
        Assert.assertNotNull((Object)blobProperties);
        Assert.assertEquals((long)4L, (long)blobProperties.size());
        Assert.assertEquals((Object)"Twist", (Object)blobProperties.get("ID3:Title").toString());
        Assert.assertEquals((Object)"Divine Recordings", (Object)blobProperties.get("ID3:Publisher").toString());
    }

    @Test
    public void itShouldWriteGivenMetadataInBinary() throws ParseException {
        DocumentModel psdFile = BinaryMetadataServerInit.getFile(3, this.session);
        BlobHolder psdBlobHolder = (BlobHolder)psdFile.getAdapter(BlobHolder.class);
        Map blobProperties = this.binaryMetadataService.readMetadata(psdBlobHolder.getBlob(), PSDMetadata, false);
        Assert.assertNotNull((Object)blobProperties);
        Assert.assertEquals((long)2L, (long)blobProperties.size());
        Assert.assertEquals((Object)100, blobProperties.get("EXIF:ImageHeight"));
        Assert.assertEquals((Object)"Adobe Photoshop CS4 Macintosh", (Object)blobProperties.get("EXIF:Software").toString());
        Assert.assertNull(blobProperties.get("EXIF:DateTimeOriginal"));
        Blob blob = this.binaryMetadataService.writeMetadata(psdBlobHolder.getBlob(), inputPSDMetadata, false);
        Assert.assertNotNull((Object)blob);
        blobProperties = this.binaryMetadataService.readMetadata(blob, PSDMetadata, false);
        Assert.assertNotNull((Object)blobProperties);
        Assert.assertEquals((long)4L, (long)blobProperties.size());
        Assert.assertEquals((Object)200, blobProperties.get("EXIF:ImageHeight"));
        Assert.assertEquals((Object)"Nuxeo", (Object)blobProperties.get("EXIF:Software").toString());
        List keywords = (List)blobProperties.get("IPTC:Keywords");
        Assert.assertEquals((Object)"keyword1", keywords.get(0));
        Assert.assertEquals((Object)"keyword2", keywords.get(1));
        Date date = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss").parse("2018:06:15 00:00:00");
        Assert.assertEquals((Object)date, blobProperties.get("EXIF:DateTimeOriginal"));
    }

    @Test
    public void itShouldWriteDocPropertiesFromBinaryWithMapping() {
        DocumentModel pdfDoc = BinaryMetadataServerInit.getFile(1, this.session);
        this.binaryMetadataService.writeMetadata(pdfDoc);
        this.session.saveDocument(pdfDoc);
        pdfDoc = BinaryMetadataServerInit.getFile(1, this.session);
        Assert.assertEquals((Object)"en-US", (Object)pdfDoc.getPropertyValue("dc:title"));
        Assert.assertEquals((Object)"OpenOffice.org 3.2", (Object)pdfDoc.getPropertyValue("dc:source"));
        Assert.assertEquals((Object)"Writer", (Object)pdfDoc.getPropertyValue("dc:coverage"));
        Assert.assertEquals((Object)"Mirko Nasato", (Object)pdfDoc.getPropertyValue("dc:creator"));
        String[] keywords = (String[])pdfDoc.getPropertyValue("dc:subjects");
        Assert.assertEquals((Object)"tag1", (Object)keywords[0]);
        Assert.assertEquals((Object)"tag2", (Object)keywords[1]);
        Assert.assertEquals((Object)"OpenOffice.org 3.2", (Object)pdfDoc.getPropertyValue("dc:description"));
    }

    @Test
    public void itShouldAcceptQuoteInMetadataAndAllASCII() {
        DocumentModel musicFile = BinaryMetadataServerInit.getFile(0, this.session);
        BlobHolder musicBlobHolder = (BlobHolder)musicFile.getAdapter(BlobHolder.class);
        Map blobProperties = this.binaryMetadataService.readMetadata(musicBlobHolder.getBlob(), true);
        Assert.assertNotNull((Object)blobProperties);
        Assert.assertEquals((Object)"Twist", (Object)blobProperties.get("Title").toString());
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("SourceURL", "l'adresse id\u00e9ale");
        try {
            this.binaryMetadataService.writeMetadata(musicBlobHolder.getBlob(), metadata, true);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    @LogCaptureFeature.FilterOn(logLevel="WARN", loggerClass=BinaryMetadataServiceImpl.class)
    public void itShouldNotFailMappingDecimalValueToIntegerField() throws IOException {
        DocumentModel doc = this.session.createDocumentModel("/folder", "decimalToIntegerFile", "File");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"file_3000"));
        File binary = FileUtils.getResourceFileFromContext((String)"data/hello.pdf");
        doc.setPropertyValue("file:content", (Serializable)Blobs.createBlob((File)binary));
        this.binaryMetadataService.writeMetadata(doc, "decimalToInteger");
        Assert.assertEquals((Object)"en-US", (Object)doc.getPropertyValue("dc:description"));
        Assert.assertNull((Object)doc.getPropertyValue("uid:major_version"));
        List events = this.logCaptureResult.getCaughtEvents();
        Assert.assertEquals((long)1L, (long)events.size());
        LogEvent event = (LogEvent)events.get(0);
        Assert.assertEquals((Object)"WARN", (Object)event.getLevel().toString());
        String message = "Failed to set property 'uid:major_version' to value 1.4 from metadata 'PDF:PDFVersion' in 'file:content' in document 'null' ('/folder/decimalToIntegerFile')";
        Assert.assertEquals((Object)message, (Object)event.getMessage().getFormattedMessage());
    }

    @Test
    @Deploy(value={"org.nuxeo.binary.metadata:binary-metadata-contrib-failing-exiftool.xml"})
    @LogCaptureFeature.FilterOn(logLevel="ERROR")
    public void itShouldNotDeleteBlobWhenExifToolFails() throws IOException {
        File binary = FileUtils.getResourceFileFromContext((String)"data/hello.pdf");
        Blob blob = Blobs.createBlob((File)binary);
        Blob updatedBlob = this.binaryMetadataService.writeMetadata(blob, Collections.emptyMap(), false);
        Assert.assertNotNull((Object)updatedBlob);
        Assert.assertEquals((Object)blob, (Object)updatedBlob);
        List events = this.logCaptureResult.getCaughtEvents();
        Assert.assertEquals((long)1L, (long)events.size());
        LogEvent event = (LogEvent)events.get(0);
        Assert.assertEquals((Object)"ERROR", (Object)event.getLevel().toString());
        String messageStart = "There was an error executing the following command";
        String messageEnd = "Returning original blob.";
        String message = event.getMessage().getFormattedMessage();
        Assert.assertTrue((boolean)message.startsWith(messageStart));
        Assert.assertTrue((boolean)message.endsWith(messageEnd));
    }
}

