/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.binary.metadata.test;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.binary.metadata.test.BaseBinaryMetadataTest;
import org.nuxeo.binary.metadata.test.BinaryMetadataFeature;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.blob.BlobInfo;
import org.nuxeo.ecm.core.blob.SimpleManagedBlob;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LogCaptureFeature;
import org.nuxeo.runtime.test.runner.TransactionalFeature;

@RunWith(value=FeaturesRunner.class)
@Features(value={BinaryMetadataFeature.class, LogCaptureFeature.class})
@Deploys(value={@Deploy(value={"org.nuxeo.ecm.platform.picture.api"}), @Deploy(value={"org.nuxeo.ecm.platform.picture.core"}), @Deploy(value={"org.nuxeo.ecm.platform.picture.convert"}), @Deploy(value={"org.nuxeo.ecm.platform.rendition.core"}), @Deploy(value={"org.nuxeo.ecm.automation.core"}), @Deploy(value={"org.nuxeo.ecm.platform.tag"}), @Deploy(value={"org.nuxeo.binary.metadata:binary-metadata-contrib-test.xml"}), @Deploy(value={"org.nuxeo.binary.metadata:binary-metadata-contrib-pdf-test.xml"}), @Deploy(value={"org.nuxeo.binary.metadata:binary-metadata-contrib-provider.xml"})})
@RepositoryConfig(cleanup=Granularity.METHOD)
public class TestBinaryMetadataSyncListener
extends BaseBinaryMetadataTest {
    @Inject
    protected TransactionalFeature txFeature;
    @Inject
    protected LogCaptureFeature.Result logResult;

    @Test
    public void testListenerCreationRulesSync() throws Exception {
        this.testListener(true);
    }

    @Test
    public void testListenerUpdateRulesSync() throws Exception {
        this.testListener(false);
    }

    @Test
    @Deploy(value={"org.nuxeo.binary.metadata:binary-metadata-contrib-async-test.xml"})
    public void testListenerCreationRulesAsync() throws Exception {
        this.testListener(true);
    }

    @Test
    @Deploy(value={"org.nuxeo.binary.metadata:binary-metadata-contrib-async-test.xml"})
    public void testListenerUpdateRulesAsync() throws Exception {
        this.testListener(false);
    }

    protected void testListener(boolean attachOnCreation) throws Exception {
        DocumentModel pdfDoc = this.createDocumentWithPDFBlob(attachOnCreation);
        Blob blob = (Blob)pdfDoc.getPropertyValue("file:content");
        Map blobProperties = this.binaryMetadataService.readMetadata(blob, true);
        Assert.assertNotNull((Object)blobProperties);
        Assert.assertEquals((Object)"en-US", (Object)blobProperties.get("Language").toString());
        Assert.assertEquals((Object)"OpenOffice.org 3.2", (Object)blobProperties.get("Producer").toString());
        Assert.assertEquals(Arrays.asList("tag1", "tag2"), blobProperties.get("Keywords"));
        Assert.assertEquals((Object)"Mirko Nasato", (Object)blobProperties.get("Author").toString());
        Assert.assertEquals((Object)"No", (Object)blobProperties.get("Linearized").toString());
        Assert.assertEquals((Object)"Writer", (Object)blobProperties.get("Creator").toString());
        Assert.assertEquals((Object)"en-US", (Object)pdfDoc.getPropertyValue("dc:title"));
        Assert.assertEquals((Object)"OpenOffice.org 3.2", (Object)pdfDoc.getPropertyValue("dc:source"));
        Assert.assertEquals((Object)"Writer", (Object)pdfDoc.getPropertyValue("dc:coverage"));
        Assert.assertEquals((Object)"Mirko Nasato", (Object)pdfDoc.getPropertyValue("dc:creator"));
        Assert.assertEquals((Object)"OpenOffice.org 3.2", (Object)pdfDoc.getPropertyValue("dc:description"));
        File binary = FileUtils.getResourceFileFromContext((String)"data/hello.pdf");
        Blob fb = Blobs.createBlob((File)binary, (String)"application/pdf");
        pdfDoc.setPropertyValue("dc:description", (Serializable)((Object)"descriptionNotFromBlob"));
        DocumentHelper.addBlob((Property)pdfDoc.getProperty("file:content"), (Blob)fb);
        this.session.saveDocument(pdfDoc);
        pdfDoc = this.session.getDocument(pdfDoc.getRef());
        this.txFeature.nextTransaction();
        blob = (Blob)pdfDoc.getPropertyValue("file:content");
        blobProperties = this.binaryMetadataService.readMetadata(blob, true);
        Assert.assertNotNull((Object)blobProperties);
        Assert.assertEquals((Object)"descriptionNotFromBlob", (Object)blobProperties.get("Producer").toString());
        Assert.assertEquals((Object)"descriptionNotFromBlob", (Object)pdfDoc.getPropertyValue("dc:description"));
        pdfDoc.setPropertyValue("dc:description", (Serializable)((Object)"descriptionNotFromBlob-2"));
        this.session.saveDocument(pdfDoc);
        pdfDoc = this.session.getDocument(pdfDoc.getRef());
        this.txFeature.nextTransaction();
        blob = (Blob)pdfDoc.getPropertyValue("file:content");
        blobProperties = this.binaryMetadataService.readMetadata(blob, true);
        Assert.assertNotNull((Object)blobProperties);
        Assert.assertEquals((Object)"descriptionNotFromBlob-2", (Object)blobProperties.get("Producer").toString());
        Assert.assertEquals((Object)"descriptionNotFromBlob-2", (Object)pdfDoc.getPropertyValue("dc:description"));
    }

    @Test
    @Deploys(value={@Deploy(value={"org.nuxeo.binary.metadata:binary-metadata-contrib-sync-async-test.xml"}), @Deploy(value={"org.nuxeo.binary.metadata:disable-binary-metadata-work-test.xml"})})
    public void testListenerCreationRulesSyncAsync() throws Exception {
        this.testListenerRulesSyncAsync(true);
    }

    @Test
    @Deploys(value={@Deploy(value={"org.nuxeo.binary.metadata:binary-metadata-contrib-sync-async-test.xml"}), @Deploy(value={"org.nuxeo.binary.metadata:disable-binary-metadata-work-test.xml"})})
    public void testListenerUpdateRulesSyncAsync() throws Exception {
        this.testListenerRulesSyncAsync(false);
    }

    public void testListenerRulesSyncAsync(boolean attachOnCreation) throws Exception {
        DocumentModel pdfDoc = this.createDocumentWithPDFBlob(attachOnCreation);
        Assert.assertEquals((Object)"en-US", (Object)pdfDoc.getPropertyValue("dc:title"));
        Assert.assertEquals((Object)"OpenOffice.org 3.2", (Object)pdfDoc.getPropertyValue("dc:source"));
        Assert.assertNull((Object)pdfDoc.getPropertyValue("dc:coverage"));
        Assert.assertNull((Object)pdfDoc.getPropertyValue("dc:creator"));
        Assert.assertNull((Object)pdfDoc.getPropertyValue("dc:description"));
    }

    protected DocumentModel createDocumentWithPDFBlob(boolean attachOnCreation) throws IOException {
        DocumentModel doc = this.session.createDocumentModel("/", "folder", "Folder");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"Folder"));
        this.session.createDocument(doc);
        doc = this.session.createDocumentModel("/folder", "file", "File");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"file"));
        if (!attachOnCreation) {
            doc = this.session.createDocument(doc);
        }
        File binary = FileUtils.getResourceFileFromContext((String)"data/hello.pdf");
        Blob fb = Blobs.createBlob((File)binary, (String)"application/pdf");
        DocumentHelper.addBlob((Property)doc.getProperty("file:content"), (Blob)fb);
        doc = attachOnCreation ? this.session.createDocument(doc) : this.session.saveDocument(doc);
        this.txFeature.nextTransaction();
        return this.session.getDocument(doc.getRef());
    }

    @Test
    public void testCollaborativeSaveOnlyIncrementsVersionOnce() throws Exception {
        DocumentModel doc = this.session.createDocumentModel("/", "file", "File");
        doc.setPropertyValue("dc:lastContributor", (Serializable)((Object)"laurel"));
        doc = this.session.createDocument(doc);
        File file = FileUtils.getResourceFileFromContext((String)"data/hello.pdf");
        Blob blob = Blobs.createBlob((File)file, (String)"application/pdf");
        DocumentHelper.addBlob((Property)doc.getProperty("file:content"), (Blob)blob);
        doc.setPropertyValue("dc:lastContributor", (Serializable)((Object)"hardy"));
        doc = this.session.saveDocument(doc);
        Assert.assertEquals((Object)"0.1+", (Object)doc.getVersionLabel());
    }

    @Test
    public void testEXIFandIPTC() throws IOException {
        DocumentModel doc = this.session.createDocumentModel("/", "folder", "Folder");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"Folder"));
        this.session.createDocument(doc);
        doc = this.session.createDocumentModel("/folder", "picture", "Picture");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"picture"));
        doc = this.session.createDocument(doc);
        File binary = FileUtils.getResourceFileFromContext((String)"data/china.jpg");
        Blob fb = Blobs.createBlob((File)binary, (String)"image/jpeg");
        DocumentHelper.addBlob((Property)doc.getProperty("file:content"), (Blob)fb);
        this.session.saveDocument(doc);
        DocumentModel picture = this.session.getDocument(doc.getRef());
        Assert.assertEquals((Object)"Horizontal (normal)", (Object)picture.getPropertyValue("imd:orientation"));
        Assert.assertEquals((Object)2.4, (Object)picture.getPropertyValue("imd:fnumber"));
        doc = this.session.createDocumentModel("/folder", "picture1", "Picture");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"picture"));
        doc = this.session.createDocument(doc);
        binary = FileUtils.getResourceFileFromContext((String)"data/iptc_sample.jpg");
        fb = Blobs.createBlob((File)binary, (String)"image/jpeg");
        DocumentHelper.addBlob((Property)doc.getProperty("file:content"), (Blob)fb);
        this.session.saveDocument(doc);
        picture = this.session.getDocument(doc.getRef());
        Assert.assertEquals((Object)"DDP", (Object)picture.getPropertyValue("dc:source"));
        Assert.assertEquals((Object)"ImageForum", (Object)picture.getPropertyValue("dc:rights"));
        Assert.assertEquals((Object)"Music", (Object)picture.getPropertyValue("dc:description").toString().substring(0, 5));
    }

    @Test
    public void testUpdateOnBlobsFromProvidersWhichPreventUserUpdate() {
        DocumentModel doc = this.session.createDocumentModel("/", "folder", "Folder");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"Folder"));
        this.session.createDocument(doc);
        doc = this.session.createDocumentModel("/folder", "picture", "Picture");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"a picture file"));
        doc = this.session.createDocument(doc);
        BlobInfo blobInfo = new BlobInfo();
        blobInfo.key = "testProvider:user@testProvider.com:0134cc5";
        blobInfo.digest = "5cc31b4305e2beb7191f717448";
        blobInfo.filename = "iptc_sample.jpg";
        blobInfo.mimeType = "image/jpeg";
        SimpleManagedBlob blob = new SimpleManagedBlob(blobInfo);
        DocumentHelper.addBlob((Property)doc.getProperty("file:content"), (Blob)blob);
        this.session.save();
        doc.setPropertyValue("imd:user_comment", (Serializable)((Object)"a comment"));
        this.session.saveDocument(doc);
        Blob anotherBlob = (Blob)doc.getProperty("file:content").getValue();
        Assert.assertEquals((Object)blob, (Object)anotherBlob);
    }

    @Test
    @Deploy(value={"org.nuxeo.binary.metadata:binary-metadata-contrib-async-test.xml"})
    @LogCaptureFeature.FilterOn(loggerClass=AbstractWork.class, logLevel="ERROR")
    public void testAsyncBinaryMetadataAreNotRunOnVersion() throws IOException {
        DocumentModel doc = this.session.createDocumentModel("/", "file", "File");
        File binary = FileUtils.getResourceFileFromContext((String)"data/hello.pdf");
        Blob fb = Blobs.createBlob((File)binary, (String)"application/pdf");
        DocumentHelper.addBlob((Property)doc.getProperty("file:content"), (Blob)fb);
        doc = this.session.createDocument(doc);
        Assert.assertTrue((boolean)this.logResult.getCaughtEventMessages().isEmpty());
        this.session.checkIn(doc.getRef(), VersioningOption.MINOR, "0.1");
        this.txFeature.nextTransaction();
        Assert.assertTrue((boolean)this.logResult.getCaughtEventMessages().isEmpty());
    }
}

