/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core;

import com.google.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.DummyCreateDocument;
import org.nuxeo.ecm.automation.core.operations.document.CreateDocument;
import org.nuxeo.ecm.automation.io.services.codec.ObjectCodec;
import org.nuxeo.ecm.automation.io.services.codec.ObjectCodecService;
import org.nuxeo.ecm.automation.server.test.MyObject;
import org.nuxeo.ecm.automation.test.AutomationFeature;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@RunWith(value=FeaturesRunner.class)
@Features(value={AutomationFeature.class})
@Deploy(value={"org.nuxeo.ecm.automation.test", "org.nuxeo.ecm.automation.io", "org.nuxeo.ecm.automation.server", "org.nuxeo.ecm.webengine.core"})
@LocalDeploy(value={"org.nuxeo.ecm.automation.test:test-bindings-compat.xml"})
public class TestOperationRegistration {
    @Inject
    AutomationService service;
    @Inject
    ObjectCodecService objectCodecService;

    @Test
    public void testRegistration() throws Exception {
        OperationType op = this.service.getOperation("Document.Create");
        Assert.assertEquals(CreateDocument.class, (Object)op.getType());
        try {
            this.service.putOperation(DummyCreateDocument.class);
        }
        catch (OperationException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("An operation is already bound to: Document.Create"));
        }
        op = this.service.getOperation("Document.Create");
        Assert.assertEquals(CreateDocument.class, (Object)op.getType());
        this.service.putOperation(DummyCreateDocument.class, true);
        try {
            op = this.service.getOperation("Document.Create");
        }
        catch (OperationException operationException) {
            // empty catch block
        }
        Assert.assertEquals(DummyCreateDocument.class, (Object)op.getType());
    }

    @Test
    public void testCompatibilityRegistration() throws Exception {
        ObjectCodec codec = this.objectCodecService.getCodec(MyObject.class);
        Assert.assertNotNull((Object)codec);
    }
}

