/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.test;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.automation.server.jaxrs.batch.BatchManager;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={CoreFeature.class})
@Deploy(value={"org.nuxeo.ecm.automation.core", "org.nuxeo.ecm.automation.server"})
public class BatchManagerTest {
    @Test
    public void testServiceRegistred() {
        BatchManager bm = (BatchManager)Framework.getLocalService(BatchManager.class);
        Assert.assertNotNull((Object)bm);
    }

    @Test
    public void testBatchCleanup() throws IOException {
        BatchManager bm = (BatchManager)Framework.getLocalService(BatchManager.class);
        String batchId = bm.initBatch(null, null);
        Assert.assertNotNull((Object)batchId);
        for (int i = 0; i < 10; ++i) {
            bm.addStream(batchId, "" + i, (InputStream)new ByteArrayInputStream(("SomeContent" + i).getBytes()), i + ".txt", "text/plain");
        }
        List blobs = bm.getBlobs(batchId);
        Assert.assertNotNull((Object)blobs);
        Assert.assertEquals((long)10L, (long)blobs.size());
        Assert.assertEquals((Object)"4.txt", (Object)((Blob)blobs.get(4)).getFilename());
        Assert.assertEquals((Object)"SomeContent7", (Object)((Blob)blobs.get(7)).getString());
        FileBlob fileBlob = (FileBlob)blobs.get(9);
        File tmplFile = fileBlob.getFile();
        Assert.assertNotNull((Object)tmplFile);
        Assert.assertTrue((boolean)tmplFile.exists());
        bm.clean(batchId);
        Assert.assertFalse((boolean)tmplFile.exists());
    }
}

