/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages.dependencies;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.equinox.p2.cudf.metadata.InstallableUnit;
import org.eclipse.equinox.p2.cudf.solver.OptimizationFunction;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.PackageManager;
import org.nuxeo.connect.packages.dependencies.CUDFPackage;
import org.nuxeo.connect.packages.dependencies.DependencyException;
import org.nuxeo.connect.packages.dependencies.DependencyResolution;
import org.nuxeo.connect.packages.dependencies.NuxeoCUDFPackage;
import org.nuxeo.connect.packages.dependencies.NuxeoCUDFPackageDescription;
import org.nuxeo.connect.packages.dependencies.TargetPlatformFilterHelper;
import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.Version;
import org.nuxeo.connect.update.VersionRange;

public class CUDFHelper {
    private static final Log log = LogFactory.getLog(CUDFHelper.class);
    public static final String newLine = System.getProperty("line.separator");
    public static boolean defaultAllowSNAPSHOT = false;
    protected PackageManager pm;
    protected Map<String, Map<Version, NuxeoCUDFPackage>> nuxeo2CUDFMap = new HashMap<String, Map<Version, NuxeoCUDFPackage>>();
    protected Map<String, NuxeoCUDFPackage> CUDF2NuxeoMap = new HashMap<String, NuxeoCUDFPackage>();
    private String targetPlatform;
    private boolean allowSNAPSHOT = defaultAllowSNAPSHOT;
    private boolean keep = true;

    public void setKeep(boolean keep) {
        this.keep = keep;
    }

    public CUDFHelper(PackageManager pm) {
        this.pm = pm;
    }

    public void initMapping() {
        this.initMapping(null, null, null);
    }

    public void initMapping(PackageDependency[] installs, PackageDependency[] removes, PackageDependency[] upgrades) {
        this.nuxeo2CUDFMap.clear();
        this.CUDF2NuxeoMap.clear();
        HashMap<String, PackageDependency> upgradesMap = new HashMap<String, PackageDependency>();
        HashSet<String> involvedPackages = new HashSet<String>();
        ArrayList<String> installedOrRequiredSNAPSHOTPackages = new ArrayList<String>();
        if (upgrades != null) {
            this.computeInvolvedPackages(upgrades, upgradesMap, involvedPackages, installedOrRequiredSNAPSHOTPackages);
        }
        if (installs != null) {
            this.computeInvolvedPackages(installs, involvedPackages, installedOrRequiredSNAPSHOTPackages);
        }
        if (removes != null) {
            this.computeInvolvedPackages(removes, involvedPackages, installedOrRequiredSNAPSHOTPackages);
        }
        List<DownloadablePackage> allPackages = this.getAllPackages();
        HashMap<String, List<DownloadablePackage>> allPackagesMap = new HashMap<String, List<DownloadablePackage>>();
        for (DownloadablePackage pkg : allPackages) {
            List<DownloadablePackage> list;
            String key = pkg.getName();
            if (!allPackagesMap.containsKey(key)) {
                list = new ArrayList();
                allPackagesMap.put(key, list);
            } else {
                list = (List)allPackagesMap.get(key);
            }
            list.add(pkg);
            if (!this.keep || !pkg.getPackageState().isInstalled()) continue;
            involvedPackages.add(pkg.getName());
        }
        for (DownloadablePackage pkg : allPackages) {
            this.computeInvolvedReferences(involvedPackages, installedOrRequiredSNAPSHOTPackages, pkg, allPackagesMap);
        }
        installedOrRequiredSNAPSHOTPackages.addAll(this.getInstalledSNAPSHOTPackages());
        for (DownloadablePackage pkg : allPackages) {
            NuxeoCUDFPackage nuxeoCUDFPackage;
            Map<Version, NuxeoCUDFPackage> pkgVersions;
            DownloadablePackage remotePackage;
            PackageDependency upgrade;
            if (!involvedPackages.contains(pkg.getName())) {
                if (installedOrRequiredSNAPSHOTPackages.contains(pkg.getName())) {
                    log.error((Object)("Ignore installedOrRequiredSNAPSHOTPackage " + pkg));
                }
                boolean involved = false;
                PackageDependency[] provides = pkg.getProvides();
                for (PackageDependency provide : provides) {
                    if (!involvedPackages.contains(provide.getName())) continue;
                    involved = true;
                    break;
                }
                if (!involved) {
                    log.debug((Object)("Ignore " + pkg + " (not involved by request)"));
                    continue;
                }
            }
            if (this.targetPlatform != null && !pkg.isLocal() && !TargetPlatformFilterHelper.isCompatibleWithTargetPlatform(pkg, this.targetPlatform)) {
                log.debug((Object)("Ignore " + pkg + " (incompatible target platform)"));
                continue;
            }
            if (!this.allowSNAPSHOT && pkg.getVersion().isSnapshot() && pkg.getType() != PackageType.STUDIO && !installedOrRequiredSNAPSHOTPackages.contains(pkg.getName())) {
                log.debug((Object)("Ignore " + pkg + " (excluded SNAPSHOT)"));
                continue;
            }
            if (pkg.getVersion().isSnapshot() && pkg.isLocal() && upgradesMap.containsKey(pkg.getName()) && (upgrade = (PackageDependency)upgradesMap.get(pkg.getName())).getVersionRange().matchVersion(pkg.getVersion()) && (remotePackage = this.pm.getRemotePackage(pkg.getId())) != null) {
                log.debug((Object)String.format("Upgrade with remote %s", remotePackage));
                pkg = remotePackage;
            }
            if ((pkgVersions = this.nuxeo2CUDFMap.get((nuxeoCUDFPackage = new NuxeoCUDFPackage(pkg)).getCUDFName())) == null) {
                pkgVersions = new TreeMap<Version, NuxeoCUDFPackage>();
                this.nuxeo2CUDFMap.put(nuxeoCUDFPackage.getCUDFName(), pkgVersions);
            }
            pkgVersions.put(nuxeoCUDFPackage.getNuxeoVersion(), nuxeoCUDFPackage);
        }
        for (String key : this.nuxeo2CUDFMap.keySet()) {
            Map<Version, NuxeoCUDFPackage> pkgVersions = this.nuxeo2CUDFMap.get(key);
            int posInt = 1;
            for (Version version : pkgVersions.keySet()) {
                NuxeoCUDFPackage pkg = pkgVersions.get(version);
                pkg.setCUDFVersion(posInt++);
                this.CUDF2NuxeoMap.put(pkg.getCUDFName() + "-" + pkg.getCUDFVersion(), pkg);
            }
        }
        if (log.isDebugEnabled()) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            PrintStream out = new PrintStream((OutputStream)outputStream);
            MapUtils.verbosePrint((PrintStream)out, (Object)"nuxeo2CUDFMap", this.nuxeo2CUDFMap);
            MapUtils.verbosePrint((PrintStream)out, (Object)"CUDF2NuxeoMap", this.CUDF2NuxeoMap);
            log.debug((Object)outputStream.toString());
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    protected void computeInvolvedPackages(PackageDependency[] packageDependencies, Set<String> involvedPackages, List<String> installedOrRequiredSNAPSHOTPackages) {
        this.computeInvolvedPackages(packageDependencies, null, involvedPackages, installedOrRequiredSNAPSHOTPackages);
    }

    protected void computeInvolvedPackages(PackageDependency[] packageDependencies, Map<String, PackageDependency> upgradesMap, Set<String> involvedPackages, List<String> installedOrRequiredSNAPSHOTPackages) {
        for (PackageDependency packageDependency : packageDependencies) {
            if (upgradesMap != null) {
                upgradesMap.put(packageDependency.getName(), packageDependency);
            }
            involvedPackages.add(packageDependency.getName());
            this.addIfSNAPSHOT(installedOrRequiredSNAPSHOTPackages, packageDependency);
        }
    }

    protected void computeInvolvedReferences(Set<String> involvedPackages, List<String> installedOrRequiredSNAPSHOTPackages, DownloadablePackage pkg, Map<String, List<DownloadablePackage>> allPackagesMap) {
        if (involvedPackages.contains(pkg.getName())) {
            this.computeInvolvedReferences(involvedPackages, installedOrRequiredSNAPSHOTPackages, pkg.getDependencies(), allPackagesMap);
            this.computeInvolvedReferences(involvedPackages, installedOrRequiredSNAPSHOTPackages, pkg.getConflicts(), allPackagesMap);
            for (PackageDependency pkgDep : pkg.getProvides()) {
                involvedPackages.add(pkgDep.getName());
            }
        }
    }

    protected void computeInvolvedReferences(Set<String> involvedPackages, List<String> installedOrRequiredSNAPSHOTPackages, PackageDependency[] pkgDeps, Map<String, List<DownloadablePackage>> allPackagesMap) {
        for (PackageDependency pkgDep : pkgDeps) {
            if (!involvedPackages.add(pkgDep.getName())) continue;
            this.addIfSNAPSHOT(installedOrRequiredSNAPSHOTPackages, pkgDep);
            List<DownloadablePackage> downloadablePkgDeps = allPackagesMap.get(pkgDep.getName());
            if (downloadablePkgDeps == null) {
                log.warn((Object)("Unknown dependency: " + pkgDep));
                continue;
            }
            for (DownloadablePackage downloadablePkgDep : downloadablePkgDeps) {
                this.computeInvolvedReferences(involvedPackages, installedOrRequiredSNAPSHOTPackages, downloadablePkgDep, allPackagesMap);
            }
        }
    }

    protected void addIfSNAPSHOT(List<String> installedOrRequiredSNAPSHOTPackages, PackageDependency pd) {
        Version minVersion = pd.getVersionRange().getMinVersion();
        Version maxVersion = pd.getVersionRange().getMaxVersion();
        if (minVersion != null && minVersion.isSnapshot() || maxVersion != null && maxVersion.isSnapshot()) {
            installedOrRequiredSNAPSHOTPackages.add(pd.getName());
        }
    }

    protected List<String> getInstalledSNAPSHOTPackages() {
        ArrayList<String> installedSNAPSHOTPackages = new ArrayList<String>();
        for (DownloadablePackage pkg : this.pm.listInstalledPackages()) {
            if (!pkg.getVersion().isSnapshot()) continue;
            installedSNAPSHOTPackages.add(pkg.getName());
        }
        return installedSNAPSHOTPackages;
    }

    protected List<DownloadablePackage> getAllPackages() {
        return this.pm.listAllPackages();
    }

    public NuxeoCUDFPackage getCUDFPackage(String cudfKey) {
        return this.CUDF2NuxeoMap.get(cudfKey);
    }

    public Map<Version, NuxeoCUDFPackage> getCUDFPackages(String cudfName) {
        return this.nuxeo2CUDFMap.get(cudfName);
    }

    public NuxeoCUDFPackage getInstalledCUDFPackage(String pkgName) {
        Map<Version, NuxeoCUDFPackage> packages = this.getCUDFPackages(pkgName);
        if (packages != null) {
            for (NuxeoCUDFPackage pkg : packages.values()) {
                if (!pkg.isInstalled()) continue;
                return pkg;
            }
        }
        return null;
    }

    public String getCUDFFile() throws DependencyException {
        StringBuilder sb = new StringBuilder();
        for (String cudfKey : this.CUDF2NuxeoMap.keySet()) {
            sb.append(this.formatCUDF(this.CUDF2NuxeoMap.get(cudfKey)));
            sb.append(newLine);
        }
        return sb.toString();
    }

    public String formatCUDF(NuxeoCUDFPackage cudfPackage) throws DependencyException {
        StringBuilder sb2 = new StringBuilder();
        sb2.append(cudfPackage.getCUDFStanza());
        sb2.append("depends: " + this.formatCUDFDeps(cudfPackage.getDependencies(), false, true) + newLine);
        String conflictsFormatted = this.formatCUDFDeps(cudfPackage.getConflicts(), false, false);
        conflictsFormatted = conflictsFormatted + (conflictsFormatted.trim().length() > 0 ? ", " : "") + cudfPackage.getCUDFName() + " != " + cudfPackage.getCUDFVersion();
        sb2.append("conflicts: " + conflictsFormatted + newLine);
        sb2.append("provides: " + this.formatCUDFDeps(cudfPackage.getProvides(), false, false) + newLine);
        return sb2.toString();
    }

    protected String formatCUDFDeps(PackageDependency[] dependencies, boolean failOnError, boolean warnOnError) throws DependencyException {
        if (dependencies == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (PackageDependency packageDependency : dependencies) {
            int cudfMaxVersion;
            CUDFPackage cudfPackage;
            int cudfMinVersion;
            String cudfName = NuxeoCUDFPackage.getCUDFName(packageDependency);
            Map<Version, NuxeoCUDFPackage> versionsMap = this.nuxeo2CUDFMap.get(cudfName);
            if (versionsMap == null) {
                String errMsg = "Missing mapping for " + packageDependency + " with target platform " + this.targetPlatform;
                if (failOnError) {
                    throw new DependencyException(errMsg);
                }
                if (warnOnError) {
                    log.warn((Object)errMsg);
                    continue;
                }
                log.debug((Object)errMsg);
                continue;
            }
            VersionRange versionRange = packageDependency.getVersionRange();
            if (versionRange.getMinVersion() == null) {
                cudfMinVersion = -1;
            } else {
                cudfPackage = versionsMap.get(versionRange.getMinVersion());
                int n = cudfMinVersion = cudfPackage == null ? -1 : cudfPackage.getCUDFVersion();
            }
            if (versionRange.getMaxVersion() == null) {
                cudfMaxVersion = -1;
            } else {
                cudfPackage = versionsMap.get(versionRange.getMaxVersion());
                int n = cudfMaxVersion = cudfPackage == null ? -1 : cudfPackage.getCUDFVersion();
            }
            if (cudfMinVersion == cudfMaxVersion) {
                if (cudfMinVersion == -1) {
                    sb.append(cudfName + ", ");
                    continue;
                }
                sb.append(cudfName + " = " + cudfMinVersion + ", ");
                continue;
            }
            if (cudfMinVersion != -1) {
                sb.append(cudfName + " >= " + cudfMinVersion + ", ");
            }
            if (cudfMaxVersion == -1) continue;
            sb.append(cudfName + " <= " + cudfMaxVersion + ", ");
        }
        if (sb.length() > 0) {
            return sb.toString().substring(0, sb.length() - 2);
        }
        return "";
    }

    public Map<String, NuxeoCUDFPackageDescription> parseCUDFFile(BufferedReader reader) throws IOException, DependencyException {
        String line;
        TreeMap<String, NuxeoCUDFPackageDescription> map = new TreeMap<String, NuxeoCUDFPackageDescription>();
        NuxeoCUDFPackageDescription nuxeoCUDFPkgDesc = null;
        Pattern linePattern = Pattern.compile("(.*:)\\s?(.*)");
        block20: while (reader.ready() && (line = reader.readLine()) != null) {
            line = line.trim();
            log.debug((Object)("Parsing line >> " + line));
            if (line.trim().isEmpty()) {
                if (nuxeoCUDFPkgDesc == null) {
                    throw new DependencyException("Invalid CUDF file starting with an empty line");
                }
                map.put(nuxeoCUDFPkgDesc.getCUDFName() + "-" + nuxeoCUDFPkgDesc.getCUDFVersion(), nuxeoCUDFPkgDesc);
                nuxeoCUDFPkgDesc = null;
                continue;
            }
            Matcher m = linePattern.matcher(line);
            if (!m.matches()) {
                throw new DependencyException("Invalid CUDF line: " + line);
            }
            String tag = m.group(1);
            if (tag.endsWith(":")) {
                tag = tag + " ";
            }
            String value = m.group(2);
            if (nuxeoCUDFPkgDesc == null) {
                if (!"package: ".equals(tag)) {
                    throw new DependencyException("Invalid CUDF file not starting with package: ");
                }
                nuxeoCUDFPkgDesc = new NuxeoCUDFPackageDescription();
                nuxeoCUDFPkgDesc.setCUDFName(value);
                continue;
            }
            switch (tag) {
                case "version: ": {
                    nuxeoCUDFPkgDesc.setCUDFVersion(Integer.parseInt(value));
                    continue block20;
                }
                case "installed: ": {
                    nuxeoCUDFPkgDesc.setInstalled(Boolean.parseBoolean(value));
                    continue block20;
                }
                case "depends: ": {
                    nuxeoCUDFPkgDesc.setDependencies(this.parseCUDFDeps(value));
                    continue block20;
                }
                case "conflicts: ": {
                    nuxeoCUDFPkgDesc.setConflicts(this.parseCUDFDeps(value));
                    continue block20;
                }
                case "provides: ": {
                    nuxeoCUDFPkgDesc.setProvides(this.parseCUDFDeps(value));
                    continue block20;
                }
                case "request: ": 
                case "install: ": 
                case "remove: ": 
                case "upgrade: ": {
                    log.debug((Object)("Ignore request stanza " + line));
                    continue block20;
                }
            }
            throw new DependencyException("Invalid CUDF line: " + line);
        }
        if (nuxeoCUDFPkgDesc != null) {
            map.put(nuxeoCUDFPkgDesc.getCUDFName() + "-" + nuxeoCUDFPkgDesc.getCUDFVersion(), nuxeoCUDFPkgDesc);
        }
        return map;
    }

    protected List<PackageDependency> parseCUDFDeps(String value) throws DependencyException {
        HashMap<String, PackageDependency> deps = new HashMap<String, PackageDependency>();
        if (value.trim().length() == 0) {
            return new ArrayList<PackageDependency>(deps.values());
        }
        block14: for (String pkgDep : value.split(",")) {
            String[] split = pkgDep.trim().split("\\s");
            if (split.length == 1) {
                deps.put(pkgDep.trim(), new PackageDependency(pkgDep.trim()));
                continue;
            }
            if (split.length != 3) {
                throw new DependencyException("Invalid dependency value: " + value);
            }
            String name = split[0].trim();
            String rel = split[1].trim();
            Version version = new Version(split[2].trim());
            PackageDependency previous = (PackageDependency)deps.get(name);
            switch (rel) {
                case "=": {
                    if (previous != null) {
                        throw new DependencyException("Conflicting dependency value: " + value + " with " + previous);
                    }
                    deps.put(name, new PackageDependency(name, version, version));
                    continue block14;
                }
                case "<": 
                case "<=": {
                    if (previous == null) {
                        deps.put(name, new PackageDependency(name, Version.ZERO, version));
                        continue block14;
                    }
                    VersionRange versionRange = previous.getVersionRange();
                    if (versionRange.getMaxVersion() != null) {
                        throw new DependencyException("Conflicting dependency value: " + value + " with " + previous);
                    }
                    versionRange.setMaxVersion(version);
                    continue block14;
                }
                case ">": 
                case ">=": {
                    if (previous == null) {
                        deps.put(name, new PackageDependency(name, version));
                        continue block14;
                    }
                    VersionRange versionRange = previous.getVersionRange();
                    if (versionRange.getMinVersion() != null) {
                        throw new DependencyException("Conflicting dependency value: " + value + " with " + previous);
                    }
                    versionRange.setMinVersion(version);
                    continue block14;
                }
                case "!=": {
                    continue block14;
                }
                default: {
                    throw new DependencyException("Invalid dependency value: " + value);
                }
            }
        }
        return new ArrayList<PackageDependency>(deps.values());
    }

    public String getCUDFFile(PackageDependency[] pkgInstall, PackageDependency[] pkgRemove, PackageDependency[] pkgUpgrade) throws DependencyException {
        this.initMapping(pkgInstall, pkgRemove, pkgUpgrade);
        StringBuilder sb = new StringBuilder(this.getCUDFFile());
        sb.append("request: " + newLine);
        sb.append("install: " + this.formatCUDFDeps(pkgInstall, true, true) + newLine);
        sb.append("remove: " + this.formatCUDFDeps(pkgRemove, true, true) + newLine);
        sb.append("upgrade: " + this.formatCUDFDeps(pkgUpgrade, true, true) + newLine);
        return sb.toString();
    }

    public DependencyResolution buildResolution(Collection<InstallableUnit> solution, Map<OptimizationFunction.Criteria, List<String>> details) throws DependencyException {
        if (solution == null) {
            throw new DependencyException("No solution found.");
        }
        log.debug((Object)"\nP2CUDF resolution details: ");
        for (OptimizationFunction.Criteria criteria : OptimizationFunction.Criteria.values()) {
            if (details.get(criteria).isEmpty()) continue;
            log.debug((Object)(criteria.label + ": " + details.get(criteria)));
        }
        DependencyResolution res = new DependencyResolution();
        this.completeResolution(res, details, solution);
        if (res.isFailed()) {
            throw new DependencyException(res.failedMessage);
        }
        res.markAsSuccess();
        this.pm.order(res);
        return res;
    }

    protected void completeResolution(DependencyResolution res, Map<OptimizationFunction.Criteria, List<String>> details, Collection<InstallableUnit> solution) {
        for (String pkgName : details.get(OptimizationFunction.Criteria.REMOVED)) {
            NuxeoCUDFPackage pkg = this.getInstalledCUDFPackage(pkgName);
            if (pkg == null) continue;
            res.markPackageForRemoval(pkg.getNuxeoName(), pkg.getNuxeoVersion(), true);
        }
        ArrayList<InstallableUnit> sortedSolution = new ArrayList<InstallableUnit>(solution);
        Collections.sort(sortedSolution);
        log.debug((Object)("Solution: " + sortedSolution));
        if (log.isTraceEnabled()) {
            log.trace((Object)"P2CUDF printed solution");
            for (InstallableUnit iu : sortedSolution) {
                log.trace((Object)("  package: " + iu.getId()));
                log.trace((Object)("  version: " + iu.getVersion().getMajor()));
                log.trace((Object)("  installed: " + iu.isInstalled()));
            }
        }
        for (InstallableUnit iu : sortedSolution) {
            NuxeoCUDFPackage pkg = this.getCUDFPackage(iu.getId() + "-" + iu.getVersion());
            if (pkg == null) {
                log.warn((Object)("Couldn't find " + pkg));
                continue;
            }
            if (details.get(OptimizationFunction.Criteria.NEW).contains(iu.getId()) || details.get(OptimizationFunction.Criteria.VERSION_CHANGED).contains(iu.getId())) {
                if (res.addPackage(pkg.getNuxeoName(), pkg.getNuxeoVersion(), true)) continue;
                log.error((Object)("Failed to add " + pkg));
                continue;
            }
            if (!details.get(OptimizationFunction.Criteria.REMOVED).contains(iu.getId())) {
                if (res.addUnchangedPackage(pkg.getNuxeoName(), pkg.getNuxeoVersion())) continue;
                log.error((Object)("Failed to add " + pkg));
                continue;
            }
            log.debug((Object)("Ignored: " + pkg));
        }
    }

    public void setTargetPlatform(String targetPlatform) {
        this.targetPlatform = targetPlatform;
    }

    public void setAllowSNAPSHOT(boolean allowSNAPSHOT) {
        this.allowSNAPSHOT = allowSNAPSHOT;
    }
}

