/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.queries.ExtendedCommonTermsQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;
import org.elasticsearch.index.search.MatchQuery;

public class MatchQueryParser
implements QueryParser {
    public static final String NAME = "match";

    @Inject
    public MatchQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "match_phrase", "matchPhrase", "match_phrase_prefix", "matchPhrasePrefix", "matchFuzzy", "match_fuzzy", "fuzzy_match"};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser parser = parseContext.parser();
        MatchQuery.Type type = MatchQuery.Type.BOOLEAN;
        if ("match_phrase".equals(parser.currentName()) || "matchPhrase".equals(parser.currentName()) || "text_phrase".equals(parser.currentName()) || "textPhrase".equals(parser.currentName())) {
            type = MatchQuery.Type.PHRASE;
        } else if ("match_phrase_prefix".equals(parser.currentName()) || "matchPhrasePrefix".equals(parser.currentName()) || "text_phrase_prefix".equals(parser.currentName()) || "textPhrasePrefix".equals(parser.currentName())) {
            type = MatchQuery.Type.PHRASE_PREFIX;
        }
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new QueryParsingException(parseContext.index(), "[match] query malformed, no field");
        }
        String fieldName = parser.currentName();
        Object value = null;
        float boost = 1.0f;
        MatchQuery matchQuery = new MatchQuery(parseContext);
        String minimumShouldMatch = null;
        String queryName = null;
        token = parser.nextToken();
        if (token == XContentParser.Token.START_OBJECT) {
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (!token.isValue()) continue;
                if ("query".equals(currentFieldName)) {
                    value = parser.objectText();
                    continue;
                }
                if ("type".equals(currentFieldName)) {
                    String tStr = parser.text();
                    if ("boolean".equals(tStr)) {
                        type = MatchQuery.Type.BOOLEAN;
                        continue;
                    }
                    if ("phrase".equals(tStr)) {
                        type = MatchQuery.Type.PHRASE;
                        continue;
                    }
                    if ("phrase_prefix".equals(tStr) || "phrasePrefix".equals(currentFieldName)) {
                        type = MatchQuery.Type.PHRASE_PREFIX;
                        continue;
                    }
                    throw new QueryParsingException(parseContext.index(), "[match] query does not support type " + tStr);
                }
                if ("analyzer".equals(currentFieldName)) {
                    String analyzer = parser.text();
                    if (parseContext.analysisService().analyzer(analyzer) == null) {
                        throw new QueryParsingException(parseContext.index(), "[match] analyzer [" + parser.text() + "] not found");
                    }
                    matchQuery.setAnalyzer(analyzer);
                    continue;
                }
                if ("boost".equals(currentFieldName)) {
                    boost = parser.floatValue();
                    continue;
                }
                if ("slop".equals(currentFieldName) || "phrase_slop".equals(currentFieldName) || "phraseSlop".equals(currentFieldName)) {
                    matchQuery.setPhraseSlop(parser.intValue());
                    continue;
                }
                if (Fuzziness.FIELD.match(currentFieldName, parseContext.parseFlags())) {
                    matchQuery.setFuzziness(Fuzziness.parse(parser));
                    continue;
                }
                if ("prefix_length".equals(currentFieldName) || "prefixLength".equals(currentFieldName)) {
                    matchQuery.setFuzzyPrefixLength(parser.intValue());
                    continue;
                }
                if ("max_expansions".equals(currentFieldName) || "maxExpansions".equals(currentFieldName)) {
                    matchQuery.setMaxExpansions(parser.intValue());
                    continue;
                }
                if ("operator".equals(currentFieldName)) {
                    String op = parser.text();
                    if ("or".equalsIgnoreCase(op)) {
                        matchQuery.setOccur(BooleanClause.Occur.SHOULD);
                        continue;
                    }
                    if ("and".equalsIgnoreCase(op)) {
                        matchQuery.setOccur(BooleanClause.Occur.MUST);
                        continue;
                    }
                    throw new QueryParsingException(parseContext.index(), "text query requires operator to be either 'and' or 'or', not [" + op + "]");
                }
                if ("minimum_should_match".equals(currentFieldName) || "minimumShouldMatch".equals(currentFieldName)) {
                    minimumShouldMatch = parser.textOrNull();
                    continue;
                }
                if ("rewrite".equals(currentFieldName)) {
                    matchQuery.setRewriteMethod(QueryParsers.parseRewriteMethod(parser.textOrNull(), null));
                    continue;
                }
                if ("fuzzy_rewrite".equals(currentFieldName) || "fuzzyRewrite".equals(currentFieldName)) {
                    matchQuery.setFuzzyRewriteMethod(QueryParsers.parseRewriteMethod(parser.textOrNull(), null));
                    continue;
                }
                if ("fuzzy_transpositions".equals(fieldName)) {
                    matchQuery.setTranspositions(parser.booleanValue());
                    continue;
                }
                if ("lenient".equals(currentFieldName)) {
                    matchQuery.setLenient(parser.booleanValue());
                    continue;
                }
                if ("cutoff_frequency".equals(currentFieldName)) {
                    matchQuery.setCommonTermsCutoff(parser.floatValue());
                    continue;
                }
                if ("zero_terms_query".equals(currentFieldName)) {
                    String zeroTermsDocs = parser.text();
                    if ("none".equalsIgnoreCase(zeroTermsDocs)) {
                        matchQuery.setZeroTermsQuery(MatchQuery.ZeroTermsQuery.NONE);
                        continue;
                    }
                    if ("all".equalsIgnoreCase(zeroTermsDocs)) {
                        matchQuery.setZeroTermsQuery(MatchQuery.ZeroTermsQuery.ALL);
                        continue;
                    }
                    throw new QueryParsingException(parseContext.index(), "Unsupported zero_terms_docs value [" + zeroTermsDocs + "]");
                }
                if ("_name".equals(currentFieldName)) {
                    queryName = parser.text();
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[match] query does not support [" + currentFieldName + "]");
            }
            parser.nextToken();
        } else {
            value = parser.objectText();
            token = parser.nextToken();
            if (token != XContentParser.Token.END_OBJECT) {
                throw new QueryParsingException(parseContext.index(), "[match] query parsed in simplified form, with direct field name, but included more options than just the field name, possibly use its 'options' form, with 'query' element?");
            }
        }
        if (value == null) {
            throw new QueryParsingException(parseContext.index(), "No text specified for text query");
        }
        Query query = matchQuery.parse(type, fieldName, value);
        if (query == null) {
            return null;
        }
        if (query instanceof BooleanQuery) {
            Queries.applyMinimumShouldMatch((BooleanQuery)query, minimumShouldMatch);
        } else if (query instanceof ExtendedCommonTermsQuery) {
            ((ExtendedCommonTermsQuery)query).setLowFreqMinimumNumberShouldMatch(minimumShouldMatch);
        }
        query.setBoost(boost);
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, query);
        }
        return query;
    }
}

