/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.river;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.river.RiversService;
import org.elasticsearch.river.cluster.RiverClusterService;
import org.elasticsearch.river.routing.RiversRouter;

public class RiversManager
extends AbstractLifecycleComponent<RiversManager> {
    private final RiversService riversService;
    private final RiverClusterService clusterService;
    private final RiversRouter riversRouter;

    @Inject
    public RiversManager(Settings settings, RiversService riversService, RiverClusterService clusterService, RiversRouter riversRouter) {
        super(settings);
        this.riversService = riversService;
        this.clusterService = clusterService;
        this.riversRouter = riversRouter;
    }

    @Override
    protected void doStart() throws ElasticsearchException {
        this.riversRouter.start();
        this.riversService.start();
        this.clusterService.start();
    }

    @Override
    protected void doStop() throws ElasticsearchException {
        this.riversRouter.stop();
        this.clusterService.stop();
        this.riversService.stop();
    }

    @Override
    protected void doClose() throws ElasticsearchException {
        this.riversRouter.close();
        this.clusterService.close();
        this.riversService.close();
    }
}

