/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.Map;
import org.elasticsearch.common.lucene.ReaderContextAware;
import org.elasticsearch.common.lucene.ScorerAware;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.lookup.SearchLookup;

public interface SearchScript
extends ExecutableScript,
ReaderContextAware,
ScorerAware {
    public void setNextDocId(int var1);

    public void setNextSource(Map<String, Object> var1);

    public void setNextScore(float var1);

    public float runAsFloat();

    public long runAsLong();

    public double runAsDouble();

    public static class Builder {
        private String script;
        private String lang;
        private Map<String, Object> params;

        public Builder script(String script) {
            this.script = script;
            return this;
        }

        public Builder lang(String lang) {
            this.lang = lang;
            return this;
        }

        public Builder params(Map<String, Object> params) {
            this.params = params;
            return this;
        }

        public SearchScript build(SearchContext context) {
            return this.build(context.scriptService(), context.lookup());
        }

        public SearchScript build(ScriptService service, SearchLookup lookup) {
            return service.search(lookup, this.lang, this.script, this.params);
        }
    }
}

