/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.query.core;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderClassReplacerDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.query.core.CoreQueryPageProviderDescriptor;
import org.nuxeo.ecm.platform.query.core.GenericPageProviderDescriptor;
import org.nuxeo.ecm.platform.query.core.PageProviderClassReplacerRegistry;
import org.nuxeo.ecm.platform.query.core.PageProviderRegistry;
import org.nuxeo.ecm.platform.query.nxql.CoreQueryDocumentPageProvider;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class PageProviderServiceImpl
extends DefaultComponent
implements PageProviderService {
    private static final long serialVersionUID = 1L;
    public static final String PROVIDER_EP = "providers";
    public static final String REPLACER_EP = "replacers";
    @Deprecated
    public static final String NAMED_PARAMETERS = "namedParameters";
    protected PageProviderRegistry providerReg = new PageProviderRegistry();
    protected PageProviderClassReplacerRegistry replacersReg = new PageProviderClassReplacerRegistry();

    @Override
    public PageProviderDefinition getPageProviderDefinition(String name) {
        PageProviderDefinition def = this.providerReg.getPageProvider(name);
        if (def != null) {
            return def.clone();
        }
        return def;
    }

    @Override
    public PageProvider<?> getPageProvider(String name, PageProviderDefinition desc, DocumentModel searchDocument, List<SortInfo> sortInfos, Long pageSize, Long currentPage, Map<String, Serializable> properties, Object ... parameters) throws ClientException {
        Long maxPageSize;
        if (desc == null) {
            return null;
        }
        PageProvider<?> pageProvider = this.newPageProviderInstance(name, desc);
        HashMap<String, Serializable> allProps = new HashMap<String, Serializable>();
        Map<String, String> localProps = desc.getProperties();
        if (localProps != null) {
            allProps.putAll(localProps);
        }
        if (properties != null) {
            allProps.putAll(properties);
        }
        pageProvider.setProperties(allProps);
        pageProvider.setSortable(desc.isSortable());
        pageProvider.setParameters(parameters);
        pageProvider.setPageSizeOptions(desc.getPageSizeOptions());
        if (searchDocument != null) {
            pageProvider.setSearchDocumentModel(searchDocument);
        }
        if ((maxPageSize = desc.getMaxPageSize()) != null) {
            pageProvider.setMaxPageSize(maxPageSize);
        }
        if (sortInfos == null) {
            pageProvider.setSortInfos(desc.getSortInfos());
        } else {
            pageProvider.setSortInfos(sortInfos);
        }
        if (pageSize == null || pageSize < 0L) {
            pageProvider.setPageSize(desc.getPageSize());
        } else {
            pageProvider.setPageSize(pageSize);
        }
        if (currentPage != null && currentPage > 0L) {
            pageProvider.setCurrentPage(currentPage);
        }
        return pageProvider;
    }

    protected PageProvider<?> newPageProviderInstance(String name, PageProviderDefinition desc) throws ClientException {
        PageProvider<?> ret;
        if (desc instanceof CoreQueryPageProviderDescriptor) {
            ret = this.newCoreQueryPageProviderInstance(name);
        } else if (desc instanceof GenericPageProviderDescriptor) {
            Class<PageProvider<?>> klass = ((GenericPageProviderDescriptor)desc).getPageProviderClass();
            ret = this.newPageProviderInstance(name, klass);
        } else {
            throw new ClientException(String.format("Invalid page provider definition with name '%s'", name));
        }
        ret.setName(name);
        ret.setDefinition(desc);
        return ret;
    }

    protected PageProvider<?> newCoreQueryPageProviderInstance(String name) throws ClientException {
        Class<? extends PageProvider<?>> klass = this.replacersReg.getClassForPageProvider(name);
        PageProvider<DocumentModel> ret = klass == null ? new CoreQueryDocumentPageProvider() : this.newPageProviderInstance(name, klass);
        return ret;
    }

    protected PageProvider<?> newPageProviderInstance(String name, Class<? extends PageProvider<?>> klass) throws ClientException {
        PageProvider<?> ret;
        if (klass == null) {
            throw new ClientException(String.format("Cannot find class for page provider definition with name '%s': check ERROR logs at startup", name));
        }
        try {
            ret = klass.newInstance();
        }
        catch (Exception e) {
            throw new ClientException(String.format("Cannot create an instance of class %s for page provider definition with name '%s'", klass.getName(), name), (Throwable)e);
        }
        return ret;
    }

    @Override
    @Deprecated
    public PageProvider<?> getPageProvider(String name, PageProviderDefinition desc, List<SortInfo> sortInfos, Long pageSize, Long currentPage, Map<String, Serializable> properties, Object ... parameters) throws ClientException {
        return this.getPageProvider(name, desc, null, sortInfos, pageSize, currentPage, properties, parameters);
    }

    @Override
    public PageProvider<?> getPageProvider(String name, DocumentModel searchDocument, List<SortInfo> sortInfos, Long pageSize, Long currentPage, Map<String, Serializable> properties, Object ... parameters) throws ClientException {
        PageProviderDefinition desc = this.providerReg.getPageProvider(name);
        if (desc == null) {
            throw new ClientException(String.format("Could not resolve page provider with name '%s'", name));
        }
        return this.getPageProvider(name, desc, searchDocument, sortInfos, pageSize, currentPage, properties, parameters);
    }

    @Override
    public PageProvider<?> getPageProvider(String name, List<SortInfo> sortInfos, Long pageSize, Long currentPage, Map<String, Serializable> properties, Object ... parameters) throws ClientException {
        return this.getPageProvider(name, (DocumentModel)null, sortInfos, pageSize, currentPage, properties, parameters);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (PROVIDER_EP.equals(extensionPoint)) {
            PageProviderDefinition desc = (PageProviderDefinition)contribution;
            this.registerPageProviderDefinition(desc);
        } else if (REPLACER_EP.equals(extensionPoint)) {
            PageProviderClassReplacerDefinition desc = (PageProviderClassReplacerDefinition)contribution;
            this.replacersReg.addContribution(desc);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (PROVIDER_EP.equals(extensionPoint)) {
            PageProviderDefinition desc = (PageProviderDefinition)contribution;
            this.unregisterPageProviderDefinition(desc);
        }
    }

    public void applicationStarted(ComponentContext context) throws Exception {
        super.applicationStarted(context);
        this.replacersReg.dumpReplacerMap();
    }

    @Override
    public void registerPageProviderDefinition(PageProviderDefinition desc) {
        this.providerReg.addContribution(desc);
    }

    @Override
    public void unregisterPageProviderDefinition(PageProviderDefinition desc) {
        this.providerReg.removeContribution(desc);
    }

    @Override
    public Set<String> getPageProviderDefinitionNames() {
        return Collections.unmodifiableSet(this.providerReg.providers.keySet());
    }
}

