/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forum.web;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.automation.task.CreateTask;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.comment.web.CommentManagerActions;
import org.nuxeo.ecm.platform.forum.web.api.PostAction;
import org.nuxeo.ecm.platform.forum.web.api.ThreadAction;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.ecm.platform.task.core.service.DocumentTaskProvider;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.util.RepositoryLocation;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;

@Name(value="postAction")
@Scope(value=ScopeType.CONVERSATION)
public class PostActionBean
implements PostAction {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(PostActionBean.class);
    @In(create=true)
    protected ThreadAction threadAction;
    @In(create=true)
    protected transient CommentManagerActions commentManagerActions;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected transient TaskService taskService;
    @In(required=false)
    protected RepositoryLocation currentServerLocation;
    @In(create=true)
    protected transient Principal currentUser;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected ResourcesAccessor resourcesAccessor;
    @RequestParameter
    protected String deletePostId;
    protected String title;
    protected String text;
    protected String filename;
    protected Blob fileContent;

    @Override
    public boolean checkWritePermissionOnThread() {
        try {
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            if (currentDocument != null) {
                return this.documentManager.hasPermission(currentDocument.getRef(), "ReadWrite");
            }
            log.error((Object)"Cannot check write permission on thread: no current document found");
        }
        catch (ClientException e) {
            log.error((Object)e);
        }
        return false;
    }

    protected void fetchInvalidationsIfNeeded() throws ClientException {
        if (!this.documentManager.isStateSharedByAllThreadSessions()) {
            this.documentManager.save();
        }
    }

    @Override
    public String addPost() throws ClientException {
        DocumentModel dm = this.documentManager.createDocumentModel("Post");
        dm.setProperty("post", "author", (Object)this.commentManagerActions.getPrincipalName());
        dm.setProperty("post", "title", (Object)this.title);
        dm.setProperty("post", "text", (Object)this.text);
        dm.setProperty("post", "creationDate", (Object)new Date());
        dm.setProperty("post", "filename", (Object)this.filename);
        dm.setProperty("post", "fileContent", (Object)this.fileContent);
        dm = this.commentManagerActions.addComment(dm);
        if (this.threadAction.isCurrentThreadModerated() && !this.threadAction.isPrincipalModerator()) {
            this.startModeration(dm);
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("label.comment.waiting_approval"), new Object[0]);
        } else {
            DocumentRef postRef = dm.getRef();
            if (this.documentManager.hasPermission(postRef, "WriteLifeCycle")) {
                this.documentManager.followTransition(postRef, "moderation_publish");
                this.documentManager.save();
            } else {
                try (CoreSession systemSession = CoreInstance.openCoreSessionSystem((String)this.currentServerLocation.getName());){
                    systemSession.followTransition(dm.getRef(), "moderation_publish");
                    systemSession.save();
                }
            }
            this.fetchInvalidationsIfNeeded();
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("label.comment.added.sucess"), new Object[0]);
        }
        this.commentManagerActions.documentChanged();
        this.cleanContextVariables();
        return this.navigationContext.navigateToDocument(this.getParentThread());
    }

    @Override
    public String cancelPost() throws ClientException {
        this.cleanContextVariables();
        this.commentManagerActions.cancelComment();
        this.fetchInvalidationsIfNeeded();
        return this.navigationContext.navigateToDocument(this.getParentThread());
    }

    @Override
    public String deletePost() throws ClientException {
        Task task;
        if (this.deletePostId == null) {
            throw new ClientException("No id for post to delete");
        }
        DocumentModel thread = this.getParentThread();
        DocumentModel post = this.documentManager.getDocument((DocumentRef)new IdRef(this.deletePostId));
        if (this.threadAction.isThreadModerated(thread) && "moderation_pending".equals(post.getCurrentLifeCycleState()) && (task = this.getModerationTask(thread, this.deletePostId)) != null) {
            this.taskService.deleteTask(this.documentManager, task.getId());
        }
        this.commentManagerActions.deleteComment(this.deletePostId);
        this.fetchInvalidationsIfNeeded();
        Events.instance().raiseEvent("workflowProcessEnded", new Object[0]);
        return this.navigationContext.navigateToDocument(this.getParentThread());
    }

    @Override
    public String rejectPost(DocumentModel post) throws ClientException {
        DocumentModel thread = this.getParentThread();
        Task moderationTask = this.getModerationTask(thread, post.getId());
        if (moderationTask == null) {
            throw new ClientException("No moderation task found");
        }
        this.taskService.rejectTask(this.documentManager, (NuxeoPrincipal)this.currentUser, moderationTask, null);
        Events.instance().raiseEvent("workflowTaskCompleted", new Object[0]);
        this.commentManagerActions.documentChanged();
        this.fetchInvalidationsIfNeeded();
        return this.navigationContext.navigateToDocument(this.getParentThread());
    }

    @Override
    public String approvePost(DocumentModel post) throws ClientException {
        DocumentModel thread = this.getParentThread();
        Task moderationTask = this.getModerationTask(thread, post.getId());
        if (moderationTask == null) {
            throw new ClientException("No moderation task found");
        }
        this.taskService.acceptTask(this.documentManager, (NuxeoPrincipal)this.currentUser, moderationTask, null);
        Events.instance().raiseEvent("workflowTaskCompleted", new Object[0]);
        this.commentManagerActions.documentChanged();
        this.fetchInvalidationsIfNeeded();
        return this.navigationContext.navigateToDocument(this.getParentThread());
    }

    @Override
    public DocumentModel getParentThread() {
        return this.navigationContext.getCurrentDocument();
    }

    @Override
    public boolean isPostPublished(DocumentModel post) throws ClientException {
        boolean published = false;
        if (post != null && "moderation_published".equals(post.getCurrentLifeCycleState())) {
            published = true;
        }
        return published;
    }

    protected void startModeration(DocumentModel post) throws ClientException {
        DocumentModel thread = this.getParentThread();
        ArrayList moderators = (ArrayList)thread.getProperty("thread", "moderators");
        if (moderators == null || moderators.isEmpty()) {
            throw new ClientException("No moderators defined");
        }
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("commentId", post.getId());
        vars.put(CreateTask.OperationTaskVariableName.createdFromCreateTaskOperation.name(), "false");
        vars.put(Task.TaskVariableName.needi18n.name(), "true");
        vars.put(Task.TaskVariableName.taskType.name(), "forum_moderate");
        vars.put(CreateTask.OperationTaskVariableName.acceptOperationChain.name(), "acceptComment");
        vars.put(CreateTask.OperationTaskVariableName.rejectOperationChain.name(), "rejectComment");
        this.taskService.createTask(this.documentManager, (NuxeoPrincipal)this.currentUser, thread, "moderate", (List)moderators, false, "moderate", null, null, vars, null);
        Events.instance().raiseEvent("workflowNewProcessStarted", new Object[0]);
    }

    protected Task getModerationTask(DocumentModel thread, String postId) throws ClientException {
        List tasks = DocumentTaskProvider.getTasks((String)"GET_FORUM_MODERATION_TASKS", (CoreSession)this.documentManager, (boolean)false, null, (Object[])new Object[]{thread.getId(), postId});
        if (tasks != null && !tasks.isEmpty()) {
            if (tasks.size() > 1) {
                log.error((Object)"There are several moderation workflows running, taking only first found");
            }
            Task task = (Task)tasks.get(0);
            return task;
        }
        return null;
    }

    protected void cleanContextVariables() {
        this.fileContent = null;
        this.filename = null;
        this.text = null;
        this.title = null;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public Blob getFileContent() {
        return this.fileContent;
    }

    @Override
    public void setFileContent(Blob fileContent) {
        this.fileContent = fileContent;
    }

    @Override
    public String getTitle() throws ClientException {
        DocumentModel previousPost;
        String previousId = this.commentManagerActions.getSavedReplyCommentId();
        if (previousId != null && !"".equals(previousId) && (previousPost = this.documentManager.getDocument((DocumentRef)new IdRef(previousId))).getDataModel("post") != null) {
            String previousTitle = (String)previousPost.getProperty("post", "title");
            String prefix = (String)this.resourcesAccessor.getMessages().get("label.forum.post.title.prefix");
            this.title = prefix + previousTitle;
        }
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }
}

