/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIDataAdaptor;

public final class DataComponentsContextUtil {
    private static final String MODEL_RESET_ATTRIBUTE_SUFFIX = "#" + DataComponentsContextUtil.class.getName();

    private DataComponentsContextUtil() {
    }

    private static String getAttributeName(FacesContext context, UIComponent component) {
        return component.getClientId(context) + MODEL_RESET_ATTRIBUTE_SUFFIX;
    }

    public static void resetDataModelOncePerPhase(FacesContext context, UIComponent component) {
        String attributeName = DataComponentsContextUtil.getAttributeName(context, component);
        if (context.getCurrentPhaseId() != context.getAttributes().put(attributeName, context.getCurrentPhaseId())) {
            DataComponentsContextUtil.resetDataModel(context, component);
        }
    }

    private static void resetDataModel(FacesContext context, UIComponent component) {
        if (component instanceof UIDataAdaptor) {
            ((UIDataAdaptor)component).resetDataModel();
        } else if (component instanceof UIData) {
            component.setValueExpression("value", component.getValueExpression("value"));
        } else {
            throw new IllegalArgumentException(component.toString());
        }
    }
}

