/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl.plugins;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FilenameUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.InputStreamBlob;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.AbstractDocumentReader;
import org.nuxeo.ecm.core.io.impl.DWord;
import org.nuxeo.ecm.core.io.impl.ExportedDocumentImpl;
import org.nuxeo.runtime.services.streaming.FileSource;
import org.nuxeo.runtime.services.streaming.StreamSource;
import org.nuxeo.runtime.services.streaming.ZipEntrySource;

public class NuxeoArchiveReader
extends AbstractDocumentReader {
    private ZipInputStream in;
    private String file;
    private ZipFile zipFile;
    private List<String> zipIndex;
    private final Collection<File> filesToDelete = new ArrayList<File>();

    public NuxeoArchiveReader(URL url) throws IOException {
        this(url.openStream());
        if (url.getProtocol().equals("file")) {
            this.file = FileUtils.getFileFromURL((URL)url).getAbsolutePath();
        }
    }

    public NuxeoArchiveReader(File file) throws IOException {
        this.file = file.getAbsolutePath();
        this.zipFile = new ZipFile(file);
        this.buildOrderedZipIndex();
        this.checkMarker();
    }

    public NuxeoArchiveReader(InputStream in) throws IOException {
        this(new ZipInputStream(in));
    }

    public NuxeoArchiveReader(ZipInputStream in) throws IOException {
        this(in, true);
    }

    NuxeoArchiveReader(ZipInputStream in, boolean checkMarker) throws IOException {
        this.in = in;
        if (checkMarker) {
            this.checkMarker();
        }
    }

    protected void buildOrderedZipIndex() {
        this.zipIndex = new ArrayList<String>();
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            this.zipIndex.add(entry.getName());
        }
        Collections.sort(this.zipIndex, new Comparator<String>(){

            @Override
            public int compare(String spath1, String spath2) {
                return spath1.compareTo(spath2);
            }
        });
    }

    @Override
    public ExportedDocument read() throws IOException {
        if (this.zipFile != null) {
            return this.readZip();
        }
        return this.readOrderedStream();
    }

    protected ExportedDocument readZip() throws IOException {
        if (this.zipIndex.size() == 0) {
            return null;
        }
        String idxname = this.zipIndex.remove(0);
        ZipEntry entry = this.zipFile.getEntry(idxname);
        if (entry == null) {
            return null;
        }
        if (!entry.isDirectory()) {
            if (entry.getName().equals(".nuxeo-archive")) {
                return this.read();
            }
            if (entry.getName().equals("document.xml")) {
                ExportedDocumentImpl xdoc = new ExportedDocumentImpl();
                xdoc.setPath(new Path("/"));
                xdoc.setDocument(this.loadXML(entry));
                return xdoc;
            }
            throw new IOException("Invalid Nuxeo archive on entry " + entry.getName());
        }
        ArrayList<String> childEntries = new ArrayList<String>();
        int depth = new Path(idxname).removeTrailingSeparator().segmentCount();
        for (String path : this.zipIndex) {
            if (!path.startsWith(idxname)) break;
            int subdepth = new Path(path).removeTrailingSeparator().segmentCount();
            if (subdepth != depth + 1 || this.zipFile.getEntry(path).isDirectory()) continue;
            childEntries.add(path);
        }
        if (childEntries.size() == 0) {
            return this.read();
        }
        String name = entry.getName();
        ExportedDocumentImpl xdoc = new ExportedDocumentImpl();
        xdoc.setPath(new Path(name).removeTrailingSeparator());
        for (String childEntryName : childEntries) {
            int i = this.zipIndex.indexOf(childEntryName);
            idxname = this.zipIndex.remove(i);
            entry = this.zipFile.getEntry(idxname);
            name = entry.getName();
            if (name.endsWith("document.xml")) {
                xdoc.setDocument(this.loadXML(entry));
                continue;
            }
            if (name.endsWith(".xml")) {
                xdoc.putDocument(FilenameUtils.getBaseName((String)entry.getName()), this.loadXML(entry));
                continue;
            }
            xdoc.putBlob(FilenameUtils.getName((String)entry.getName()), this.createBlob(entry));
        }
        return xdoc;
    }

    protected ExportedDocument readOrderedStream() throws IOException {
        ZipEntry entry = this.in.getNextEntry();
        if (entry == null) {
            return null;
        }
        if (!entry.isDirectory()) {
            if (entry.getName().equals(".nuxeo-archive")) {
                return this.read();
            }
            if (entry.getName().equals("document.xml")) {
                ExportedDocumentImpl xdoc = new ExportedDocumentImpl();
                xdoc.setPath(new Path("/"));
                xdoc.setDocument(this.loadXML(entry));
                return xdoc;
            }
            throw new IOException("Invalid Nuxeo archive");
        }
        int count = NuxeoArchiveReader.getFilesCount(entry);
        if (count == 0) {
            return this.read();
        }
        String name = entry.getName();
        ExportedDocumentImpl xdoc = new ExportedDocumentImpl();
        xdoc.setPath(new Path(name).removeTrailingSeparator());
        for (int i = 0; i < count; ++i) {
            entry = this.in.getNextEntry();
            name = entry.getName();
            if (name.endsWith("document.xml")) {
                xdoc.setDocument(this.loadXML(entry));
                continue;
            }
            if (name.endsWith(".xml")) {
                xdoc.putDocument(FilenameUtils.getBaseName((String)entry.getName()), this.loadXML(entry));
                continue;
            }
            xdoc.putBlob(FilenameUtils.getName((String)entry.getName()), this.createBlob(entry));
        }
        return xdoc;
    }

    @Override
    public void close() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.in = null;
            }
        }
        for (File file : this.filesToDelete) {
            file.delete();
        }
    }

    private static int getFilesCount(ZipEntry entry) throws IOException {
        byte[] bytes = entry.getExtra();
        if (bytes == null) {
            return 0;
        }
        if (bytes.length != 4) {
            throw new IOException("Invalid Nuxeo Archive");
        }
        return new DWord(bytes).getInt();
    }

    private Document loadXML(ZipEntry entry) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (this.zipFile != null) {
                FileUtils.copy((InputStream)this.zipFile.getInputStream(entry), (OutputStream)baos);
            } else if (this.file != null) {
                ZipEntrySource src = new ZipEntrySource(this.file, entry.getName());
                FileUtils.copy((InputStream)src.getStream(), (OutputStream)baos);
            } else {
                FileUtils.copy((InputStream)this.in, (OutputStream)baos);
            }
            return new SAXReader().read((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        }
        catch (DocumentException e) {
            IOException ioe = new IOException("Failed to read zip entry " + entry.getName() + ": " + e.getMessage());
            ioe.setStackTrace(e.getStackTrace());
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Blob createBlob(ZipEntry entry) throws IOException {
        if (this.zipFile != null) {
            return new InputStreamBlob(this.zipFile.getInputStream(entry));
        }
        if (this.file != null) {
            ZipEntrySource src = new ZipEntrySource(this.file, entry.getName());
            return new StreamingBlob((StreamSource)src);
        }
        File file = File.createTempFile("nuxeo-import", "blob");
        this.filesToDelete.add(file);
        try (FileOutputStream out = new FileOutputStream(file);){
            FileUtils.copy((InputStream)this.in, (OutputStream)out);
        }
        FileSource src = new FileSource(file);
        return new StreamingBlob((StreamSource)src);
    }

    private void checkMarker() throws IOException {
        if (this.zipFile == null) {
            ZipEntry entry = this.in.getNextEntry();
            if (entry == null) {
                throw new IOException("Not a valid Nuxeo Archive - no marker file found (unexpected end of zip)");
            }
            if (!NuxeoArchiveReader.isMarkerEntry(entry)) {
                throw new IOException("Not a valid Nuxeo Archive - no marker file found");
            }
        } else if (!this.zipIndex.contains(".nuxeo-archive")) {
            throw new IOException("Not a valid Nuxeo Archive - no marker file found");
        }
    }

    public static boolean isMarkerEntry(ZipEntry entry) {
        return entry.getName().equals(".nuxeo-archive");
    }
}

