/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation;

import java.util.LinkedList;
import java.util.List;
import org.nuxeo.ecm.automation.OperationCompoundException;
import org.nuxeo.ecm.automation.OperationException;

public class OperationCompoundExceptionBuilder {
    protected final List<OperationException> accumulated = new LinkedList<OperationException>();

    protected OperationException newThrowable(List<OperationException> causes) {
        return new OperationCompoundException(this.getMessages(causes), causes.toArray(new OperationException[causes.size()]));
    }

    protected String getMessages(List<OperationException> causes) {
        StringBuilder stringBuilder = new StringBuilder();
        for (OperationException operationException : causes) {
            stringBuilder.append(operationException.getMessage());
            stringBuilder.append(System.getProperty("line.separator"));
        }
        return stringBuilder.toString();
    }

    public void add(OperationException error) {
        this.accumulated.add(error);
    }

    public void throwOnError() throws OperationException {
        if (this.accumulated.isEmpty()) {
            return;
        }
        throw this.newThrowable(this.accumulated);
    }
}

