/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations;

import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.scripting.Expression;
import org.nuxeo.ecm.automation.core.scripting.Scripting;
import org.nuxeo.ecm.core.api.DocumentModel;

@Operation(id="Context.RestoreDocumentInputFromScript", category="Execution Context", label="Restore input document from a script", description="Run a script and return the result Document object of the script the output of the operation")
public class RestoreDocumentInputFromScript {
    public static final String ID = "Context.RestoreDocumentInputFromScript";
    @Context
    protected OperationContext ctx;
    @Param(name="script", widget="TextArea")
    protected String script;
    private volatile Expression expr;

    @OperationMethod
    public DocumentModel run() throws Exception {
        if (this.expr == null) {
            String text = this.script.replaceAll("&lt;", "<");
            text = text.replaceAll("&gt;", ">");
            text = text.replaceAll("&amp;", "&");
            this.expr = Scripting.newExpression(text);
        }
        return (DocumentModel)this.expr.eval(this.ctx);
    }
}

