/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.model.impl.primitives;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyConversionException;
import org.nuxeo.ecm.core.api.model.PropertyRuntimeException;
import org.nuxeo.ecm.core.api.model.impl.ScalarProperty;
import org.nuxeo.ecm.core.schema.types.Field;

public class BinaryProperty
extends ScalarProperty {
    private static final long serialVersionUID = 1L;

    public BinaryProperty(Property parent, Field field, int flags) {
        super(parent, field, flags);
    }

    @Override
    public boolean isNormalized(Object value) {
        return value == null || value instanceof InputStream;
    }

    @Override
    public Serializable normalize(Object value) throws PropertyConversionException {
        if (this.isNormalized(value)) {
            return (Serializable)value;
        }
        throw new PropertyConversionException(value.getClass(), InputStream.class);
    }

    @Override
    public <T> T convertTo(Serializable value, Class<T> toType) throws PropertyConversionException {
        if (value == null) {
            return null;
        }
        if (InputStream.class.isAssignableFrom(toType)) {
            return (T)value;
        }
        if (toType == String.class) {
            try {
                return (T)FileUtils.read((InputStream)((InputStream)((Object)value)));
            }
            catch (IOException e) {
                throw new PropertyRuntimeException("Failed to read given input stream", e);
            }
        }
        if (toType == byte[].class) {
            try {
                return (T)FileUtils.readBytes((InputStream)((InputStream)((Object)value)));
            }
            catch (IOException e) {
                throw new PropertyRuntimeException("Failed to read given input stream", e);
            }
        }
        throw new PropertyConversionException(value.getClass(), toType);
    }

    @Override
    public Object newInstance() {
        return new ByteArrayInputStream("".getBytes());
    }
}

