/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.impl.EventImpl;

public abstract class AbstractEventContext
implements EventContext {
    private static final long serialVersionUID = 1L;
    protected static final Object[] EMPTY = new Object[0];
    protected Object[] args;
    protected Map<String, Serializable> properties;
    protected String repositoryName;

    protected AbstractEventContext() {
    }

    protected AbstractEventContext(Object ... args) {
        this.args = args == null || args.length == 1 && args[0] == null ? EMPTY : args;
    }

    @Override
    public Object[] getArguments() {
        return this.args;
    }

    @Override
    public Map<String, Serializable> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, Serializable>();
        }
        return this.properties;
    }

    @Override
    public void setProperties(Map<String, Serializable> properties) {
        this.properties = properties;
    }

    @Override
    public Serializable getProperty(String key) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Serializable>();
        }
        return this.properties.get(key);
    }

    @Override
    public boolean hasProperty(String key) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Serializable>();
        }
        return this.properties.containsKey(key);
    }

    @Override
    public void setProperty(String key, Serializable value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Serializable>();
        }
        this.properties.put(key, value);
    }

    @Override
    public Event newEvent(String name) {
        return new EventImpl(name, this);
    }

    @Override
    public Event newEvent(String name, int flags) {
        return new EventImpl(name, this, flags);
    }

    @Override
    public String getRepositoryName() {
        return this.repositoryName;
    }

    @Override
    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }
}

