/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.relations.io;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.io.DocumentTranslationMap;
import org.nuxeo.ecm.platform.io.api.AbstractIOResourceAdapter;
import org.nuxeo.ecm.platform.io.api.IOResources;
import org.nuxeo.ecm.platform.relations.api.Graph;
import org.nuxeo.ecm.platform.relations.api.Literal;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.QNameResource;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.api.Subject;
import org.nuxeo.ecm.platform.relations.api.impl.RelationDate;
import org.nuxeo.ecm.platform.relations.api.impl.ResourceImpl;
import org.nuxeo.ecm.platform.relations.api.impl.StatementImpl;
import org.nuxeo.ecm.platform.relations.io.IORelationGraphHelper;
import org.nuxeo.ecm.platform.relations.io.IORelationResources;
import org.nuxeo.runtime.api.Framework;

public class IORelationAdapter
extends AbstractIOResourceAdapter {
    private static final Log log = LogFactory.getLog(IORelationAdapter.class);
    private static final long serialVersionUID = -3661302796286246086L;

    public void setProperties(Map<String, Serializable> properties) {
        if (properties != null) {
            for (Map.Entry<String, Serializable> prop : properties.entrySet()) {
                String propName = prop.getKey();
                Serializable propValue = prop.getValue();
                if ("graph".equals(propName)) {
                    this.setStringProperty(propName, propValue);
                }
                if ("import-graph".equals(propName)) {
                    this.setStringProperty(propName, propValue);
                }
                if ("ignore-external".equals(propName)) {
                    this.setBooleanProperty(propName, propValue);
                }
                if ("ignore-literals".equals(propName)) {
                    this.setBooleanProperty(propName, propValue);
                }
                if ("ignore-simple-resources".equals(propName)) {
                    this.setBooleanProperty(propName, propValue);
                }
                if ("filter-predicates".equals(propName)) {
                    this.setStringArrayProperty(propName, propValue);
                }
                if ("ignore-predicates".equals(propName)) {
                    this.setStringArrayProperty(propName, propValue);
                }
                if ("filter-metatada".equals(propName)) {
                    this.setStringArrayProperty(propName, propValue);
                }
                if ("ignore-metatada".equals(propName)) {
                    this.setStringArrayProperty(propName, propValue);
                }
                if ("ignore-all-metatada".equals(propName)) {
                    this.setBooleanProperty(propName, propValue);
                }
                if (!"update-date-metatada".equals(propName)) continue;
                this.setStringArrayProperty(propName, propValue);
            }
        }
        if (this.properties == null || this.getStringProperty("graph") == null) {
            log.warn((Object)"No graph name given for relations adapter, no IO will be performed with this adapter");
        }
    }

    protected RelationManager getRelationManager() throws Exception {
        return (RelationManager)Framework.getService(RelationManager.class);
    }

    protected List<Statement> getMatchingStatements(Graph graph, Resource resource) throws CloneNotSupportedException {
        ArrayList<Statement> matching = new ArrayList<Statement>();
        StatementImpl incomingPattern = new StatementImpl(null, null, (Node)resource);
        matching.addAll(graph.getStatements((Statement)incomingPattern));
        StatementImpl outgoingPattern = new StatementImpl((Node)resource, null, null);
        matching.addAll(graph.getStatements((Statement)outgoingPattern));
        return this.filterMatchingStatements(matching);
    }

    protected Statement getFilteredStatement(Statement statement) throws CloneNotSupportedException {
        Subject subject = statement.getSubject();
        Resource predicate = statement.getPredicate();
        Node object = statement.getObject();
        if (this.getBooleanProperty("ignore-literals") && object.isLiteral()) {
            return null;
        }
        if (!(!this.getBooleanProperty("ignore-simple-resources") || subject.isQNameResource() && object.isQNameResource())) {
            return null;
        }
        String[] filteredPredicates = this.getStringArrayProperty("filter-predicates");
        if (filteredPredicates != null && !Arrays.asList(filteredPredicates).contains(predicate.getUri())) {
            return null;
        }
        String[] ignoredPredicates = this.getStringArrayProperty("ignore-predicates");
        if (ignoredPredicates != null && Arrays.asList(ignoredPredicates).contains(predicate.getUri())) {
            return null;
        }
        if (this.getBooleanProperty("ignore-all-metatada")) {
            Statement newStatement = (Statement)statement.clone();
            newStatement.deleteProperties();
            return newStatement;
        }
        String[] filterMetadata = this.getStringArrayProperty("filter-metatada");
        if (filterMetadata != null) {
            Statement newStatement = (Statement)statement.clone();
            Map props = newStatement.getProperties();
            List<String> filter = Arrays.asList(filterMetadata);
            for (Map.Entry prop : props.entrySet()) {
                Resource propKey = (Resource)prop.getKey();
                if (filter.contains(propKey.getUri())) continue;
                newStatement.deleteProperty(propKey);
            }
            return newStatement;
        }
        String[] ignoreMetadata = this.getStringArrayProperty("ignore-metatada");
        if (ignoreMetadata != null) {
            Statement newStatement = (Statement)statement.clone();
            Map props = newStatement.getProperties();
            List<String> filter = Arrays.asList(ignoreMetadata);
            for (Map.Entry prop : props.entrySet()) {
                Resource propKey = (Resource)prop.getKey();
                if (!filter.contains(propKey.getUri())) continue;
                newStatement.deleteProperty(propKey);
            }
            return newStatement;
        }
        return statement;
    }

    protected List<Statement> filterMatchingStatements(List<Statement> statements) throws CloneNotSupportedException {
        ArrayList<Statement> newStatements = null;
        if (statements != null) {
            newStatements = new ArrayList<Statement>();
            for (Statement stmt : statements) {
                Statement newStmt = this.getFilteredStatement(stmt);
                if (newStmt == null) continue;
                newStatements.add(newStmt);
            }
        }
        return newStatements;
    }

    protected DocumentRef getDocumentRef(RelationManager relManager, QNameResource resource) {
        String ns = resource.getNamespace();
        if ("http://www.nuxeo.org/document/uid/".equals(ns)) {
            String id = resource.getLocalName();
            int p = id.indexOf(47);
            if (p > -1) {
                id = id.substring(p + 1);
            }
            return new IdRef(id);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IOResources extractResources(String repo, Collection<DocumentRef> sources) {
        if (sources == null) return null;
        if (sources.isEmpty()) {
            return null;
        }
        String graphName = this.getStringProperty("graph");
        if (graphName == null) {
            log.error((Object)"Cannot extract resources, no graph supplied");
            return null;
        }
        try (CoreSession session = CoreInstance.openCoreSessionSystem((String)repo);){
            RelationManager relManager = this.getRelationManager();
            Graph graph = relManager.getGraphByName(graphName);
            if (graph == null) {
                log.error((Object)("Cannot resolve graph " + graphName));
                IOResources iOResources = null;
                return iOResources;
            }
            HashMap<DocumentRef, Set<Resource>> docResources = new HashMap<DocumentRef, Set<Resource>>();
            Set emptySet = Collections.emptySet();
            ArrayList<Statement> statements = new ArrayList<Statement>();
            HashSet allResources = new HashSet();
            for (DocumentRef docRef : sources) {
                try {
                    DocumentModel doc = session.getDocument(docRef);
                    Map<String, CoreSession> context = Collections.singletonMap("CoreSession", session);
                    Set resources = relManager.getAllResources((Serializable)doc, context);
                    docResources.put(docRef, resources);
                    allResources.addAll(resources);
                    for (Resource resource : resources) {
                        statements.addAll(this.getMatchingStatements(graph, resource));
                    }
                }
                catch (ClientException e) {
                    docResources.put(docRef, emptySet);
                }
            }
            Map namespaces = graph.getNamespaces();
            IORelationGraphHelper graphHelper = new IORelationGraphHelper(namespaces, statements);
            Graph memoryGraph = graphHelper.getGraph();
            ArrayList<Statement> toRemove = new ArrayList<Statement>();
            if (this.getBooleanProperty("ignore-external")) {
                for (Statement stmt : memoryGraph.getStatements()) {
                    Subject subject = stmt.getSubject();
                    if (subject.isQNameResource() && !allResources.contains(subject)) {
                        toRemove.add(stmt);
                        continue;
                    }
                    Node object = stmt.getObject();
                    if (!object.isQNameResource() || allResources.contains(subject)) continue;
                    toRemove.add(stmt);
                }
            }
            memoryGraph.remove(toRemove);
            IORelationResources iORelationResources = new IORelationResources(namespaces, docResources, memoryGraph.getStatements());
            return iORelationResources;
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public void getResourcesAsXML(OutputStream out, IOResources resources) {
        if (!(resources instanceof IORelationResources)) {
            return;
        }
        try {
            IORelationResources relResources = (IORelationResources)resources;
            Map<String, String> namespaces = relResources.getNamespaces();
            List<Statement> statements = relResources.getStatements();
            IORelationGraphHelper graphHelper = new IORelationGraphHelper(namespaces, statements);
            graphHelper.write(out);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    private void addResourceEntry(RelationManager relManager, Map<DocumentRef, Set<Resource>> map, Node node) {
        if (!node.isQNameResource()) {
            return;
        }
        QNameResource resource = (QNameResource)node;
        DocumentRef docRef = this.getDocumentRef(relManager, resource);
        if (docRef == null) {
            return;
        }
        if (map.containsKey(docRef)) {
            map.get(docRef).add((Resource)resource);
        } else {
            HashSet<QNameResource> set = new HashSet<QNameResource>();
            set.add(resource);
            map.put(docRef, set);
        }
    }

    public IOResources loadResourcesFromXML(InputStream in) {
        try {
            Graph graph;
            RelationManager relManager = this.getRelationManager();
            String graphName = this.getStringProperty("import-graph");
            if (graphName == null) {
                graphName = this.getStringProperty("graph");
            }
            Map namespaces = null;
            if (graphName != null && (graph = relManager.getGraphByName(graphName)) != null) {
                namespaces = graph.getNamespaces();
            }
            IORelationGraphHelper graphHelper = new IORelationGraphHelper(namespaces, null);
            graphHelper.read(in);
            List<Statement> statements = this.filterMatchingStatements(graphHelper.getStatements());
            HashMap<DocumentRef, Set<Resource>> docResources = new HashMap<DocumentRef, Set<Resource>>();
            for (Statement statement : statements) {
                Subject subject = statement.getSubject();
                this.addResourceEntry(relManager, docResources, (Node)subject);
                Node object = statement.getObject();
                this.addResourceEntry(relManager, docResources, object);
            }
            return new IORelationResources(namespaces, docResources, statements);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public void storeResources(IOResources resources) {
        if (!(resources instanceof IORelationResources)) {
            return;
        }
        IORelationResources relResources = (IORelationResources)resources;
        String graphName = this.getStringProperty("import-graph");
        if (graphName == null) {
            graphName = this.getStringProperty("graph");
        }
        if (graphName == null) {
            log.error((Object)"Cannot find graph name");
            return;
        }
        try {
            RelationManager relManager = this.getRelationManager();
            Graph graph = relManager.getGraphByName(graphName);
            if (graph == null) {
                log.error((Object)("Cannot find graph with name " + graphName));
                return;
            }
            graph.add(relResources.getStatements());
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    protected static Statement updateDate(Statement statement, Literal newDate, List<Resource> properties) {
        for (Resource property : properties) {
            if (statement.getProperty(property) == null) continue;
            statement.setProperty(property, (Node)newDate);
        }
        return statement;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IOResources translateResources(String repo, IOResources resources, DocumentTranslationMap map) {
        if (map == null) {
            return null;
        }
        if (!(resources instanceof IORelationResources)) {
            return resources;
        }
        try (CoreSession session = CoreInstance.openCoreSessionSystem((String)repo);){
            IORelationResources relResources = (IORelationResources)resources;
            Map<String, String> namespaces = relResources.getNamespaces();
            IORelationGraphHelper graphHelper = new IORelationGraphHelper(namespaces, relResources.getStatements());
            Graph graph = graphHelper.getGraph();
            RelationManager relManager = this.getRelationManager();
            Literal newDate = RelationDate.getLiteralDate((Date)new Date());
            String[] dateUris = this.getStringArrayProperty("update-date-metatada");
            ArrayList<Resource> dateProperties = new ArrayList<Resource>();
            if (dateUris != null) {
                for (String dateUri : dateUris) {
                    dateProperties.add((Resource)new ResourceImpl(dateUri));
                }
            }
            Object iORelationResources = relResources.getResourcesMap().entrySet().iterator();
            block14: while (true) {
                if (!iORelationResources.hasNext()) {
                    iORelationResources = new IORelationResources(namespaces, relResources.getResourcesMap(), graph.getStatements());
                    return iORelationResources;
                }
                Map.Entry entry = (Map.Entry)iORelationResources.next();
                DocumentRef oldRef = (DocumentRef)entry.getKey();
                DocumentRef newRef = (DocumentRef)map.getDocRefMap().get(oldRef);
                Set<Resource> docResources = relResources.getDocumentResources(oldRef);
                Iterator<Resource> iterator = docResources.iterator();
                while (true) {
                    Statement newStatement;
                    DocumentModel newDoc;
                    if (!iterator.hasNext()) continue block14;
                    Resource resource = iterator.next();
                    if (!resource.isQNameResource() || oldRef.equals(newRef)) continue;
                    StatementImpl pattern = new StatementImpl((Node)resource, null, null);
                    List outgoing = graph.getStatements((Statement)pattern);
                    pattern = new StatementImpl(null, null, (Node)resource);
                    List incoming = graph.getStatements((Statement)pattern);
                    graph.remove(outgoing);
                    graph.remove(incoming);
                    if (newRef == null) continue;
                    try {
                        newDoc = session.getDocument(newRef);
                    }
                    catch (ClientException e) {
                        continue;
                    }
                    QNameResource qnameRes = (QNameResource)resource;
                    Map<String, CoreSession> context = Collections.singletonMap("CoreSession", session);
                    Resource newResource = relManager.getResource(qnameRes.getNamespace(), (Serializable)newDoc, context);
                    ArrayList<Statement> newOutgoing = new ArrayList<Statement>();
                    for (Statement stmt : outgoing) {
                        newStatement = (Statement)stmt.clone();
                        newStatement.setSubject((Node)newResource);
                        if (dateProperties != null) {
                            newStatement = IORelationAdapter.updateDate(newStatement, newDate, dateProperties);
                        }
                        newOutgoing.add(newStatement);
                    }
                    graph.add(newOutgoing);
                    ArrayList<Statement> newIncoming = new ArrayList<Statement>();
                    for (Statement stmt : incoming) {
                        newStatement = (Statement)stmt.clone();
                        newStatement.setObject((Node)newResource);
                        if (dateProperties != null) {
                            newStatement = IORelationAdapter.updateDate(newStatement, newDate, dateProperties);
                        }
                        newIncoming.add(newStatement);
                    }
                    graph.add(newIncoming);
                }
                break;
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            return null;
        }
    }
}

