/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.server.impl.atompub.AbstractAtomPubServiceCall;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomEntry;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomEntryParser;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomFeed;
import org.apache.chemistry.opencmis.server.shared.ThresholdOutputStreamFactory;

public class PolicyService {

    public static class RemovePolicy
    extends AbstractAtomPubServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = this.getStringParameter(request, "id");
            String policyId = this.getStringParameter(request, "policyId");
            if (this.stopBeforeService(service)) {
                return;
            }
            service.removePolicy(repositoryId, policyId, objectId, null);
            if (this.stopAfterService(service)) {
                return;
            }
            response.setStatus(204);
        }
    }

    public static class ApplyPolicy
    extends AbstractPoliciesServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = this.getStringParameter(request, "id");
            ThresholdOutputStreamFactory streamFactory = (ThresholdOutputStreamFactory)context.get("streamFactory");
            AtomEntryParser parser = new AtomEntryParser((InputStream)request.getInputStream(), streamFactory);
            if (this.stopBeforeService(service)) {
                return;
            }
            service.applyPolicy(repositoryId, parser.getId(), objectId, null);
            if (this.stopAfterService(service)) {
                return;
            }
            ObjectInfo objectInfo = service.getObjectInfo(repositoryId, parser.getId());
            if (objectInfo == null) {
                throw new CmisRuntimeException("Object Info is missing!");
            }
            ObjectData policy = objectInfo.getObject();
            if (policy == null) {
                throw new CmisRuntimeException("Policy is null!");
            }
            UrlBuilder baseUrl = this.compileBaseUrl(request, repositoryId);
            UrlBuilder location = this.compileUrlBuilder(baseUrl, "policies", objectId);
            location.addParameter("policyId", (Object)policy.getId());
            response.setStatus(201);
            response.setContentType("application/atom+xml;type=entry");
            response.setHeader("Content-Location", location.toString());
            response.setHeader("Location", location.toString());
            AtomEntry entry = new AtomEntry();
            entry.startDocument((OutputStream)response.getOutputStream(), this.getNamespaces(service));
            this.writePolicyEntry(service, entry, objectId, policy, repositoryId, baseUrl, context.getCmisVersion());
            entry.endDocument();
        }
    }

    public static class GetAppliedPolicies
    extends AbstractPoliciesServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = this.getStringParameter(request, "id");
            String filter = this.getStringParameter(request, "filter");
            if (this.stopBeforeService(service)) {
                return;
            }
            List policies = service.getAppliedPolicies(repositoryId, objectId, filter, null);
            if (this.stopAfterService(service)) {
                return;
            }
            if (policies == null) {
                throw new CmisRuntimeException("Policies are null!");
            }
            ObjectInfo objectInfo = service.getObjectInfo(repositoryId, objectId);
            if (objectInfo == null) {
                throw new CmisRuntimeException("Object Info is missing!");
            }
            response.setStatus(200);
            response.setContentType("application/atom+xml;type=feed");
            AtomFeed feed = new AtomFeed();
            feed.startDocument((OutputStream)response.getOutputStream(), this.getNamespaces(service));
            feed.startFeed(true);
            feed.writeFeedElements(objectInfo.getId(), objectInfo.getAtomId(), objectInfo.getCreatedBy(), objectInfo.getName(), objectInfo.getLastModificationDate(), null, null);
            UrlBuilder baseUrl = this.compileBaseUrl(request, repositoryId);
            feed.writeServiceLink(baseUrl.toString(), repositoryId);
            UrlBuilder selfLink = this.compileUrlBuilder(baseUrl, "policies", objectInfo.getId());
            selfLink.addParameter("filter", (Object)filter);
            feed.writeSelfLink(selfLink.toString(), null);
            AtomEntry entry = new AtomEntry(feed.getWriter());
            for (ObjectData policy : policies) {
                if (policy == null) continue;
                this.writePolicyEntry(service, entry, objectInfo.getId(), policy, repositoryId, baseUrl, context.getCmisVersion());
            }
            feed.endFeed();
            feed.endDocument();
        }
    }

    public static abstract class AbstractPoliciesServiceCall
    extends AbstractAtomPubServiceCall {
        protected void writePolicyEntry(CmisService service, AtomEntry entry, String objectId, ObjectData policy, String repositoryId, UrlBuilder baseUrl, CmisVersion cmisVersion) throws Exception {
            ObjectInfo info = service.getObjectInfo(repositoryId, policy.getId());
            if (info == null) {
                throw new CmisRuntimeException("Object Info not found!");
            }
            entry.startEntry(false);
            entry.writeObject(policy, info, null, null, null, null, cmisVersion);
            UrlBuilder selfLink = this.compileUrlBuilder(baseUrl, "policies", objectId);
            selfLink.addParameter("policyId", (Object)info.getId());
            entry.writeSelfLink(selfLink.toString(), null);
            entry.endEntry();
        }
    }
}

