/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.core.convert.service.ConvertOption;

public class MimeTypeTranslationHelper {
    protected final Log log = LogFactory.getLog(MimeTypeTranslationHelper.class);
    protected final Map<String, List<ConvertOption>> srcMappings = new HashMap<String, List<ConvertOption>>();
    protected final Map<String, List<ConvertOption>> dstMappings = new HashMap<String, List<ConvertOption>>();

    public void addConverter(ConverterDescriptor desc) {
        List<String> sMts = desc.getSourceMimeTypes();
        String dMt = desc.getDestinationMimeType();
        List<ConvertOption> dco = this.dstMappings.get(dMt);
        if (dco == null) {
            dco = new ArrayList<ConvertOption>();
        }
        for (String sMT : sMts) {
            List<ConvertOption> sco = this.srcMappings.get(sMT);
            if (sco == null) {
                sco = new ArrayList<ConvertOption>();
            }
            sco.add(new ConvertOption(desc.getConverterName(), dMt));
            this.srcMappings.put(sMT, sco);
            dco.add(new ConvertOption(desc.getConverterName(), sMT));
        }
        this.dstMappings.put(dMt, dco);
        this.log.debug((Object)("Added converter " + desc.getSourceMimeTypes() + " to " + desc.getDestinationMimeType()));
    }

    public String getConverterName(String sourceMimeType, String destMimeType) {
        List<ConvertOption> sco = this.srcMappings.get(sourceMimeType);
        if (sco == null && (sco = this.srcMappings.get("*")) == null) {
            return null;
        }
        for (ConvertOption co : sco) {
            if (!co.mimeType.equals(destMimeType)) continue;
            return co.getConverterName();
        }
        return null;
    }

    public List<String> getConverterNames(String sourceMimeType, String destMimeType) {
        List<ConvertOption> sco = this.srcMappings.get(sourceMimeType);
        ArrayList<String> converterNames = new ArrayList<String>();
        if (sco == null && (sco = this.srcMappings.get("*")) == null) {
            return converterNames;
        }
        for (ConvertOption co : sco) {
            if (!co.mimeType.equals(destMimeType)) continue;
            converterNames.add(co.getConverterName());
        }
        return converterNames;
    }

    public List<String> getDestinationMimeTypes(String sourceMimeType) {
        ArrayList<String> dst = new ArrayList<String>();
        List<ConvertOption> sco = this.srcMappings.get(sourceMimeType);
        if (sco != null) {
            for (ConvertOption co : sco) {
                dst.add(co.getMimeType());
            }
        }
        return dst;
    }

    public List<String> getSourceMimeTypes(String destinationMimeType) {
        ArrayList<String> src = new ArrayList<String>();
        List<ConvertOption> dco = this.dstMappings.get(destinationMimeType);
        if (dco != null) {
            for (ConvertOption co : dco) {
                src.add(co.getMimeType());
            }
        }
        return src;
    }

    public void clear() {
        this.dstMappings.clear();
        this.srcMappings.clear();
        this.log.debug((Object)"clear");
    }
}

