/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Set;
import javax.transaction.xa.XAResource;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.query.QueryFilter;
import org.nuxeo.ecm.core.storage.PartialList;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.binary.BinaryGarbageCollector;
import org.nuxeo.ecm.core.storage.sql.Invalidations;
import org.nuxeo.ecm.core.storage.sql.RowMapper;

public interface Mapper
extends RowMapper,
XAResource {
    public static final String GET_IDENTIFICATION = "getIdentification";
    public static final String CLOSE = "close";

    public Identification getIdentification() throws StorageException;

    public void close() throws StorageException;

    public int getTableSize(String var1) throws StorageException;

    public void createDatabase(String var1) throws StorageException;

    public Serializable getRootId(String var1) throws StorageException;

    public void setRootId(Serializable var1, Serializable var2) throws StorageException;

    public PartialList<Serializable> query(String var1, String var2, QueryFilter var3, boolean var4) throws StorageException;

    public PartialList<Serializable> query(String var1, String var2, QueryFilter var3, long var4) throws StorageException;

    public IterableQueryResult queryAndFetch(String var1, String var2, QueryFilter var3, Object ... var4) throws StorageException;

    public Set<Serializable> getAncestorsIds(Collection<Serializable> var1) throws StorageException;

    public void updateReadAcls() throws StorageException;

    public void rebuildReadAcls() throws StorageException;

    public int getClusterNodeIdType();

    public void createClusterNode(Serializable var1) throws StorageException;

    public void removeClusterNode(Serializable var1) throws StorageException;

    public void insertClusterInvalidations(Serializable var1, Invalidations var2) throws StorageException;

    public Invalidations getClusterInvalidations(Serializable var1) throws StorageException;

    public Lock getLock(Serializable var1) throws StorageException;

    public Lock setLock(Serializable var1, Lock var2) throws StorageException;

    public Lock removeLock(Serializable var1, String var2, boolean var3) throws StorageException;

    public void markReferencedBinaries(BinaryGarbageCollector var1) throws StorageException;

    public int cleanupDeletedRows(int var1, Calendar var2) throws StorageException;

    public boolean isConnected();

    public void connect() throws StorageException;

    public void disconnect();

    public static final class Identification
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final String repositoryId;
        public final String mapperId;

        public Identification(String repositoryId, String mapperId) {
            this.repositoryId = repositoryId;
            this.mapperId = mapperId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + '(' + this.repositoryId + ',' + this.mapperId + ')';
        }
    }
}

