/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.CollectionFragment;
import org.nuxeo.ecm.core.storage.sql.Fragment;
import org.nuxeo.ecm.core.storage.sql.Invalidations;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.PropertyType;
import org.nuxeo.ecm.core.storage.sql.Row;
import org.nuxeo.ecm.core.storage.sql.RowId;
import org.nuxeo.ecm.core.storage.sql.RowMapper;
import org.nuxeo.ecm.core.storage.sql.SelectionContext;
import org.nuxeo.ecm.core.storage.sql.SelectionType;
import org.nuxeo.ecm.core.storage.sql.SessionImpl;
import org.nuxeo.ecm.core.storage.sql.SimpleFragment;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.metrics.MetricsService;

public class PersistenceContext {
    protected static final Log log = LogFactory.getLog(PersistenceContext.class);
    public static final String SEL_WARN_THRESHOLD_PROP = "org.nuxeo.vcs.selection.warn.threshold";
    public static final String SEL_WARN_THRESHOLD_DEFAULT = "15000";
    protected static final SimpleFragment.FieldComparator POS_COMPARATOR = new SimpleFragment.FieldComparator("pos");
    protected static final SimpleFragment.FieldComparator VER_CREATED_COMPARATOR = new SimpleFragment.FieldComparator("created");
    protected final Model model;
    protected final RowMapper mapper;
    protected final SessionImpl session;
    protected final SelectionContext hierComplex;
    public final SelectionContext hierNonComplex;
    private final SelectionContext seriesVersions;
    private final SelectionContext seriesProxies;
    private final SelectionContext targetProxies;
    private final List<SelectionContext> selections;
    protected final Map<RowId, Fragment> pristine;
    protected final Map<RowId, Fragment> modified;
    private final Set<Serializable> createdIds;
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected final Counter cacheCount;
    protected final Counter cacheHitCount;
    protected long bigSelWarnThreshold;

    public PersistenceContext(Model model, RowMapper mapper, SessionImpl session) throws StorageException {
        this.model = model;
        this.mapper = mapper;
        this.session = session;
        this.hierComplex = new SelectionContext(SelectionType.CHILDREN, Boolean.TRUE, mapper, this);
        this.hierNonComplex = new SelectionContext(SelectionType.CHILDREN, Boolean.FALSE, mapper, this);
        this.seriesVersions = new SelectionContext(SelectionType.SERIES_VERSIONS, null, mapper, this);
        this.selections = new ArrayList<SelectionContext>(Arrays.asList(this.hierComplex, this.hierNonComplex, this.seriesVersions));
        if (model.proxiesEnabled) {
            this.seriesProxies = new SelectionContext(SelectionType.SERIES_PROXIES, null, mapper, this);
            this.targetProxies = new SelectionContext(SelectionType.TARGET_PROXIES, null, mapper, this);
            this.selections.add(this.seriesProxies);
            this.selections.add(this.targetProxies);
        } else {
            this.seriesProxies = null;
            this.targetProxies = null;
        }
        this.pristine = new ReferenceMap(0, 2);
        this.modified = new HashMap<RowId, Fragment>();
        this.createdIds = new LinkedHashSet<Serializable>();
        this.cacheCount = this.registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"repositories", session.getRepositoryName(), "caches", "count"}));
        this.cacheHitCount = this.registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"repositories", session.getRepositoryName(), "caches", "hit"}));
        try {
            this.bigSelWarnThreshold = Long.parseLong(Framework.getProperty((String)SEL_WARN_THRESHOLD_PROP, (String)SEL_WARN_THRESHOLD_DEFAULT));
        }
        catch (NumberFormatException e) {
            log.error((Object)("Invalid value for org.nuxeo.vcs.selection.warn.threshold: " + Framework.getProperty((String)SEL_WARN_THRESHOLD_PROP)));
        }
    }

    protected int clearCaches() {
        this.mapper.clearCache();
        int n = this.clearLocalCaches();
        this.modified.clear();
        this.createdIds.clear();
        return n;
    }

    protected int clearLocalCaches() {
        for (SelectionContext sel : this.selections) {
            sel.clearCaches();
        }
        int n = this.pristine.size();
        this.pristine.clear();
        return n;
    }

    protected long getCacheSize() {
        return this.getCachePristineSize() + this.getCacheSelectionSize() + this.getCacheMapperSize();
    }

    protected long getCacheMapperSize() {
        return this.mapper.getCacheSize();
    }

    protected long getCachePristineSize() {
        return this.pristine.size();
    }

    protected long getCacheSelectionSize() {
        int size = 0;
        for (SelectionContext sel : this.selections) {
            size += sel.getSize();
        }
        return size;
    }

    protected Serializable generateNewId(Serializable id) throws StorageException {
        if (id == null) {
            id = this.mapper.generateNewId();
        }
        this.createdIds.add(id);
        return id;
    }

    protected boolean isIdNew(Serializable id) {
        return this.createdIds.contains(id);
    }

    protected RowMapper.RowBatch getSaveBatch(List<Fragment> fragmentsToClearDirty) throws StorageException {
        Fragment fragment;
        RowId rowId;
        RowMapper.RowBatch batch = new RowMapper.RowBatch();
        for (Serializable serializable : this.createdIds) {
            rowId = new RowId("hierarchy", serializable);
            fragment = this.modified.remove(rowId);
            if (fragment == null) continue;
            batch.creates.add(fragment.row);
            fragment.clearDirty();
            fragment.setPristine();
            this.pristine.put(rowId, fragment);
        }
        this.createdIds.clear();
        block8: for (Map.Entry entry : this.modified.entrySet()) {
            rowId = (RowId)entry.getKey();
            fragment = (Fragment)entry.getValue();
            switch (fragment.getState()) {
                case CREATED: {
                    batch.creates.add(fragment.row);
                    fragment.clearDirty();
                    fragment.setPristine();
                    this.pristine.put(rowId, fragment);
                    continue block8;
                }
                case MODIFIED: {
                    RowMapper.RowUpdate rowu = fragment.getRowUpdate();
                    if (rowu != null) {
                        batch.updates.add(rowu);
                        fragmentsToClearDirty.add(fragment);
                    }
                    fragment.setPristine();
                    this.pristine.put(rowId, fragment);
                    continue block8;
                }
                case DELETED: {
                    batch.deletes.add(new RowId(rowId));
                    fragment.setDetached();
                    continue block8;
                }
                case DELETED_DEPENDENT: {
                    batch.deletesDependent.add(new RowId(rowId));
                    fragment.setDetached();
                    continue block8;
                }
                case PRISTINE: {
                    log.error((Object)("Found PRISTINE fragment in modified map: " + fragment));
                    continue block8;
                }
            }
            throw new RuntimeException(fragment.toString());
        }
        this.modified.clear();
        for (SelectionContext selectionContext : this.selections) {
            selectionContext.postSave();
        }
        return batch;
    }

    private boolean complexProp(SimpleFragment fragment) throws StorageException {
        return this.complexProp((Boolean)fragment.get("isproperty"));
    }

    private boolean complexProp(Boolean isProperty) throws StorageException {
        return Boolean.TRUE.equals(isProperty);
    }

    private SelectionContext getHierSelectionContext(boolean complexProp) {
        return complexProp ? this.hierComplex : this.hierNonComplex;
    }

    protected void findDirtyDocuments(Set<Serializable> dirtyStrings, Set<Serializable> dirtyBinaries) throws StorageException {
        HashSet<Serializable> deleted = null;
        for (Fragment fragment : this.modified.values()) {
            Serializable docId = this.getContainingDocument(fragment.getId());
            String tableName = fragment.row.tableName;
            Fragment.State state = fragment.getState();
            switch (state) {
                case DELETED: 
                case DELETED_DEPENDENT: {
                    if ("hierarchy".equals(tableName) && fragment.getId().equals(docId)) {
                        if (deleted == null) {
                            deleted = new HashSet<Serializable>();
                        }
                        deleted.add(docId);
                    }
                    if (this.isDeleted(docId)) break;
                }
                case CREATED: {
                    PropertyType t = this.model.getFulltextInfoForFragment(tableName);
                    if (t == null) break;
                    if (t == PropertyType.STRING || t == PropertyType.BOOLEAN) {
                        dirtyStrings.add(docId);
                    }
                    if (t != PropertyType.BINARY && t != PropertyType.BOOLEAN) break;
                    dirtyBinaries.add(docId);
                    break;
                }
                case MODIFIED: {
                    Collection<Object> keys = this.model.isCollectionFragment(tableName) ? Collections.singleton(null) : ((SimpleFragment)fragment).getDirtyKeys();
                    for (String string : keys) {
                        PropertyType type = this.model.getFulltextFieldType(tableName, string);
                        if (type == PropertyType.STRING || type == PropertyType.ARRAY_STRING) {
                            dirtyStrings.add(docId);
                            continue;
                        }
                        if (type != PropertyType.BINARY && type != PropertyType.ARRAY_BINARY) continue;
                        dirtyBinaries.add(docId);
                    }
                    break;
                }
            }
            if (deleted == null) continue;
            dirtyStrings.removeAll(deleted);
            dirtyBinaries.removeAll(deleted);
        }
    }

    protected void markInvalidated(Invalidations invalidations) {
        Fragment fragment;
        if (invalidations.modified != null) {
            for (RowId rowId : invalidations.modified) {
                fragment = this.getIfPresent(rowId);
                if (fragment == null) continue;
                this.setFragmentPristine(fragment);
                fragment.setInvalidatedModified();
            }
            for (SelectionContext sel : this.selections) {
                sel.markInvalidated(invalidations.modified);
            }
        }
        if (invalidations.deleted != null) {
            for (RowId rowId : invalidations.deleted) {
                fragment = this.getIfPresent(rowId);
                if (fragment == null) continue;
                this.setFragmentPristine(fragment);
                fragment.setInvalidatedDeleted();
            }
        }
    }

    protected void setFragmentModified(Fragment fragment) {
        Row rowId = fragment.row;
        this.pristine.remove(rowId);
        this.modified.put(rowId, fragment);
    }

    protected void setFragmentPristine(Fragment fragment) {
        Row rowId = fragment.row;
        this.modified.remove(rowId);
        this.pristine.put(rowId, fragment);
    }

    public void sendInvalidationsToOthers() throws StorageException {
        Invalidations invalidations = new Invalidations();
        for (SelectionContext sel : this.selections) {
            sel.gatherInvalidations(invalidations);
        }
        this.mapper.sendInvalidations(invalidations);
    }

    public void processReceivedInvalidations() throws StorageException {
        Invalidations.InvalidationsPair invals = this.mapper.receiveInvalidations();
        if (invals == null) {
            return;
        }
        this.processCacheInvalidations(invals.cacheInvalidations);
        this.session.sendInvalidationEvent(invals);
    }

    private void processCacheInvalidations(Invalidations invalidations) throws StorageException {
        Fragment fragment;
        if (invalidations == null) {
            return;
        }
        if (invalidations.all) {
            this.clearLocalCaches();
        }
        if (invalidations.modified != null) {
            for (RowId rowId : invalidations.modified) {
                fragment = this.pristine.remove(rowId);
                if (fragment == null) continue;
                fragment.setInvalidatedModified();
            }
            for (SelectionContext sel : this.selections) {
                sel.processReceivedInvalidations(invalidations.modified);
            }
        }
        if (invalidations.deleted != null) {
            for (RowId rowId : invalidations.deleted) {
                fragment = this.pristine.remove(rowId);
                if (fragment == null) continue;
                fragment.setInvalidatedDeleted();
            }
        }
    }

    public void checkInvalidationsConflict() {
    }

    protected Fragment getIfPresent(RowId rowId) {
        this.cacheCount.inc();
        Fragment fragment = this.pristine.get(rowId);
        if (fragment == null) {
            fragment = this.modified.get(rowId);
        }
        if (fragment != null) {
            this.cacheHitCount.inc();
        }
        return fragment;
    }

    protected Fragment get(RowId rowId, boolean allowAbsent) throws StorageException {
        Fragment fragment = this.getIfPresent(rowId);
        if (fragment == null) {
            fragment = this.getFromMapper(rowId, allowAbsent, false);
        }
        return fragment;
    }

    protected Fragment getFromMapper(RowId rowId, boolean allowAbsent, boolean cacheOnly) throws StorageException {
        List<Fragment> fragments = this.getFromMapper(Collections.singleton(rowId), allowAbsent, cacheOnly);
        return fragments.isEmpty() ? null : fragments.get(0);
    }

    protected List<Fragment> getFromMapper(Collection<RowId> rowIds, boolean allowAbsent, boolean cacheOnly) throws StorageException {
        ArrayList<Fragment> res = new ArrayList<Fragment>(rowIds.size());
        ArrayList<RowId> todo = new ArrayList<RowId>(rowIds.size());
        for (RowId rowId : rowIds) {
            if (this.isIdNew(rowId.id)) {
                Fragment fragment = this.getFragmentFromFetchedRow(rowId, allowAbsent);
                if (fragment == null) continue;
                res.add(fragment);
                continue;
            }
            todo.add(rowId);
        }
        if (todo.isEmpty()) {
            return res;
        }
        List<? extends RowId> rows = this.mapper.read(todo, cacheOnly);
        res.addAll(this.getFragmentsFromFetchedRows(rows, allowAbsent));
        return res;
    }

    public List<Fragment> getMulti(Collection<RowId> rowIds, boolean allowAbsent) throws StorageException {
        if (rowIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Fragment> res = new ArrayList<Fragment>(rowIds.size());
        LinkedList<RowId> todo = new LinkedList<RowId>();
        for (RowId rowId : rowIds) {
            Fragment fragment = this.getIfPresent(rowId);
            if (fragment == null) {
                todo.add(rowId);
                continue;
            }
            Fragment.State state = fragment.getState();
            if (state == Fragment.State.DELETED || state == Fragment.State.DELETED_DEPENDENT || state == Fragment.State.ABSENT && !allowAbsent) continue;
            res.add(fragment);
        }
        if (todo.isEmpty()) {
            return res;
        }
        List<Fragment> fetched = this.getFromMapper(todo, allowAbsent, false);
        res.addAll(fetched);
        return res;
    }

    protected List<Fragment> getFragmentsFromFetchedRows(List<? extends RowId> rowIds, boolean allowAbsent) throws StorageException {
        ArrayList<Fragment> fragments = new ArrayList<Fragment>(rowIds.size());
        for (RowId rowId : rowIds) {
            Fragment fragment = this.getFragmentFromFetchedRow(rowId, allowAbsent);
            if (fragment == null) continue;
            fragments.add(fragment);
        }
        return fragments;
    }

    protected Fragment getFragmentFromFetchedRow(RowId rowId, boolean allowAbsent) throws StorageException {
        if (rowId == null) {
            return null;
        }
        Fragment fragment = this.getIfPresent(rowId);
        if (fragment != null) {
            Fragment.State state = fragment.getState();
            if (state == Fragment.State.DELETED || state == Fragment.State.DELETED_DEPENDENT) {
                return null;
            }
            if (state == Fragment.State.INVALIDATED_MODIFIED || state == Fragment.State.INVALIDATED_DELETED) {
                throw new IllegalStateException(state.toString());
            }
            return fragment;
        }
        boolean isCollection = this.model.isCollectionFragment(rowId.tableName);
        if (rowId instanceof Row) {
            Row row = (Row)rowId;
            if (isCollection) {
                fragment = new CollectionFragment(row, Fragment.State.PRISTINE, this);
            } else {
                fragment = new SimpleFragment(row, Fragment.State.PRISTINE, this);
                for (SelectionContext sel : this.selections) {
                    if (!sel.applicable((SimpleFragment)fragment)) continue;
                    sel.recordExisting((SimpleFragment)fragment, false);
                }
            }
            return fragment;
        }
        if (allowAbsent) {
            if (isCollection) {
                Serializable[] empty = this.model.getCollectionFragmentType(rowId.tableName).getEmptyArray();
                Row row = new Row(rowId.tableName, rowId.id, empty);
                return new CollectionFragment(row, Fragment.State.ABSENT, this);
            }
            Row row = new Row(rowId.tableName, rowId.id);
            return new SimpleFragment(row, Fragment.State.ABSENT, this);
        }
        return null;
    }

    public SimpleFragment createHierarchyFragment(Row row) throws StorageException {
        SimpleFragment fragment = this.createSimpleFragment(row);
        SelectionContext hierSel = this.getHierSelectionContext(this.complexProp(fragment));
        hierSel.recordCreated(fragment);
        Serializable id = fragment.getId();
        this.hierComplex.newSelection(id);
        this.hierNonComplex.newSelection(id);
        return fragment;
    }

    private SimpleFragment createVersionFragment(Row row) throws StorageException {
        SimpleFragment fragment = this.createSimpleFragment(row);
        this.seriesVersions.recordCreated(fragment);
        if (this.model.proxiesEnabled) {
            this.targetProxies.newSelection(fragment.getId());
        }
        return fragment;
    }

    public void createdProxyFragment(SimpleFragment fragment) throws StorageException {
        if (this.model.proxiesEnabled) {
            this.seriesProxies.recordCreated(fragment);
            this.targetProxies.recordCreated(fragment);
        }
    }

    public void removedProxyTarget(SimpleFragment fragment) throws StorageException {
        if (this.model.proxiesEnabled) {
            this.targetProxies.recordRemoved(fragment);
        }
    }

    public void addedProxyTarget(SimpleFragment fragment) throws StorageException {
        if (this.model.proxiesEnabled) {
            this.targetProxies.recordCreated(fragment);
        }
    }

    private SimpleFragment createSimpleFragment(Row row) throws StorageException {
        if (this.pristine.containsKey(row) || this.modified.containsKey(row)) {
            throw new StorageException("Row already registered: " + row);
        }
        return new SimpleFragment(row, Fragment.State.CREATED, this);
    }

    public void removePropertyNode(SimpleFragment hierFragment) throws StorageException {
        LinkedList<SimpleFragment> todo = new LinkedList<SimpleFragment>();
        LinkedList<SimpleFragment> children = new LinkedList<SimpleFragment>();
        todo.add(hierFragment);
        while (!todo.isEmpty()) {
            SimpleFragment fragment = (SimpleFragment)todo.removeFirst();
            todo.addAll(this.getChildren(fragment.getId(), null, true));
            children.add(fragment);
        }
        Collections.reverse(children);
        for (SimpleFragment fragment : children) {
            boolean primary = fragment == hierFragment;
            this.removeFragmentAndDependents(fragment, primary);
            this.hierComplex.recordRemoved(fragment);
            this.hierComplex.recordRemovedSelection(fragment.getId());
        }
    }

    private void removeFragmentAndDependents(SimpleFragment hierFragment, boolean primary) throws StorageException {
        Serializable id = hierFragment.getId();
        for (String fragmentName : this.model.getTypeFragments(new RowMapper.IdWithTypes(hierFragment))) {
            RowId rowId = new RowId(fragmentName, id);
            Fragment fragment = this.get(rowId, true);
            Fragment.State state = fragment.getState();
            if (state == Fragment.State.DELETED || state == Fragment.State.DELETED_DEPENDENT) continue;
            this.removeFragment(fragment, primary && hierFragment == fragment);
        }
    }

    public void removeNode(SimpleFragment hierFragment) throws StorageException {
        Serializable versionSeriesId;
        SimpleFragment proxyFragment;
        SimpleFragment versionFragment;
        Serializable rootId = hierFragment.getId();
        this.session.removeLock(rootId, null, true);
        if ("ecm:proxy".equals(hierFragment.getString("primarytype"))) {
            versionFragment = null;
            proxyFragment = (SimpleFragment)this.get(new RowId("proxies", rootId), true);
        } else if (Boolean.TRUE.equals(hierFragment.get("isversion"))) {
            versionFragment = (SimpleFragment)this.get(new RowId("versions", rootId), true);
            proxyFragment = null;
        } else {
            versionFragment = null;
            proxyFragment = null;
        }
        RowMapper.NodeInfo rootInfo = new RowMapper.NodeInfo(hierFragment, versionFragment, proxyFragment);
        List<RowMapper.NodeInfo> infos = this.mapper.remove(rootInfo);
        for (RowMapper.NodeInfo info : infos) {
            Serializable id = info.id;
            for (String fragmentName : this.model.getTypeFragments(new RowMapper.IdWithTypes(id, info.primaryType, null))) {
                RowId rowId = new RowId(fragmentName, id);
                this.removedFragment(rowId);
            }
            this.removeFromSelections(info);
        }
        Serializable serializable = versionSeriesId = versionFragment == null ? null : versionFragment.get("versionableid");
        if (versionSeriesId != null) {
            this.recomputeVersionSeries(versionSeriesId);
        }
    }

    private void removeFromSelections(RowMapper.NodeInfo info) throws StorageException {
        Serializable id = info.id;
        if ("ecm:proxy".equals(info.primaryType)) {
            this.seriesProxies.recordRemoved(id, info.versionSeriesId);
            this.targetProxies.recordRemoved(id, info.targetId);
        }
        if (info.versionSeriesId != null && info.targetId == null) {
            this.seriesVersions.recordRemoved(id, info.versionSeriesId);
        }
        this.hierComplex.recordRemoved(info.id, info.parentId);
        this.hierNonComplex.recordRemoved(info.id, info.parentId);
        if (this.complexProp(info.isProperty)) {
            this.hierComplex.recordRemovedSelection(id);
        } else {
            this.hierComplex.recordRemovedSelection(id);
            this.hierNonComplex.recordRemovedSelection(id);
            if (this.model.proxiesEnabled) {
                this.seriesProxies.recordRemovedSelection(id);
            }
            this.seriesVersions.recordRemovedSelection(id);
            if (this.model.proxiesEnabled) {
                this.targetProxies.recordRemovedSelection(id);
            }
        }
    }

    public void removeFragment(Fragment fragment, boolean primary) throws StorageException {
        Row rowId = fragment.row;
        switch (fragment.getState()) {
            case ABSENT: 
            case INVALIDATED_DELETED: {
                this.pristine.remove(rowId);
                break;
            }
            case CREATED: {
                this.modified.remove(rowId);
                break;
            }
            case PRISTINE: 
            case INVALIDATED_MODIFIED: {
                this.pristine.remove(rowId);
                this.modified.put(rowId, fragment);
                break;
            }
            case MODIFIED: {
                break;
            }
        }
        fragment.setDeleted(primary);
    }

    private void removedFragment(RowId rowId) throws StorageException {
        Fragment fragment = this.getIfPresent(rowId);
        if (fragment == null) {
            return;
        }
        switch (fragment.getState()) {
            case PRISTINE: 
            case ABSENT: 
            case INVALIDATED_DELETED: 
            case INVALIDATED_MODIFIED: {
                this.pristine.remove(rowId);
                break;
            }
            case CREATED: 
            case MODIFIED: 
            case DELETED: 
            case DELETED_DEPENDENT: {
                log.error((Object)("Removed fragment is in invalid state: " + fragment));
                this.modified.remove(rowId);
                break;
            }
        }
        fragment.setDetached();
    }

    public void recomputeVersionSeries(Serializable versionSeriesId) throws StorageException {
        List<SimpleFragment> versFrags = this.seriesVersions.getSelectionFragments(versionSeriesId, null);
        Collections.sort(versFrags, VER_CREATED_COMPARATOR);
        Collections.reverse(versFrags);
        boolean isLatest = true;
        boolean isLatestMajor = true;
        for (SimpleFragment vsf : versFrags) {
            vsf.put("islatest", Boolean.valueOf(isLatest));
            isLatest = false;
            SimpleFragment vh = this.getHier(vsf.getId(), true);
            boolean isMajor = Long.valueOf(0L).equals(vh.get("minorversion"));
            vsf.put("islatestmajor", Boolean.valueOf(isMajor && isLatestMajor));
            if (!isMajor) continue;
            isLatestMajor = false;
        }
    }

    public List<Serializable> getVersionIds(Serializable versionSeriesId) throws StorageException {
        List<SimpleFragment> fragments = this.seriesVersions.getSelectionFragments(versionSeriesId, null);
        Collections.sort(fragments, VER_CREATED_COMPARATOR);
        return this.fragmentsIds(fragments);
    }

    public List<Serializable> getSeriesProxyIds(Serializable versionSeriesId) throws StorageException {
        List<SimpleFragment> fragments = this.seriesProxies.getSelectionFragments(versionSeriesId, null);
        return this.fragmentsIds(fragments);
    }

    public List<Serializable> getTargetProxyIds(Serializable targetId) throws StorageException {
        List<SimpleFragment> fragments = this.targetProxies.getSelectionFragments(targetId, null);
        return this.fragmentsIds(fragments);
    }

    private List<Serializable> fragmentsIds(List<? extends Fragment> fragments) {
        ArrayList<Serializable> ids = new ArrayList<Serializable>(fragments.size());
        for (Fragment fragment : fragments) {
            ids.add(fragment.getId());
        }
        return ids;
    }

    public String getPath(SimpleFragment hierFragment) throws StorageException {
        PathAndId pathAndId = this.getPathOrMissingParentId(hierFragment, true);
        return pathAndId.path;
    }

    public PathAndId getPathOrMissingParentId(SimpleFragment hierFragment, boolean fetch) throws StorageException {
        String name;
        LinkedList<String> list = new LinkedList<String>();
        Serializable parentId = null;
        while (true) {
            String name2;
            if ((name2 = hierFragment.getString("name")) == null) {
                name2 = "";
            }
            list.addFirst(name2);
            parentId = hierFragment.get("parentid");
            if (parentId == null) break;
            RowId rowId = new RowId("hierarchy", parentId);
            hierFragment = (SimpleFragment)this.getIfPresent(rowId);
            if (hierFragment != null || (hierFragment = (SimpleFragment)this.getFromMapper(rowId, false, true)) != null) continue;
            if (!fetch) {
                return new PathAndId(null, parentId);
            }
            hierFragment = (SimpleFragment)this.getFromMapper(rowId, true, false);
        }
        String path = list.size() == 1 ? ((name = (String)list.peek()).isEmpty() ? "/" : name) : StringUtils.join(list, (String)"/");
        return new PathAndId(path, null);
    }

    public Serializable getContainingDocument(Serializable id) throws StorageException {
        Serializable pid = id;
        while (pid != null) {
            SimpleFragment p = this.getHier(pid, false);
            if (p == null) {
                return null;
            }
            if (!this.complexProp(p)) {
                return pid;
            }
            pid = p.get("parentid");
        }
        return null;
    }

    protected SimpleFragment getHier(Serializable id, boolean allowAbsent) throws StorageException {
        RowId rowId = new RowId("hierarchy", id);
        return (SimpleFragment)this.get(rowId, allowAbsent);
    }

    private boolean isOrderable(Serializable parentId, boolean complexProp) throws StorageException {
        if (complexProp) {
            return true;
        }
        SimpleFragment parent = this.getHier(parentId, true);
        String typeName = parent.getString("primarytype");
        return this.model.getDocumentTypeFacets(typeName).contains("Orderable");
    }

    public boolean isDeleted(Serializable id) throws StorageException {
        while (id != null) {
            Fragment.State state;
            SimpleFragment fragment = this.getHier(id, false);
            if (fragment == null || (state = fragment.getState()) == Fragment.State.ABSENT || state == Fragment.State.DELETED || state == Fragment.State.DELETED_DEPENDENT || state == Fragment.State.INVALIDATED_DELETED) {
                return true;
            }
            id = fragment.get("parentid");
        }
        return false;
    }

    public Long getNextPos(Serializable nodeId, boolean complexProp) throws StorageException {
        if (!this.isOrderable(nodeId, complexProp)) {
            return null;
        }
        long max = -1L;
        for (SimpleFragment fragment : this.getChildren(nodeId, null, complexProp)) {
            Long pos = (Long)fragment.get("pos");
            if (pos == null || pos <= max) continue;
            max = pos;
        }
        return max + 1L;
    }

    public void orderBefore(Serializable parentId, Serializable sourceId, Serializable destId) throws StorageException {
        Long setPos;
        boolean complexProp = false;
        if (!this.isOrderable(parentId, complexProp)) {
            return;
        }
        if (sourceId.equals(destId)) {
            return;
        }
        List<SimpleFragment> fragments = this.getChildren(parentId, null, complexProp);
        int i = 0;
        SimpleFragment source = null;
        Long destPos = null;
        for (SimpleFragment fragment : fragments) {
            Long setPos2;
            Serializable id = fragment.getId();
            if (id.equals(destId)) {
                destPos = i;
                ++i;
                if (source != null) {
                    source.put("pos", destPos);
                }
            }
            if (id.equals(sourceId)) {
                --i;
                source = fragment;
                setPos2 = destPos;
            } else {
                setPos2 = i;
            }
            if (setPos2 != null && !setPos2.equals(fragment.get("pos"))) {
                fragment.put("pos", setPos2);
            }
            ++i;
        }
        if (destId == null && !(setPos = Long.valueOf(i)).equals(source.get("pos"))) {
            source.put("pos", setPos);
        }
    }

    public SimpleFragment getChildHierByName(Serializable parentId, String name, boolean complexProp) throws StorageException {
        return this.getHierSelectionContext(complexProp).getSelectionFragment(parentId, name);
    }

    public List<SimpleFragment> getChildren(Serializable parentId, String name, boolean complexProp) throws StorageException {
        List<SimpleFragment> fragments = this.getHierSelectionContext(complexProp).getSelectionFragments(parentId, name);
        if (this.isOrderable(parentId, complexProp)) {
            Collections.sort(fragments, POS_COMPARATOR);
        }
        return fragments;
    }

    protected void checkNotUnder(Serializable parentId, Serializable id, String op) throws StorageException {
        SimpleFragment p;
        Serializable pid = parentId;
        do {
            if (pid.equals(id)) {
                throw new StorageException("Cannot " + op + " a node under itself: " + parentId + " is under " + id);
            }
            p = this.getHier(pid, false);
            if (p != null) continue;
            throw new StorageException("No parent: " + pid);
        } while ((pid = p.get("parentid")) != null);
    }

    protected void checkFreeName(Serializable parentId, String name, boolean complexProp) throws StorageException {
        SimpleFragment fragment = this.getChildHierByName(parentId, name, complexProp);
        if (fragment != null) {
            throw new StorageException("Destination name already exists: " + name);
        }
    }

    public void move(Node source, Serializable parentId, String name) throws StorageException {
        Serializable id = source.getId();
        SimpleFragment hierFragment = source.getHierFragment();
        Serializable oldParentId = hierFragment.get("parentid");
        String oldName = hierFragment.getString("name");
        if (!oldParentId.equals(parentId)) {
            this.checkNotUnder(parentId, id, "move");
        } else if (oldName.equals(name)) {
            return;
        }
        boolean complexProp = this.complexProp(hierFragment);
        this.checkFreeName(parentId, name, complexProp);
        if (!oldName.equals(name)) {
            hierFragment.put("name", (Serializable)((Object)name));
        }
        this.getHierSelectionContext(complexProp).recordRemoved(hierFragment);
        hierFragment.put("parentid", parentId);
        this.getHierSelectionContext(complexProp).recordExisting(hierFragment, true);
        source.path = null;
    }

    public Serializable copy(Node source, Serializable parentId, String name) throws StorageException {
        Serializable id = source.getId();
        SimpleFragment hierFragment = source.getHierFragment();
        Serializable oldParentId = hierFragment.get("parentid");
        if (oldParentId != null && !oldParentId.equals(parentId)) {
            this.checkNotUnder(parentId, id, "copy");
        }
        this.checkFreeName(parentId, name, this.complexProp(hierFragment));
        Long pos = this.getNextPos(parentId, false);
        RowMapper.CopyResult copyResult = this.mapper.copy(new RowMapper.IdWithTypes(source), parentId, name, null);
        Serializable newId = copyResult.copyId;
        SimpleFragment copy = this.getHier(newId, false);
        this.markInvalidated(copyResult.invalidations);
        ArrayList<RowId> rowIds = new ArrayList<RowId>();
        for (Serializable proxyId : copyResult.proxyIds) {
            rowIds.add(new RowId("proxies", proxyId));
        }
        List<Fragment> fragments = this.getMulti(rowIds, true);
        for (Fragment fragment : fragments) {
            this.seriesProxies.recordExisting((SimpleFragment)fragment, true);
            this.targetProxies.recordExisting((SimpleFragment)fragment, true);
        }
        if (source.isVersion()) {
            copy.put("isversion", null);
        }
        copy.put("pos", pos);
        return newId;
    }

    public Serializable checkIn(Node node, String label, String checkinComment) throws StorageException {
        Boolean checkedIn = (Boolean)node.hierFragment.get("ischeckedin");
        if (Boolean.TRUE.equals(checkedIn)) {
            throw new StorageException("Already checked in");
        }
        if (label == null) {
            Object major = node.getSimpleProperty("ecm:majorVersion").getValue();
            Object minor = node.getSimpleProperty("ecm:minorVersion").getValue();
            if (major == null) {
                major = "0";
            }
            if (minor == null) {
                minor = "0";
            }
            label = major + "." + minor;
        }
        Serializable id = node.getId();
        RowMapper.CopyResult res = this.mapper.copy(new RowMapper.IdWithTypes(node), null, null, null);
        Serializable newId = res.copyId;
        this.markInvalidated(res.invalidations);
        SimpleFragment verHier = this.getHier(newId, false);
        verHier.put("isversion", Boolean.TRUE);
        boolean isMajor = Long.valueOf(0L).equals(verHier.get("minorversion"));
        Row row = new Row("versions", newId);
        row.putNew("versionableid", id);
        row.putNew("created", new GregorianCalendar());
        row.putNew("label", (Serializable)((Object)label));
        row.putNew("description", (Serializable)((Object)checkinComment));
        row.putNew("islatest", Boolean.TRUE);
        row.putNew("islatestmajor", Boolean.valueOf(isMajor));
        this.createVersionFragment(row);
        node.hierFragment.put("ischeckedin", Boolean.TRUE);
        node.hierFragment.put("baseversionid", newId);
        this.recomputeVersionSeries(id);
        return newId;
    }

    public void checkOut(Node node) throws StorageException {
        Boolean checkedIn = (Boolean)node.hierFragment.get("ischeckedin");
        if (!Boolean.TRUE.equals(checkedIn)) {
            throw new StorageException("Already checked out");
        }
        node.hierFragment.put("ischeckedin", Boolean.FALSE);
    }

    public void restoreVersion(Node node, Node version) throws StorageException {
        Serializable versionableId = node.getId();
        Serializable versionId = version.getId();
        List<SimpleFragment> children = this.getChildren(versionableId, null, true);
        for (SimpleFragment child : children.toArray(new SimpleFragment[children.size()])) {
            this.removePropertyNode(child);
        }
        this.session.flush();
        Row overwriteRow = new Row("hierarchy", versionableId);
        SimpleFragment versionHier = version.getHierFragment();
        for (String key : this.model.getFragmentKeysType("hierarchy").keySet()) {
            if (key.equals("parentid") || key.equals("name") || key.equals("pos") || key.equals("isproperty") || key.equals("primarytype") || key.equals("ischeckedin") || key.equals("baseversionid") || key.equals("isversion")) continue;
            overwriteRow.putNew(key, versionHier.get(key));
        }
        overwriteRow.putNew("ischeckedin", Boolean.TRUE);
        overwriteRow.putNew("baseversionid", versionId);
        overwriteRow.putNew("isversion", null);
        RowMapper.CopyResult res = this.mapper.copy(new RowMapper.IdWithTypes(version), node.getParentId(), null, overwriteRow);
        this.markInvalidated(res.invalidations);
    }

    public static class PathAndId {
        public final String path;
        public final Serializable id;

        public PathAndId(String path, Serializable id) {
            this.path = path;
            this.id = id;
        }
    }
}

