/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.Interaction;
import javax.resource.cci.LocalTransaction;
import javax.resource.cci.ResultSetInfo;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.core.event.impl.EventImpl;
import org.nuxeo.ecm.core.query.QueryFilter;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.storage.ConcurrentUpdateStorageException;
import org.nuxeo.ecm.core.storage.FulltextParser;
import org.nuxeo.ecm.core.storage.FulltextUpdaterWork;
import org.nuxeo.ecm.core.storage.PartialList;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.binary.Binary;
import org.nuxeo.ecm.core.storage.binary.BinaryGarbageCollector;
import org.nuxeo.ecm.core.storage.binary.BinaryManager;
import org.nuxeo.ecm.core.storage.binary.BinaryManagerStreamSupport;
import org.nuxeo.ecm.core.storage.sql.ACLRow;
import org.nuxeo.ecm.core.storage.sql.CachingMapper;
import org.nuxeo.ecm.core.storage.sql.Fragment;
import org.nuxeo.ecm.core.storage.sql.FragmentGroup;
import org.nuxeo.ecm.core.storage.sql.FragmentsMap;
import org.nuxeo.ecm.core.storage.sql.Invalidations;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.ModelProperty;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.PersistenceContext;
import org.nuxeo.ecm.core.storage.sql.PropertyType;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.Row;
import org.nuxeo.ecm.core.storage.sql.RowId;
import org.nuxeo.ecm.core.storage.sql.RowMapper;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.SimpleFragment;
import org.nuxeo.ecm.core.storage.sql.SimpleProperty;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLFulltextExtractorWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.metrics.MetricsService;
import org.nuxeo.runtime.services.streaming.FileSource;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class SessionImpl
implements Session,
XAResource {
    private static final Log log = LogFactory.getLog(SessionImpl.class);
    public static final String COMPAT_REPOSITORY_NAME_KEY = "org.nuxeo.vcs.repository.name.default.compat";
    private static final boolean COMPAT_REPOSITORY_NAME = Boolean.parseBoolean(Framework.getProperty((String)"org.nuxeo.vcs.repository.name.default.compat", (String)"true"));
    protected final RepositoryImpl repository;
    private final Mapper mapper;
    private final Model model;
    protected final FulltextParser fulltextParser;
    public final PersistenceContext context;
    private volatile boolean live;
    private boolean inTransaction;
    private Node rootNode;
    private long threadId;
    private String threadName;
    private Throwable threadStack;
    private boolean readAclsChanged;
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    private final Timer saveTimer;
    private final Timer queryTimer;
    private final Timer aclrUpdateTimer;
    private static final String LOG_MIN_DURATION_KEY = "org.nuxeo.vcs.query.log_min_duration_ms";
    private static final long LOG_MIN_DURATION_NS = Long.parseLong(Framework.getProperty((String)"org.nuxeo.vcs.query.log_min_duration_ms", (String)"-1")) * 1000000L;

    public SessionImpl(RepositoryImpl repository, Model model, Mapper mapper) throws StorageException {
        this.repository = repository;
        this.mapper = mapper;
        if (mapper instanceof CachingMapper) {
            ((CachingMapper)mapper).setSession(this);
        }
        this.model = model;
        this.context = new PersistenceContext(model, mapper, this);
        this.live = true;
        this.readAclsChanged = false;
        try {
            this.fulltextParser = repository.fulltextParserClass.newInstance();
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
        this.saveTimer = this.registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"repositories", repository.getName(), "saves"}));
        this.queryTimer = this.registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"repositories", repository.getName(), "queries"}));
        this.aclrUpdateTimer = this.registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"repositories", repository.getName(), "aclr-updates"}));
        this.computeRootNode();
    }

    public void checkLive() {
        if (!this.live) {
            throw new IllegalStateException("Session is not live");
        }
        this.checkThread();
    }

    @Override
    public Mapper getMapper() {
        return this.mapper;
    }

    public XAResource getXAResource() {
        return this;
    }

    protected int clearCaches() {
        if (this.inTransaction) {
            return 0;
        }
        this.checkThreadEnd();
        return this.context.clearCaches();
    }

    protected PersistenceContext getContext() {
        return this.context;
    }

    protected void rollback() {
        this.context.clearCaches();
    }

    protected void checkThread() {
        if (this.threadId == 0L) {
            return;
        }
        long currentThreadId = Thread.currentThread().getId();
        if (this.threadId == currentThreadId) {
            return;
        }
        String currentThreadName = Thread.currentThread().getName();
        String msg = String.format("Concurrency Error: Session was started in thread %s (%s) but is being used in thread %s (%s)", this.threadId, this.threadName, currentThreadId, currentThreadName);
        throw new IllegalStateException(msg, this.threadStack);
    }

    protected void checkThreadStart() {
        this.threadId = Thread.currentThread().getId();
        this.threadName = Thread.currentThread().getName();
        if (log.isDebugEnabled()) {
            this.threadStack = new Throwable("owner stack trace");
        }
    }

    protected void checkThreadEnd() {
        this.threadId = 0L;
        this.threadName = null;
        this.threadStack = null;
    }

    protected Serializable generateNewId(Serializable id) throws StorageException {
        return this.context.generateNewId(id);
    }

    protected boolean isIdNew(Serializable id) {
        return this.context.isIdNew(id);
    }

    public void close() throws ResourceException {
        try {
            this.checkLive();
            this.closeSession();
            this.repository.closeSession(this);
        }
        catch (Exception cause) {
            throw new ResourceException((Throwable)cause);
        }
    }

    protected void closeSession() throws StorageException {
        this.live = false;
        this.context.clearCaches();
        this.mapper.close();
    }

    public Interaction createInteraction() throws ResourceException {
        throw new UnsupportedOperationException();
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new UnsupportedOperationException();
    }

    public ConnectionMetaData getMetaData() throws ResourceException {
        throw new UnsupportedOperationException();
    }

    public ResultSetInfo getResultSetInfo() throws ResourceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLive() {
        return this.live;
    }

    @Override
    public boolean isStateSharedByAllThreadSessions() {
        return false;
    }

    @Override
    public String getRepositoryName() {
        return this.repository.getName();
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public Node getRootNode() {
        this.checkLive();
        return this.rootNode;
    }

    @Override
    public Binary getBinary(FileSource source) throws StorageException {
        BinaryManager mgr = this.repository.getBinaryManager();
        try {
            if (mgr instanceof BinaryManagerStreamSupport) {
                return ((BinaryManagerStreamSupport)mgr).getBinary(source);
            }
            return mgr.getBinary(source.getStream());
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public Binary getBinary(InputStream in) throws StorageException {
        BinaryManager mgr = this.repository.getBinaryManager();
        try {
            return mgr.getBinary(in);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void save() throws StorageException {
        Timer.Context timerContext = this.saveTimer.time();
        try {
            this.checkLive();
            this.flush();
            if (!this.inTransaction) {
                this.sendInvalidationsToOthers();
            }
            this.processReceivedInvalidations();
        }
        finally {
            timerContext.stop();
        }
    }

    protected void flush() throws StorageException {
        this.checkThread();
        List<Object> works = !this.repository.getRepositoryDescriptor().getFulltextDisabled() ? this.getFulltextWorks() : Collections.emptyList();
        this.doFlush();
        if (this.readAclsChanged) {
            this.updateReadAcls();
        }
        this.scheduleWork(works);
        this.checkInvalidationsConflict();
    }

    protected void scheduleWork(List<Work> works) {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
        if (repositoryManager != null && !works.isEmpty()) {
            WorkManager workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
            for (Work work : works) {
                workManager.schedule(work, WorkManager.Scheduling.IF_NOT_SCHEDULED, true);
            }
        }
    }

    protected void doFlush() throws StorageException {
        ArrayList<Fragment> fragmentsToClearDirty = new ArrayList<Fragment>(0);
        RowMapper.RowBatch batch = this.context.getSaveBatch(fragmentsToClearDirty);
        if (!batch.isEmpty()) {
            log.debug((Object)"Saving session");
            this.mapper.write(batch);
            log.debug((Object)"End of save");
            for (Fragment fragment : fragmentsToClearDirty) {
                fragment.clearDirty();
            }
        }
    }

    protected Serializable getContainingDocument(Serializable id) throws StorageException {
        return this.context.getContainingDocument(id);
    }

    protected List<Work> getFulltextWorks() throws StorageException {
        HashSet<Serializable> dirtyStrings = new HashSet<Serializable>();
        HashSet<Serializable> dirtyBinaries = new HashSet<Serializable>();
        this.context.findDirtyDocuments(dirtyStrings, dirtyBinaries);
        if (dirtyStrings.isEmpty() && dirtyBinaries.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<Work> works = new LinkedList<Work>();
        this.getFulltextSimpleWorks(works, dirtyStrings);
        this.getFulltextBinariesWorks(works, dirtyBinaries);
        return works;
    }

    protected void getFulltextSimpleWorks(List<Work> works, Set<Serializable> dirtyStrings) throws StorageException {
        for (Serializable docId : dirtyStrings) {
            if (docId == null) {
                log.error((Object)"Got null doc id in fulltext update, cannot happen");
                continue;
            }
            Node document = this.getNodeById(docId);
            if (document == null || document.isProxy()) continue;
            String documentType = document.getPrimaryType();
            String[] mixinTypes = document.getMixinTypes();
            if (!this.model.getFulltextConfiguration().isFulltextIndexable(documentType)) continue;
            document.getSimpleProperty("ecm:fulltextJobId").setValue((Serializable)((Object)this.model.idToString(document.getId())));
            FulltextFinder fulltextFinder = new FulltextFinder(this.fulltextParser, document, this);
            LinkedList<FulltextUpdaterWork.IndexAndText> indexesAndText = new LinkedList<FulltextUpdaterWork.IndexAndText>();
            for (String indexName : this.model.getFulltextConfiguration().indexNames) {
                Set paths = this.model.getFulltextConfiguration().indexesAllSimple.contains(indexName) ? this.model.getSimpleTextPropertyPaths(documentType, mixinTypes) : (Set)this.model.getFulltextConfiguration().propPathsByIndexSimple.get(indexName);
                String text = fulltextFinder.findFulltext(paths);
                indexesAndText.add(new FulltextUpdaterWork.IndexAndText(indexName, text));
            }
            if (indexesAndText.isEmpty()) continue;
            FulltextUpdaterWork work = new FulltextUpdaterWork(this.repository.getName(), this.model.idToString(docId), true, false, indexesAndText);
            works.add((Work)work);
        }
    }

    protected void getFulltextBinariesWorks(List<Work> works, Set<Serializable> dirtyBinaries) throws StorageException {
        if (dirtyBinaries.isEmpty()) {
            return;
        }
        for (Node node : this.getNodesByIds(new ArrayList<Serializable>(dirtyBinaries))) {
            if (!this.model.getFulltextConfiguration().isFulltextIndexable(node.getPrimaryType())) continue;
            node.getSimpleProperty("ecm:fulltextJobId").setValue((Serializable)((Object)this.model.idToString(node.getId())));
        }
        for (Serializable id : dirtyBinaries) {
            String docId = this.model.idToString(id);
            SQLFulltextExtractorWork work = new SQLFulltextExtractorWork(this.repository.getName(), docId);
            works.add((Work)work);
        }
    }

    protected void sendInvalidationsToOthers() throws StorageException {
        this.context.sendInvalidationsToOthers();
    }

    protected void processReceivedInvalidations() throws StorageException {
        this.context.processReceivedInvalidations();
    }

    protected void checkInvalidationsConflict() throws StorageException {
        this.context.checkInvalidationsConflict();
    }

    protected void collectModified(Invalidations invalidations, Set<String> docs, Set<String> parents) {
        if (invalidations == null || invalidations.modified == null) {
            return;
        }
        for (RowId rowId : invalidations.modified) {
            Serializable docId;
            Serializable id = rowId.id;
            try {
                docId = this.getContainingDocument(id);
            }
            catch (StorageException e) {
                log.error((Object)("Cannot get containing document for: " + id), (Throwable)((Object)e));
                docId = null;
            }
            if (docId == null) continue;
            if ("__PARENT__".equals(rowId.tableName)) {
                if (docId.equals(id)) {
                    parents.add(this.model.idToString(docId));
                    continue;
                }
                docs.add(this.model.idToString(docId));
                continue;
            }
            docs.add(this.model.idToString(docId));
        }
    }

    protected void sendInvalidationEvent(Invalidations invalidations, boolean local) {
        this.sendInvalidationEvent(new Invalidations.InvalidationsPair(invalidations, null));
    }

    protected void sendInvalidationEvent(Invalidations.InvalidationsPair pair) {
        if (!this.repository.repositoryDescriptor.sendInvalidationEvents) {
            return;
        }
        HashSet<String> modifiedDocIds = new HashSet<String>();
        HashSet<String> modifiedParentIds = new HashSet<String>();
        this.collectModified(pair.cacheInvalidations, modifiedDocIds, modifiedParentIds);
        this.collectModified(pair.eventInvalidations, modifiedDocIds, modifiedParentIds);
        if (modifiedDocIds.isEmpty() && modifiedParentIds.isEmpty()) {
            return;
        }
        EventContextImpl ctx = new EventContextImpl(null, null);
        ctx.setRepositoryName(this.repository.getName());
        ctx.setProperty("modifiedDocIds", modifiedDocIds);
        ctx.setProperty("modifiedParentIds", modifiedParentIds);
        EventImpl event = new EventImpl("vcsInvalidations", (EventContext)ctx);
        try {
            this.repository.eventService.fireEvent((Event)event);
        }
        catch (ClientException e) {
            log.error((Object)("Failed to send invalidation event: " + (Object)((Object)e)), (Throwable)e);
        }
    }

    protected Node getNodeById(Serializable id, boolean prefetch) throws StorageException {
        List<Node> nodes = this.getNodesByIds(Collections.singletonList(id), prefetch);
        Node node = nodes.get(0);
        return node;
    }

    @Override
    public Node getNodeById(Serializable id) throws StorageException {
        this.checkLive();
        if (id == null) {
            throw new IllegalArgumentException("Illegal null id");
        }
        return this.getNodeById(id, true);
    }

    public List<Node> getNodesByIds(List<Serializable> ids, boolean prefetch) throws StorageException {
        Serializable id;
        ArrayList<RowId> hierRowIds = new ArrayList<RowId>(ids.size());
        for (Serializable id2 : ids) {
            hierRowIds.add(new RowId("hierarchy", id2));
        }
        List<Fragment> hierFragments = this.context.getMulti(hierRowIds, false);
        HashMap<Serializable, String> paths = new HashMap<Serializable, String>();
        HashSet<Serializable> parentIds = new HashSet<Serializable>();
        for (Fragment fragment : hierFragments) {
            id = fragment.getId();
            PersistenceContext.PathAndId pathAndId = this.context.getPathOrMissingParentId((SimpleFragment)fragment, false);
            if (pathAndId.path != null) {
                paths.put(id, pathAndId.path);
                continue;
            }
            parentIds.add(pathAndId.id);
        }
        if (!parentIds.isEmpty()) {
            this.getHierarchyAndAncestors(parentIds);
            for (Fragment fragment : hierFragments) {
                id = fragment.getId();
                if (paths.containsKey(id)) continue;
                String string = this.context.getPath((SimpleFragment)fragment);
                paths.put(id, string);
            }
        }
        HashMap<Serializable, FragmentGroup> fragmentGroups = new HashMap<Serializable, FragmentGroup>(ids.size());
        for (Fragment fragment : hierFragments) {
            Serializable serializable = fragment.row.id;
            fragmentGroups.put(serializable, new FragmentGroup((SimpleFragment)fragment, new FragmentsMap()));
        }
        if (prefetch) {
            ArrayList<RowId> arrayList = new ArrayList<RowId>();
            HashSet<Serializable> proxyIds = new HashSet<Serializable>();
            for (Fragment fragment : hierFragments) {
                this.findPrefetchedFragments((SimpleFragment)fragment, arrayList, proxyIds);
            }
            ArrayList<RowId> arrayList2 = new ArrayList<RowId>(proxyIds.size());
            for (Serializable id4 : proxyIds) {
                arrayList2.add(new RowId("proxies", id4));
            }
            List<Fragment> list = this.context.getMulti(arrayList2, true);
            HashSet<Serializable> targetIds = new HashSet<Serializable>();
            for (Fragment fragment : list) {
                Serializable targetId = ((SimpleFragment)fragment).get("targetid");
                targetIds.add(targetId);
            }
            targetIds.removeAll(ids);
            hierRowIds = new ArrayList(targetIds.size());
            for (Serializable id5 : targetIds) {
                hierRowIds.add(new RowId("hierarchy", id5));
            }
            hierFragments = this.context.getMulti(hierRowIds, true);
            for (Fragment fragment : hierFragments) {
                this.findPrefetchedFragments((SimpleFragment)fragment, arrayList, null);
            }
            List<Fragment> fragments = this.context.getMulti(arrayList, true);
            for (Fragment fragment : fragments) {
                FragmentGroup fragmentGroup = (FragmentGroup)fragmentGroups.get(fragment.row.id);
                if (fragmentGroup == null) continue;
                fragmentGroup.fragments.put(fragment.row.tableName, fragment);
            }
        }
        ArrayList<Node> arrayList = new ArrayList<Node>(ids.size());
        for (Serializable serializable : ids) {
            FragmentGroup fragmentGroup = (FragmentGroup)fragmentGroups.get(serializable);
            Node node = fragmentGroup == null ? null : new Node(this.context, fragmentGroup, (String)paths.get(serializable));
            arrayList.add(node);
        }
        return arrayList;
    }

    protected void findPrefetchedFragments(SimpleFragment hierFragment, List<RowId> bulkRowIds, Set<Serializable> proxyIds) throws StorageException {
        Serializable id = hierFragment.row.id;
        String typeName = (String)((Object)hierFragment.get("primarytype"));
        if ("ecm:proxy".equals(typeName)) {
            if (proxyIds != null) {
                proxyIds.add(id);
            }
            return;
        }
        Set<String> tableNames = this.model.getTypePrefetchedFragments(typeName);
        if (tableNames == null) {
            return;
        }
        Serializable parentId = hierFragment.get("parentid");
        for (String tableName : tableNames) {
            if ("hierarchy".equals(tableName) || parentId != null && "versions".equals(tableName)) continue;
            bulkRowIds.add(new RowId(tableName, id));
        }
    }

    @Override
    public List<Node> getNodesByIds(List<Serializable> ids) throws StorageException {
        this.checkLive();
        return this.getNodesByIds(ids, true);
    }

    @Override
    public Node getParentNode(Node node) throws StorageException {
        this.checkLive();
        if (node == null) {
            throw new IllegalArgumentException("Illegal null node");
        }
        Serializable id = node.getHierFragment().get("parentid");
        return id == null ? null : this.getNodeById(id);
    }

    @Override
    public String getPath(Node node) throws StorageException {
        this.checkLive();
        String path = node.getPath();
        if (path == null) {
            path = this.context.getPath(node.getHierFragment());
        }
        return path;
    }

    protected String normalize(String path) {
        return Normalizer.normalize(path, Normalizer.Form.NFC);
    }

    @Override
    public Node getNodeByPath(String path, Node node) throws StorageException {
        int i;
        this.checkLive();
        if (path == null) {
            throw new IllegalArgumentException("Illegal null path");
        }
        if ((path = this.normalize(path)).startsWith("/")) {
            node = this.getRootNode();
            if (path.equals("/")) {
                return node;
            }
            i = 1;
        } else {
            if (node == null) {
                throw new IllegalArgumentException("Illegal relative path with null node: " + path);
            }
            i = 0;
        }
        String[] names = path.split("/", -1);
        while (i < names.length) {
            String name = names[i];
            if (name.length() == 0) {
                throw new IllegalArgumentException("Illegal path with empty component: " + path);
            }
            if ((node = this.getChildNode(node, name, false)) == null) {
                return null;
            }
            ++i;
        }
        return node;
    }

    @Override
    public boolean addMixinType(Node node, String mixin) throws StorageException {
        if (this.model.getMixinPropertyInfos(mixin) == null) {
            throw new IllegalArgumentException("No such mixin: " + mixin);
        }
        if (this.model.getDocumentTypeFacets(node.getPrimaryType()).contains(mixin)) {
            return false;
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(node.getMixinTypes()));
        if (list.contains(mixin)) {
            return false;
        }
        Set<String> otherChildrenNames = this.getChildrenNames(node.getPrimaryType(), list);
        list.add(mixin);
        String[] mixins = list.toArray(new String[list.size()]);
        node.hierFragment.put("mixintypes", (Serializable)mixins);
        Map<String, String> childrenTypes = this.model.getMixinComplexChildren(mixin);
        for (Map.Entry<String, String> es : childrenTypes.entrySet()) {
            String childName = es.getKey();
            String childType = es.getValue();
            if (otherChildrenNames.contains(childName)) continue;
            this.addChildNode(node, childName, null, childType, true);
        }
        return true;
    }

    @Override
    public boolean removeMixinType(Node node, String mixin) throws StorageException {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(node.getMixinTypes()));
        if (!list.remove(mixin)) {
            return false;
        }
        String[] mixins = list.toArray(new String[list.size()]);
        if (mixins.length == 0) {
            mixins = null;
        }
        node.hierFragment.put("mixintypes", (Serializable)mixins);
        Set<String> otherChildrenNames = this.getChildrenNames(node.getPrimaryType(), list);
        Map<String, String> childrenTypes = this.model.getMixinComplexChildren(mixin);
        for (String childName : childrenTypes.keySet()) {
            if (otherChildrenNames.contains(childName)) continue;
            Node child = this.getChildNode(node, childName, true);
            this.removePropertyNode(child);
        }
        node.clearCache();
        return true;
    }

    protected Set<String> getChildrenNames(String primaryType, List<String> mixins) {
        Map<String, String> cc = this.model.getTypeComplexChildren(primaryType);
        if (cc == null) {
            cc = Collections.emptyMap();
        }
        HashSet<String> childrenNames = new HashSet<String>(cc.keySet());
        for (String mixin : mixins) {
            cc = this.model.getMixinComplexChildren(mixin);
            if (cc == null) continue;
            childrenNames.addAll(cc.keySet());
        }
        return childrenNames;
    }

    @Override
    public Node addChildNode(Node parent, String name, Long pos, String typeName, boolean complexProp) throws StorageException {
        if (pos == null && !complexProp && parent != null) {
            pos = this.context.getNextPos(parent.getId(), complexProp);
        }
        return this.addChildNode(null, parent, name, pos, typeName, complexProp);
    }

    @Override
    public Node addChildNode(Serializable id, Node parent, String name, Long pos, String typeName, boolean complexProp) throws StorageException {
        this.checkLive();
        if (name == null) {
            throw new IllegalArgumentException("Illegal null name");
        }
        if ((name = this.normalize(name)).contains("/") || name.equals(".") || name.equals("..")) {
            throw new IllegalArgumentException("Illegal name: " + name);
        }
        if (!this.model.isType(typeName)) {
            throw new IllegalArgumentException("Unknown type: " + typeName);
        }
        id = this.generateNewId(id);
        Serializable parentId = parent == null ? null : parent.hierFragment.getId();
        Node node = this.addNode(id, parentId, name, pos, typeName, complexProp);
        Map<String, String> childrenTypes = this.model.getTypeComplexChildren(typeName);
        for (Map.Entry<String, String> es : childrenTypes.entrySet()) {
            String childName = es.getKey();
            String childType = es.getValue();
            this.addChildNode(node, childName, null, childType, true);
        }
        return node;
    }

    protected Node addNode(Serializable id, Serializable parentId, String name, Long pos, String typeName, boolean complexProp) throws StorageException {
        this.requireReadAclsUpdate();
        Row hierRow = new Row("hierarchy", id);
        hierRow.putNew("parentid", parentId);
        hierRow.putNew("name", (Serializable)((Object)name));
        hierRow.putNew("pos", pos);
        hierRow.putNew("primarytype", (Serializable)((Object)typeName));
        hierRow.putNew("isproperty", Boolean.valueOf(complexProp));
        SimpleFragment hierFragment = this.context.createHierarchyFragment(hierRow);
        FragmentGroup fragmentGroup = new FragmentGroup(hierFragment, new FragmentsMap());
        return new Node(this.context, fragmentGroup, this.context.getPath(hierFragment));
    }

    @Override
    public Node addProxy(Serializable targetId, Serializable versionableId, Node parent, String name, Long pos) throws StorageException {
        if (!this.repository.getRepositoryDescriptor().getProxiesEnabled()) {
            throw new StorageException("Proxies are disabled by configuration");
        }
        Node proxy = this.addChildNode(parent, name, pos, "ecm:proxy", false);
        proxy.setSimpleProperty("ecm:proxyTargetId", targetId);
        proxy.setSimpleProperty("ecm:proxyVersionableId", versionableId);
        SimpleFragment proxyFragment = (SimpleFragment)proxy.fragments.get("proxies");
        this.context.createdProxyFragment(proxyFragment);
        return proxy;
    }

    @Override
    public void setProxyTarget(Node proxy, Serializable targetId) throws StorageException {
        if (!this.repository.getRepositoryDescriptor().getProxiesEnabled()) {
            throw new StorageException("Proxies are disabled by configuration");
        }
        SimpleProperty prop = proxy.getSimpleProperty("ecm:proxyTargetId");
        Serializable oldTargetId = prop.getValue();
        if (!oldTargetId.equals(targetId)) {
            SimpleFragment proxyFragment = (SimpleFragment)proxy.fragments.get("proxies");
            this.context.removedProxyTarget(proxyFragment);
            proxy.setSimpleProperty("ecm:proxyTargetId", targetId);
            this.context.addedProxyTarget(proxyFragment);
        }
    }

    @Override
    public boolean hasChildNode(Node parent, String name, boolean complexProp) throws StorageException {
        this.checkLive();
        SimpleFragment fragment = this.context.getChildHierByName(parent.getId(), this.normalize(name), complexProp);
        return fragment != null;
    }

    @Override
    public Node getChildNode(Node parent, String name, boolean complexProp) throws StorageException {
        this.checkLive();
        if (name == null || name.contains("/") || name.equals(".") || name.equals("..")) {
            throw new IllegalArgumentException("Illegal name: " + name);
        }
        SimpleFragment fragment = this.context.getChildHierByName(parent.getId(), name, complexProp);
        return fragment == null ? null : this.getNodeById(fragment.getId());
    }

    @Override
    public boolean hasChildren(Node parent, boolean complexProp) throws StorageException {
        this.checkLive();
        List<SimpleFragment> children = this.context.getChildren(parent.getId(), null, complexProp);
        if (complexProp) {
            return !children.isEmpty();
        }
        if (children.isEmpty()) {
            return false;
        }
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        for (SimpleFragment simpleFragment : children) {
            DocumentType type;
            String primaryType = simpleFragment.getString("primarytype");
            if (primaryType.equals("ecm:proxy")) {
                Node target;
                Node node = this.getNodeById(simpleFragment.getId(), false);
                Serializable targetId = node.getSimpleProperty("ecm:proxyTargetId").getValue();
                if (targetId == null || (target = this.getNodeById(targetId, false)) == null) continue;
                primaryType = target.getPrimaryType();
            }
            if ((type = schemaManager.getDocumentType(primaryType)) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Node> getChildren(Node parent, String name, boolean complexProp) throws StorageException {
        this.checkLive();
        List<SimpleFragment> fragments = this.context.getChildren(parent.getId(), name, complexProp);
        ArrayList<Node> nodes = new ArrayList<Node>(fragments.size());
        for (SimpleFragment fragment : fragments) {
            Node node = this.getNodeById(fragment.getId());
            if (node == null) {
                log.error((Object)("Child node cannot be created: " + fragment.getId()));
                continue;
            }
            nodes.add(node);
        }
        return nodes;
    }

    @Override
    public void orderBefore(Node parent, Node source, Node dest) throws StorageException {
        this.checkLive();
        this.context.orderBefore(parent.getId(), source.getId(), dest == null ? null : dest.getId());
    }

    @Override
    public Node move(Node source, Node parent, String name) throws StorageException {
        this.checkLive();
        if (!parent.getId().equals(source.getParentId())) {
            this.flush();
        }
        this.context.move(source, parent.getId(), name);
        this.requireReadAclsUpdate();
        return source;
    }

    @Override
    public Node copy(Node source, Node parent, String name) throws StorageException {
        this.checkLive();
        this.flush();
        Serializable id = this.context.copy(source, parent.getId(), name);
        this.requireReadAclsUpdate();
        return this.getNodeById(id);
    }

    @Override
    public void removeNode(Node node) throws StorageException {
        this.checkLive();
        this.flush();
        this.context.removeNode(node.getHierFragment());
    }

    @Override
    public void removePropertyNode(Node node) throws StorageException {
        this.checkLive();
        this.context.removePropertyNode(node.getHierFragment());
    }

    @Override
    public Node checkIn(Node node, String label, String checkinComment) throws StorageException {
        this.checkLive();
        this.flush();
        Serializable id = this.context.checkIn(node, label, checkinComment);
        this.requireReadAclsUpdate();
        this.flush();
        return this.getNodeById(id);
    }

    @Override
    public void checkOut(Node node) throws StorageException {
        this.checkLive();
        this.context.checkOut(node);
        this.requireReadAclsUpdate();
    }

    @Override
    public void restore(Node node, Node version) throws StorageException {
        this.checkLive();
        this.context.restoreVersion(node, version);
        this.requireReadAclsUpdate();
    }

    @Override
    public Node getVersionByLabel(Serializable versionSeriesId, String label) throws StorageException {
        if (label == null) {
            return null;
        }
        List<Node> versions = this.getVersions(versionSeriesId);
        for (Node node : versions) {
            String l = (String)((Object)node.getSimpleProperty("ecm:versionLabel").getValue());
            if (!label.equals(l)) continue;
            return node;
        }
        return null;
    }

    @Override
    public Node getLastVersion(Serializable versionSeriesId) throws StorageException {
        this.checkLive();
        List<Serializable> ids = this.context.getVersionIds(versionSeriesId);
        return ids.isEmpty() ? null : this.getNodeById(ids.get(ids.size() - 1));
    }

    @Override
    public List<Node> getVersions(Serializable versionSeriesId) throws StorageException {
        this.checkLive();
        List<Serializable> ids = this.context.getVersionIds(versionSeriesId);
        ArrayList<Node> nodes = new ArrayList<Node>(ids.size());
        for (Serializable id : ids) {
            nodes.add(this.getNodeById(id));
        }
        return nodes;
    }

    @Override
    public List<Node> getProxies(Node document, Node parent) throws StorageException {
        Node node;
        List<Serializable> ids;
        this.checkLive();
        if (!this.repository.getRepositoryDescriptor().getProxiesEnabled()) {
            return Collections.emptyList();
        }
        if (document.isVersion()) {
            ids = this.context.getTargetProxyIds(document.getId());
        } else {
            Serializable versionSeriesId = document.isProxy() ? document.getSimpleProperty("ecm:proxyVersionableId").getValue() : document.getId();
            ids = this.context.getSeriesProxyIds(versionSeriesId);
        }
        LinkedList<Node> nodes = new LinkedList<Node>();
        for (Serializable id : ids) {
            node = this.getNodeById(id);
            if (node == null && !Boolean.TRUE.booleanValue()) continue;
            nodes.add(node);
        }
        if (parent != null) {
            Serializable parentId = parent.getId();
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                node = (Node)it.next();
                if (parentId.equals(node.getParentId())) continue;
                it.remove();
            }
        }
        return nodes;
    }

    protected List<Fragment> getHierarchyAndAncestors(Collection<Serializable> ids) throws StorageException {
        Set<Serializable> allIds = this.mapper.getAncestorsIds(ids);
        allIds.addAll(ids);
        ArrayList<RowId> rowIds = new ArrayList<RowId>(allIds.size());
        for (Serializable id : allIds) {
            rowIds.add(new RowId("hierarchy", id));
        }
        return this.context.getMulti(rowIds, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartialList<Serializable> query(String query, QueryFilter queryFilter, boolean countTotal) throws StorageException {
        Timer.Context timerContext = this.queryTimer.time();
        try {
            PartialList<Serializable> partialList = this.mapper.query(query, "NXQL", queryFilter, countTotal);
            return partialList;
        }
        finally {
            timerContext.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartialList<Serializable> query(String query, String queryType, QueryFilter queryFilter, long countUpTo) throws StorageException {
        PartialList<Serializable> partialList;
        Timer.Context timerContext = this.queryTimer.time();
        try {
            partialList = this.mapper.query(query, queryType, queryFilter, countUpTo);
        }
        catch (Throwable throwable) {
            long duration = timerContext.stop();
            if (LOG_MIN_DURATION_NS >= 0L && duration > LOG_MIN_DURATION_NS) {
                String msg = String.format("duration_ms:\t%.2f\t%s %s\tquery\t%s", (double)duration / 1000000.0, queryFilter, this.countUpToAsString(countUpTo), query);
                if (log.isTraceEnabled()) {
                    log.info((Object)msg, new Throwable("Slow query stack trace"));
                } else {
                    log.info((Object)msg);
                }
            }
            throw throwable;
        }
        long duration = timerContext.stop();
        if (LOG_MIN_DURATION_NS >= 0L && duration > LOG_MIN_DURATION_NS) {
            String msg = String.format("duration_ms:\t%.2f\t%s %s\tquery\t%s", (double)duration / 1000000.0, queryFilter, this.countUpToAsString(countUpTo), query);
            if (log.isTraceEnabled()) {
                log.info((Object)msg, new Throwable("Slow query stack trace"));
            } else {
                log.info((Object)msg);
            }
        }
        return partialList;
    }

    private String countUpToAsString(long countUpTo) {
        if (countUpTo > 0L) {
            return String.format("count total results up to %d", countUpTo);
        }
        return countUpTo == -1L ? "count total results UNLIMITED" : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IterableQueryResult queryAndFetch(String query, String queryType, QueryFilter queryFilter, Object ... params) throws StorageException {
        IterableQueryResult iterableQueryResult;
        Timer.Context timerContext = this.queryTimer.time();
        try {
            iterableQueryResult = this.mapper.queryAndFetch(query, queryType, queryFilter, params);
        }
        catch (Throwable throwable) {
            long duration = timerContext.stop();
            if (LOG_MIN_DURATION_NS >= 0L && duration > LOG_MIN_DURATION_NS) {
                String msg = String.format("duration_ms:\t%.2f\t%s\tqueryAndFetch\t%s", (double)duration / 1000000.0, queryFilter, query);
                if (log.isTraceEnabled()) {
                    log.info((Object)msg, new Throwable("Slow query stack trace"));
                } else {
                    log.info((Object)msg);
                }
            }
            throw throwable;
        }
        long duration = timerContext.stop();
        if (LOG_MIN_DURATION_NS >= 0L && duration > LOG_MIN_DURATION_NS) {
            String msg = String.format("duration_ms:\t%.2f\t%s\tqueryAndFetch\t%s", (double)duration / 1000000.0, queryFilter, query);
            if (log.isTraceEnabled()) {
                log.info((Object)msg, new Throwable("Slow query stack trace"));
            } else {
                log.info((Object)msg);
            }
        }
        return iterableQueryResult;
    }

    @Override
    public Lock getLock(Serializable id) {
        return this.repository.getLockManager().getLock(this.model.idToString(id));
    }

    @Override
    public Lock setLock(Serializable id, Lock lock) {
        if (lock == null) {
            throw new NullPointerException("Attempt to use null lock on: " + id);
        }
        return this.repository.getLockManager().setLock(this.model.idToString(id), lock);
    }

    @Override
    public Lock removeLock(Serializable id, String owner, boolean force) {
        return this.repository.getLockManager().removeLock(this.model.idToString(id), owner);
    }

    @Override
    public void requireReadAclsUpdate() {
        this.readAclsChanged = true;
    }

    @Override
    public void updateReadAcls() throws StorageException {
        Timer.Context timerContext = this.aclrUpdateTimer.time();
        try {
            this.mapper.updateReadAcls();
            this.readAclsChanged = false;
        }
        finally {
            timerContext.stop();
        }
    }

    @Override
    public void rebuildReadAcls() throws StorageException {
        this.mapper.rebuildReadAcls();
        this.readAclsChanged = false;
    }

    private void computeRootNode() throws StorageException {
        String repositoryId = this.repository.getName();
        Serializable rootId = this.mapper.getRootId(repositoryId);
        if (rootId == null && COMPAT_REPOSITORY_NAME) {
            rootId = this.mapper.getRootId("default");
        }
        if (rootId == null) {
            log.debug((Object)"Creating root");
            this.rootNode = this.addRootNode();
            this.addRootACP();
            this.save();
            this.mapper.setRootId((Serializable)((Object)repositoryId), this.rootNode.getId());
        } else {
            this.rootNode = this.getNodeById(rootId, false);
        }
    }

    private Node addRootNode() throws StorageException {
        Serializable id = this.generateNewId(null);
        return this.addNode(id, null, "", null, "Root", false);
    }

    private void addRootACP() throws StorageException {
        Serializable[] aclrows = new ACLRow[]{new ACLRow(0, "local", true, "Everything", "administrators", null), new ACLRow(1, "local", true, "Everything", "Administrator", null), new ACLRow(2, "local", true, "Read", "members", null)};
        this.rootNode.setCollectionProperty("ecm:acl", aclrows);
        this.requireReadAclsUpdate();
    }

    public void checkPermission(String absPath, String actions) throws StorageException {
        this.checkLive();
        throw new RuntimeException("Not implemented");
    }

    public boolean hasPendingChanges() throws StorageException {
        this.checkLive();
        throw new RuntimeException("Not implemented");
    }

    public void markReferencedBinaries(BinaryGarbageCollector gc) {
        this.checkLive();
        try {
            this.mapper.markReferencedBinaries(gc);
        }
        catch (StorageException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public int cleanupDeletedDocuments(int max, Calendar beforeTime) {
        this.checkLive();
        if (!this.repository.getRepositoryDescriptor().getSoftDeleteEnabled()) {
            return 0;
        }
        try {
            return this.mapper.cleanupDeletedRows(max, beforeTime);
        }
        catch (StorageException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    @Override
    public boolean isSameRM(XAResource xaresource) {
        return xaresource == this;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (flags == 0) {
            try {
                this.processReceivedInvalidations();
            }
            catch (Exception e) {
                log.error((Object)"Could not start transaction", (Throwable)e);
                throw (XAException)new XAException(-3).initCause(e);
            }
        }
        this.mapper.start(xid, flags);
        this.inTransaction = true;
        this.checkThreadStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Xid xid, int flags) throws XAException {
        block10: {
            boolean failed = true;
            if (flags != 0x20000000) {
                try {
                    this.flush();
                }
                catch (Exception e) {
                    String msg = "Exception during transaction commit";
                    if (e instanceof ConcurrentUpdateStorageException) {
                        TransactionHelper.noteSuppressedException((Exception)e);
                        log.debug((Object)msg, (Throwable)e);
                        TransactionHelper.setTransactionRollbackOnly();
                        if (failed) {
                            this.mapper.end(xid, 0x20000000);
                        }
                        return;
                    }
                    log.error((Object)msg, (Throwable)e);
                    throw (XAException)new XAException(-3).initCause(e);
                }
            }
            failed = false;
            break block10;
            finally {
                if (failed) {
                    this.mapper.end(xid, 0x20000000);
                }
            }
        }
        this.mapper.end(xid, flags);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        int res = this.mapper.prepare(xid);
        if (res == 3) {
            this.commitDone();
        }
        return res;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            this.mapper.commit(xid, onePhase);
        }
        finally {
            this.commitDone();
        }
    }

    protected void commitDone() throws XAException {
        this.inTransaction = false;
        try {
            try {
                this.sendInvalidationsToOthers();
            }
            finally {
                this.checkThreadEnd();
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not send invalidations", (Throwable)e);
            throw (XAException)new XAException(-3).initCause(e);
        }
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        try {
            try {
                this.mapper.rollback(xid);
            }
            finally {
                this.rollback();
            }
        }
        finally {
            this.inTransaction = false;
            this.checkThreadEnd();
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.mapper.forget(xid);
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        return this.mapper.recover(flag);
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.mapper.setTransactionTimeout(seconds);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.mapper.getTransactionTimeout();
    }

    public long getCacheSize() {
        return this.context.getCacheSize();
    }

    public long getCacheMapperSize() {
        return this.context.getCacheMapperSize();
    }

    public long getCachePristineSize() {
        return this.context.getCachePristineSize();
    }

    public long getCacheSelectionSize() {
        return this.context.getCacheSelectionSize();
    }

    @Override
    public Map<String, String> getBinaryFulltext(Serializable id) throws StorageException {
        if (this.repository.getRepositoryDescriptor().getFulltextDisabled()) {
            return null;
        }
        RowId rowId = new RowId("fulltext", id);
        return this.mapper.getBinaryFulltext(rowId);
    }

    protected static class FulltextFinder {
        protected final FulltextParser fulltextParser;
        protected final Node document;
        protected final SessionImpl session;
        protected final String documentType;
        protected final String[] mixinTypes;

        public FulltextFinder(FulltextParser fulltextParser, Node document, SessionImpl session) {
            this.fulltextParser = fulltextParser;
            this.document = document;
            this.session = session;
            if (document == null) {
                this.documentType = null;
                this.mixinTypes = null;
            } else {
                this.documentType = document.getPrimaryType();
                this.mixinTypes = document.getMixinTypes();
            }
        }

        protected String findFulltext(Set<String> paths) throws StorageException {
            if (paths == null) {
                return "";
            }
            ArrayList strings = new ArrayList();
            for (String path : paths) {
                ModelProperty pi = this.session.getModel().getPathPropertyInfo(this.documentType, this.mixinTypes, path);
                if (pi == null || pi.propertyType != PropertyType.STRING && pi.propertyType != PropertyType.ARRAY_STRING) continue;
                ArrayList<Node> nodes = new ArrayList<Node>(Collections.singleton(this.document));
                String[] names = path.split("/");
                for (int i = 0; i < names.length; ++i) {
                    String name = names[i];
                    if (i < names.length - 1) {
                        ArrayList<Node> newNodes;
                        if ("*".equals(names[i + 1])) {
                            ++i;
                            newNodes = new ArrayList<Node>();
                            for (Node node : nodes) {
                                newNodes.addAll(this.session.getChildren(node, name, true));
                            }
                        } else {
                            newNodes = new ArrayList(nodes.size());
                            for (Node node : nodes) {
                                if ((node = this.session.getChildNode(node, name, true)) == null) continue;
                                newNodes.add(node);
                            }
                        }
                        nodes = newNodes;
                        continue;
                    }
                    for (Node node : nodes) {
                        if (pi.propertyType == PropertyType.STRING) {
                            String v = node.getSimpleProperty(name).getString();
                            if (v == null) continue;
                            this.fulltextParser.parse(v, path, strings);
                            continue;
                        }
                        for (Serializable v : node.getCollectionProperty(name).getValue()) {
                            if (v == null) continue;
                            this.fulltextParser.parse((String)((Object)v), path, strings);
                        }
                    }
                }
            }
            return StringUtils.join(strings, (char)' ');
        }
    }
}

