/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem;

import org.wikimodel.wem.IWikiPrinter;
import org.wikimodel.wem.PrintTextListener;
import org.wikimodel.wem.ReferenceHandler;
import org.wikimodel.wem.WikiFormat;
import org.wikimodel.wem.WikiPageUtil;
import org.wikimodel.wem.WikiParameters;
import org.wikimodel.wem.util.WikiEntityUtil;

public class PrintInlineListener
extends PrintTextListener {
    public PrintInlineListener(IWikiPrinter printer) {
        super(printer);
    }

    public void beginFormat(WikiFormat format) {
        this.print(format.getTags(true));
    }

    public void beginPropertyInline(String str) {
        this.print("<span class='property' url='" + WikiPageUtil.escapeXmlAttribute(str) + "'>");
    }

    public void endFormat(WikiFormat format) {
        this.print(format.getTags(false));
    }

    public void endPropertyInline(String inlineProperty) {
        this.print("</span>");
    }

    protected ReferenceHandler newReferenceHandler() {
        return new ReferenceHandler(){

            protected void handleImage(String ref, String label) {
                PrintInlineListener.this.print("<img src='" + WikiPageUtil.escapeXmlAttribute(ref) + "' title='" + WikiPageUtil.escapeXmlAttribute(label) + "'/>");
            }

            protected void handleReference(String ref, String label) {
                PrintInlineListener.this.print("<a href='" + WikiPageUtil.escapeXmlAttribute(ref) + "'>" + WikiPageUtil.escapeXmlString(label) + "</a>");
            }
        };
    }

    public void onEscape(String str) {
        this.print("<span class='escaped'>" + WikiPageUtil.escapeXmlString(str) + "</span>");
    }

    public void onExtensionInline(String extensionName, WikiParameters params) {
        this.print("<span class='extension' extension='" + extensionName + "'" + params + "/>");
    }

    public void onLineBreak() {
        this.print("<br />");
    }

    public void onSpecialSymbol(String str) {
        String entity = WikiEntityUtil.getHtmlSymbol(str);
        if (entity != null) {
            entity = "&" + entity + ";";
            if (str.startsWith(" --")) {
                entity = "&nbsp;" + entity + " ";
            }
        } else {
            entity = WikiPageUtil.escapeXmlString(str);
        }
        this.print(entity);
    }

    public void onVerbatimInline(String str) {
        this.print("<code>" + WikiPageUtil.escapeXmlString(str) + "</code>");
    }
}

