/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wikimodel.wem.WikiParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiParameters {
    public static final WikiParameters EMPTY = new WikiParameters();
    private static final long serialVersionUID = 1253393289284318413L;
    private List<WikiParameter> fList = new ArrayList<WikiParameter>();
    private Map<String, WikiParameter[]> fMap;
    private String fStr;

    protected static int getNextToken(char[] array, int pos, StringBuffer buf) {
        buf.delete(0, buf.length());
        boolean escaped = false;
        if (pos < array.length && (array[pos] == '\'' || array[pos] == '\"')) {
            char endChar = array[pos];
            ++pos;
            while (pos < array.length && (escaped || array[pos] != endChar)) {
                boolean bl = escaped = array[pos] == '\\';
                if (!escaped) {
                    buf.append(array[pos]);
                }
                ++pos;
            }
            if (pos < array.length) {
                ++pos;
            }
        } else {
            while (pos < array.length && array[pos] != '=' && !Character.isSpaceChar(array[pos]) && (escaped || array[pos] != '\'' && array[pos] != '\"')) {
                boolean bl = escaped = array[pos] == '\\';
                if (!escaped) {
                    buf.append(array[pos]);
                }
                ++pos;
            }
        }
        return pos;
    }

    protected static int removeSpaces(char[] array, int pos, StringBuffer buf) {
        buf.delete(0, buf.length());
        while (pos < array.length && (array[pos] == '=' || Character.isSpaceChar(array[pos]))) {
            if (array[pos] == '=') {
                buf.append(array[pos]);
            }
            ++pos;
        }
        return pos;
    }

    protected static void splitToPairs(String str, List<WikiParameter> list) {
        if (str == null) {
            return;
        }
        char[] array = str.toCharArray();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            String key = null;
            String value = null;
            if ((i = WikiParameters.removeSpaces(array, i, buf)) >= array.length) break;
            i = WikiParameters.getNextToken(array, i, buf);
            key = buf.toString();
            i = WikiParameters.removeSpaces(array, i, buf);
            if (buf.indexOf("=") >= 0) {
                i = WikiParameters.getNextToken(array, i, buf);
                value = buf.toString();
            }
            WikiParameter entry = new WikiParameter(key, value);
            list.add(entry);
        }
    }

    WikiParameters() {
        this((String)null);
    }

    public WikiParameters(List<WikiParameter> list) {
        this.fList.addAll(list);
    }

    public WikiParameters(String str) {
        WikiParameters.splitToPairs(str, this.fList);
    }

    public WikiParameters addParameter(String key, String value) {
        WikiParameters result = new WikiParameters();
        result.fList.addAll(this.fList);
        result.fList.add(new WikiParameter(key, value));
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WikiParameters)) {
            return false;
        }
        WikiParameters params = (WikiParameters)obj;
        return ((Object)this.fList).equals(params.fList);
    }

    public WikiParameter getParameter(int pos) {
        return pos < 0 || pos >= this.fList.size() ? null : this.fList.get(pos);
    }

    public WikiParameter getParameter(String key) {
        WikiParameter[] list = this.getParameters(key);
        return list != null ? list[0] : null;
    }

    private Map<String, WikiParameter[]> getParameters() {
        if (this.fMap == null) {
            this.fMap = new HashMap<String, WikiParameter[]>();
            for (WikiParameter param : this.fList) {
                String key = param.getKey();
                WikiParameter[] list = this.fMap.get(key);
                int len = list != null ? list.length : 0;
                WikiParameter[] newList = new WikiParameter[len + 1];
                if (len > 0) {
                    System.arraycopy(list, 0, newList, 0, len);
                }
                newList[len] = param;
                this.fMap.put(key, newList);
            }
        }
        return this.fMap;
    }

    public WikiParameter[] getParameters(String key) {
        Map<String, WikiParameter[]> map = this.getParameters();
        WikiParameter[] list = map.get(key);
        return list;
    }

    public int getSize() {
        return this.fList.size();
    }

    public int hashCode() {
        return ((Object)this.fList).hashCode();
    }

    public WikiParameters remove(String key) {
        int pos = 0;
        for (WikiParameter param : this.fList) {
            if (key.equals(param.getKey())) break;
            ++pos;
        }
        WikiParameters result = this;
        if (pos < this.fList.size()) {
            result = new WikiParameters(this.fList);
            result.fList.remove(pos);
        }
        return result;
    }

    public List<WikiParameter> toList() {
        ArrayList<WikiParameter> result = new ArrayList<WikiParameter>();
        result.addAll(this.fList);
        return result;
    }

    public String toString() {
        if (this.fStr == null) {
            StringBuffer buf = new StringBuffer();
            int len = this.fList.size();
            int counter = 0;
            for (int i = 0; i < len; ++i) {
                WikiParameter pair = this.fList.get(i);
                if (!pair.isValid()) continue;
                buf.append(" ");
                buf.append(pair);
                ++counter;
            }
            this.fStr = buf.toString();
        }
        return this.fStr;
    }
}

