/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.web;

import org.jboss.seam.web.IncomingPattern;
import org.jboss.seam.web.OutgoingPattern;
import org.jboss.seam.web.Rewrite;
import org.jboss.seam.web.ServletMapping;

public class Pattern {
    String view;
    String pattern;
    ServletMapping viewMapping;
    IncomingPattern inPattern;
    OutgoingPattern outPattern;

    public Pattern(String view, String pattern) {
        this.view = view;
        this.pattern = pattern;
    }

    public void setViewMapping(ServletMapping viewMapping) {
        this.viewMapping = viewMapping;
    }

    protected IncomingPattern inPattern() {
        if (this.inPattern == null) {
            this.inPattern = new IncomingPattern(this.viewMapping, this.view, this.pattern);
        }
        return this.inPattern;
    }

    protected OutgoingPattern outPattern() {
        if (this.outPattern == null) {
            this.outPattern = new OutgoingPattern(this.viewMapping, this.view, this.pattern);
        }
        return this.outPattern;
    }

    public Rewrite matchIncoming(String path) {
        return this.returnIfMatch(this.inPattern().rewrite(path));
    }

    public Rewrite matchOutgoing(String path) {
        return this.returnIfMatch(this.outPattern().rewrite(path));
    }

    public String toString() {
        return "Pattern(" + this.view + ":" + this.pattern + ")";
    }

    private Rewrite returnIfMatch(Rewrite rewrite) {
        return rewrite.isMatch() ? rewrite : null;
    }
}

