/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.syntax;

import org.apache.directory.shared.ldap.schema.syntax.AbstractSyntaxChecker;
import org.apache.directory.shared.ldap.util.StringTools;

public class IntegerSyntaxChecker
extends AbstractSyntaxChecker {
    public IntegerSyntaxChecker() {
        super("1.3.6.1.4.1.1466.115.121.1.27");
    }

    protected IntegerSyntaxChecker(String oid) {
        super(oid);
    }

    public boolean isValidSyntax(Object value) {
        if (value == null) {
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? StringTools.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            return false;
        }
        int pos = 0;
        char c = strValue.charAt(pos);
        if (c == '-') {
            pos = 1;
        } else {
            if (!StringTools.isDigit(c)) {
                return false;
            }
            if (c == '0') {
                return strValue.length() <= 1;
            }
        }
        if (!StringTools.isDigit(strValue, pos)) {
            return false;
        }
        if (StringTools.isCharASCII(strValue, pos, '0')) {
            return false;
        }
        ++pos;
        while (StringTools.isDigit(strValue, pos)) {
            ++pos;
        }
        return pos == strValue.length();
    }
}

