/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authn;

import java.io.Serializable;
import java.security.Principal;
import org.apache.directory.shared.ldap.aci.AuthenticationLevel;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;

public final class LdapPrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = 3906650782395676720L;
    private final LdapDN name;
    public static final LdapPrincipal ANONYMOUS = new LdapPrincipal();
    private final AuthenticationLevel authenticationLevel;
    private byte[] userPassword;

    LdapPrincipal(LdapDN name, AuthenticationLevel authenticationLevel) {
        this.name = name;
        this.authenticationLevel = authenticationLevel;
        this.userPassword = null;
    }

    LdapPrincipal(LdapDN name, AuthenticationLevel authenticationLevel, byte[] userPassword) {
        this.name = name;
        this.authenticationLevel = authenticationLevel;
        this.userPassword = userPassword;
    }

    private LdapPrincipal() {
        this.name = new LdapDN();
        this.authenticationLevel = AuthenticationLevel.NONE;
        this.userPassword = null;
    }

    public LdapDN getJndiName() {
        return (LdapDN)this.name.clone();
    }

    public String getName() {
        return this.name.getNormName();
    }

    public AuthenticationLevel getAuthenticationLevel() {
        return this.authenticationLevel;
    }

    public String toString() {
        return "['" + this.name.getUpName() + "', '" + StringTools.utf8ToString((byte[])this.userPassword) + "']'";
    }

    public byte[] getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(byte[] userPassword) {
        this.userPassword = userPassword;
    }
}

