/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DirectoryFieldMapper {
    private final Map<String, String> fieldMapping;

    public DirectoryFieldMapper(Map<String, String> fieldMapping) {
        this.fieldMapping = fieldMapping;
    }

    public DirectoryFieldMapper() {
        this.fieldMapping = new HashMap<String, String>();
    }

    public String getBackendField(String fieldName) {
        String backendField = this.fieldMapping.get(fieldName);
        if (backendField != null) {
            return backendField;
        }
        return fieldName;
    }

    public String getDirectoryField(String backEndFieldName) {
        if (this.fieldMapping.containsValue(backEndFieldName)) {
            for (String key : this.fieldMapping.keySet()) {
                if (!this.fieldMapping.get(key).equals(backEndFieldName)) continue;
                return key;
            }
        }
        return backEndFieldName;
    }

    public Set<String> getBackendFields(Set<String> fieldNames) {
        HashSet<String> mappedFields = new HashSet<String>();
        for (String fieldName : fieldNames) {
            mappedFields.add(this.getBackendField(fieldName));
        }
        return mappedFields;
    }
}

