/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.ArrayCharList;
import org.apache.commons.collections.primitives.CharIterator;
import org.apache.commons.collections.primitives.CharList;
import org.apache.commons.collections.primitives.CharListIterator;
import org.apache.commons.collections.primitives.decorators.UnmodifiableCharIterator;
import org.apache.commons.collections.primitives.decorators.UnmodifiableCharList;
import org.apache.commons.collections.primitives.decorators.UnmodifiableCharListIterator;

public final class CharCollections {
    public static final CharList EMPTY_CHAR_LIST = CharCollections.unmodifiableCharList(new ArrayCharList(0));
    public static final CharIterator EMPTY_CHAR_ITERATOR = CharCollections.unmodifiableCharIterator(EMPTY_CHAR_LIST.iterator());
    public static final CharListIterator EMPTY_CHAR_LIST_ITERATOR = CharCollections.unmodifiableCharListIterator(EMPTY_CHAR_LIST.listIterator());

    private CharCollections() {
    }

    @Nonnull
    public static CharList singletonCharList(char c) {
        ArrayCharList arrayCharList = new ArrayCharList(1);
        arrayCharList.add(c);
        return UnmodifiableCharList.wrap(arrayCharList);
    }

    @Nonnull
    public static CharIterator singletonCharIterator(char c) {
        return CharCollections.singletonCharList(c).iterator();
    }

    @Nonnull
    public static CharListIterator singletonCharListIterator(char c) {
        return CharCollections.singletonCharList(c).listIterator();
    }

    @Nonnull
    public static CharList unmodifiableCharList(@Nonnull CharList charList) throws NullPointerException {
        if (null == charList) {
            throw new NullPointerException();
        }
        return UnmodifiableCharList.wrap(charList);
    }

    @Nonnull
    public static CharIterator unmodifiableCharIterator(@Nonnull CharIterator charIterator) {
        if (null == charIterator) {
            throw new NullPointerException();
        }
        return UnmodifiableCharIterator.wrap(charIterator);
    }

    @Nonnull
    public static CharListIterator unmodifiableCharListIterator(@Nonnull CharListIterator charListIterator) {
        if (null == charListIterator) {
            throw new NullPointerException();
        }
        return UnmodifiableCharListIterator.wrap(charListIterator);
    }

    @Nonnull
    public static CharList getEmptyCharList() {
        return EMPTY_CHAR_LIST;
    }

    @Nonnull
    public static CharIterator getEmptyCharIterator() {
        return EMPTY_CHAR_ITERATOR;
    }

    @Nonnull
    public static CharListIterator getEmptyCharListIterator() {
        return EMPTY_CHAR_LIST_ITERATOR;
    }
}

