/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.ShortCollection;
import org.apache.commons.collections.primitives.ShortIterator;
import org.apache.commons.collections.primitives.ShortList;
import org.apache.commons.collections.primitives.ShortListIterator;
import org.apache.commons.collections.primitives.adapters.AbstractCollectionShortCollection;
import org.apache.commons.collections.primitives.adapters.ListIteratorShortListIterator;
import org.apache.commons.collections.primitives.adapters.ListShortList;
import org.apache.commons.collections.primitives.adapters.ShortCollectionCollection;

abstract class AbstractListShortList
extends AbstractCollectionShortCollection
implements ShortList {
    AbstractListShortList() {
    }

    @Override
    @Nonnull
    protected final Collection<Short> getCollection() {
        return this.getList();
    }

    @Nonnull
    protected abstract List<Short> getList();

    @Override
    public void add(int n, short s) {
        this.getList().add(n, s);
    }

    @Override
    public boolean addAll(int n, @Nonnull ShortCollection shortCollection) {
        return this.getList().addAll(n, ShortCollectionCollection.wrap(shortCollection));
    }

    @Override
    public short get(int n) {
        return this.getList().get(n);
    }

    @Override
    public int indexOf(short s) {
        return this.getList().indexOf(s);
    }

    @Override
    public int lastIndexOf(short s) {
        return this.getList().lastIndexOf(s);
    }

    @Override
    @Nonnull
    public ShortListIterator listIterator() {
        return ListIteratorShortListIterator.wrap(this.getList().listIterator());
    }

    @Override
    @Nonnull
    public ShortListIterator listIterator(int n) {
        return ListIteratorShortListIterator.wrap(this.getList().listIterator(n));
    }

    @Override
    public short removeElementAt(int n) {
        return this.getList().remove(n);
    }

    @Override
    public short set(int n, short s) {
        return this.getList().set(n, s);
    }

    @Override
    @Nonnull
    public ShortList subList(int n, int n2) {
        return ListShortList.wrap(this.getList().subList(n, n2));
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ShortList)) {
            return false;
        }
        ShortList shortList = (ShortList)object;
        if (this.size() != shortList.size()) {
            return false;
        }
        ShortIterator shortIterator = this.iterator();
        ShortIterator shortIterator2 = shortList.iterator();
        while (shortIterator.hasNext()) {
            if (shortIterator.next() == shortIterator2.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return ((Object)this.getList()).hashCode();
    }
}

