/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition;

import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.configuration.PartitionConfiguration;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.ReplaceOperationContext;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.shared.ldap.name.LdapDN;

public abstract class AbstractPartition
implements Partition {
    private DirectoryServiceConfiguration factoryCfg;
    private PartitionConfiguration cfg;
    private boolean initialized;
    private LdapDN suffixDn;

    protected AbstractPartition() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init(DirectoryServiceConfiguration factoryCfg, PartitionConfiguration cfg) throws NamingException {
        if (this.initialized) {
            return;
        }
        this.factoryCfg = factoryCfg;
        this.cfg = cfg;
        try {
            this.doInit();
            this.initialized = true;
        }
        finally {
            if (!this.initialized) {
                this.destroy();
            }
        }
    }

    protected void doInit() throws NamingException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        if (this.cfg == null) {
            return;
        }
        try {
            this.doDestroy();
        }
        finally {
            this.initialized = false;
            this.factoryCfg = null;
            this.cfg = null;
        }
    }

    protected void doDestroy() {
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    public final DirectoryServiceConfiguration getFactoryConfiguration() {
        return this.factoryCfg;
    }

    public final PartitionConfiguration getConfiguration() {
        return this.cfg;
    }

    public final LdapDN getSuffix() throws NamingException {
        if (this.suffixDn == null) {
            this.suffixDn = new LdapDN(this.cfg.getSuffix());
            this.suffixDn.normalize(this.factoryCfg.getRegistries().getAttributeTypeRegistry().getNormalizerMapping());
        }
        return this.suffixDn;
    }

    public void sync() throws NamingException {
    }

    public boolean hasEntry(EntryOperationContext entryContext) throws NamingException {
        try {
            return this.lookup(new LookupOperationContext(entryContext.getDn())) != null;
        }
        catch (NameNotFoundException e) {
            return false;
        }
    }

    public Attributes lookup(LookupOperationContext lookupContext) throws NamingException {
        return null;
    }

    public void move(LdapDN oldName, LdapDN newParentName, String newRdn, boolean deleteOldRn) throws NamingException {
        LdapDN newName = (LdapDN)newParentName.clone();
        newName.add(newRdn);
        this.move(new MoveOperationContext(oldName, newParentName));
        this.rename(new RenameOperationContext(newName, newRdn, deleteOldRn));
    }

    public void replace(ReplaceOperationContext replaceContext) throws NamingException {
        throw new OperationNotSupportedException("Moving an entry to other parent entry is not supported.");
    }
}

