/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.aci;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.aci.AuthenticationLevel;
import org.apache.directory.shared.ldap.aci.GrantAndDenial;
import org.apache.directory.shared.ldap.aci.MicroOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ACIItem
implements Serializable {
    private String identificationTag;
    private int precedence = 0;
    private AuthenticationLevel authenticationLevel;

    protected ACIItem(String identificationTag, int precedence, AuthenticationLevel authenticationLevel) {
        if (identificationTag == null) {
            throw new NullPointerException("identificationTag");
        }
        if (precedence < 0 || precedence > 255) {
            throw new IllegalArgumentException("precedence: " + precedence);
        }
        if (authenticationLevel == null) {
            throw new NullPointerException("authenticationLevel");
        }
        this.identificationTag = identificationTag;
        this.precedence = precedence;
        this.authenticationLevel = authenticationLevel;
    }

    public String getIdentificationTag() {
        return this.identificationTag;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public AuthenticationLevel getAuthenticationLevel() {
        return this.authenticationLevel;
    }

    public abstract Collection<ACITuple> toTuples();

    public abstract void printToBuffer(StringBuffer var1);

    protected static Set toMicroOperations(Set grantsAndDenials) {
        HashSet<MicroOperation> microOps = new HashSet<MicroOperation>();
        Iterator j = grantsAndDenials.iterator();
        while (j.hasNext()) {
            microOps.add(((GrantAndDenial)j.next()).getMicroOperation());
        }
        return microOps;
    }
}

