/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.decorators;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.CharIterator;
import org.apache.commons.collections.primitives.decorators.ProxyCharIterator;

public final class UnmodifiableCharIterator
extends ProxyCharIterator {
    private CharIterator m_aProxied;

    UnmodifiableCharIterator(@Nonnull CharIterator charIterator) {
        this.m_aProxied = charIterator;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This CharIterator is not modifiable.");
    }

    @Override
    @Nonnull
    protected CharIterator getIterator() {
        return this.m_aProxied;
    }

    @Nullable
    public static final CharIterator wrap(@Nullable CharIterator charIterator) {
        if (null == charIterator) {
            return null;
        }
        if (charIterator instanceof UnmodifiableCharIterator) {
            return charIterator;
        }
        return new UnmodifiableCharIterator(charIterator);
    }
}

