/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.support.query;

import java.util.ArrayList;
import org.antlr.runtime.tree.Tree;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.server.support.query.CalendarHelper;
import org.apache.chemistry.opencmis.server.support.query.PredicateWalker;

public abstract class AbstractPredicateWalker
implements PredicateWalker {
    @Override
    public Boolean walkPredicate(Tree node) {
        switch (node.getType()) {
            case 43: {
                return this.walkNot(node, node.getChild(0));
            }
            case 4: {
                return this.walkAnd(node, node.getChild(0), node.getChild(1));
            }
            case 50: {
                return this.walkOr(node, node.getChild(0), node.getChild(1));
            }
            case 19: {
                return this.walkEquals(node, node.getChild(0), node.getChild(1));
            }
            case 42: {
                return this.walkNotEquals(node, node.getChild(0), node.getChild(1));
            }
            case 24: {
                return this.walkGreaterThan(node, node.getChild(0), node.getChild(1));
            }
            case 25: {
                return this.walkGreaterOrEquals(node, node.getChild(0), node.getChild(1));
            }
            case 40: {
                return this.walkLessThan(node, node.getChild(0), node.getChild(1));
            }
            case 41: {
                return this.walkLessOrEquals(node, node.getChild(0), node.getChild(1));
            }
            case 27: {
                return this.walkIn(node, node.getChild(0), node.getChild(1));
            }
            case 44: {
                return this.walkNotIn(node, node.getChild(0), node.getChild(1));
            }
            case 29: {
                return this.walkInAny(node, node.getChild(0), node.getChild(1));
            }
            case 45: {
                return this.walkNotInAny(node, node.getChild(0), node.getChild(1));
            }
            case 20: {
                return this.walkEqAny(node, node.getChild(0), node.getChild(1));
            }
            case 35: {
                return this.walkIsNull(node, node.getChild(0));
            }
            case 34: {
                return this.walkIsNotNull(node, node.getChild(0));
            }
            case 38: {
                return this.walkLike(node, node.getChild(0), node.getChild(1));
            }
            case 46: {
                return this.walkNotLike(node, node.getChild(0), node.getChild(1));
            }
            case 14: {
                if (node.getChildCount() == 1) {
                    return this.walkContains(node, null, node.getChild(0));
                }
                return this.walkContains(node, node.getChild(0), node.getChild(1));
            }
            case 30: {
                if (node.getChildCount() == 1) {
                    return this.walkInFolder(node, null, node.getChild(0));
                }
                return this.walkInFolder(node, node.getChild(0), node.getChild(1));
            }
            case 32: {
                if (node.getChildCount() == 1) {
                    return this.walkInTree(node, null, node.getChild(0));
                }
                return this.walkInTree(node, node.getChild(0), node.getChild(1));
            }
            case 10: {
                this.walkBoolean(node);
                return false;
            }
            case 48: {
                this.walkNumber(node);
                return false;
            }
            case 62: {
                this.walkString(node);
                return false;
            }
            case 66: {
                this.walkTimestamp(node);
                return false;
            }
            case 31: {
                this.walkList(node);
                return false;
            }
            case 12: {
                this.walkCol(node);
                return false;
            }
            case 26: {
                this.walkId(node);
                return false;
            }
            case 58: {
                return this.walkScore(node);
            }
        }
        return this.walkOtherPredicate(node);
    }

    protected Boolean walkOtherPredicate(Tree node) {
        throw new CmisRuntimeException("Unknown node type: " + node.getType() + " (" + node.getText() + ")");
    }

    @Override
    public Boolean walkNot(Tree opNode, Tree node) {
        this.walkPredicate(node);
        return false;
    }

    @Override
    public Boolean walkAnd(Tree opNode, Tree leftNode, Tree rightNode) {
        this.walkPredicate(leftNode);
        this.walkPredicate(rightNode);
        return false;
    }

    @Override
    public Boolean walkOr(Tree opNode, Tree leftNode, Tree rightNode) {
        this.walkPredicate(leftNode);
        this.walkPredicate(rightNode);
        return false;
    }

    @Override
    public Object walkExpr(Tree node) {
        switch (node.getType()) {
            case 10: {
                return this.walkBoolean(node);
            }
            case 48: {
                return this.walkNumber(node);
            }
            case 62: {
                return this.walkString(node);
            }
            case 66: {
                return this.walkTimestamp(node);
            }
            case 31: {
                return this.walkList(node);
            }
            case 12: {
                return this.walkCol(node);
            }
            case 26: {
                return this.walkId(node);
            }
        }
        return this.walkOtherExpr(node);
    }

    public Boolean walkSearchExpr(Tree node) {
        switch (node.getType()) {
            case 10: {
                return this.walkTextAnd(node);
            }
            case 12: {
                return this.walkTextOr(node);
            }
            case 11: {
                return this.walkTextMinus(node);
            }
            case 15: {
                return this.walkTextWord(node);
            }
            case 14: {
                return this.walkTextPhrase(node);
            }
        }
        this.walkOtherExpr(node);
        return null;
    }

    protected Object walkOtherExpr(Tree node) {
        throw new CmisRuntimeException("Unknown node type: " + node.getType() + " (" + node.getText() + ")");
    }

    @Override
    public Boolean walkEquals(Tree opNode, Tree leftNode, Tree rightNode) {
        this.walkExpr(leftNode);
        this.walkExpr(rightNode);
        return false;
    }

    @Override
    public Boolean walkNotEquals(Tree opNode, Tree leftNode, Tree rightNode) {
        this.walkExpr(leftNode);
        this.walkExpr(rightNode);
        return false;
    }

    @Override
    public Boolean walkGreaterThan(Tree opNode, Tree leftNode, Tree rightNode) {
        this.walkExpr(leftNode);
        this.walkExpr(rightNode);
        return false;
    }

    @Override
    public Boolean walkGreaterOrEquals(Tree opNode, Tree leftNode, Tree rightNode) {
        this.walkExpr(leftNode);
        this.walkExpr(rightNode);
        return false;
    }

    @Override
    public Boolean walkLessThan(Tree opNode, Tree leftNode, Tree rightNode) {
        this.walkExpr(leftNode);
        this.walkExpr(rightNode);
        return false;
    }

    @Override
    public Boolean walkLessOrEquals(Tree opNode, Tree leftNode, Tree rightNode) {
        this.walkExpr(leftNode);
        this.walkExpr(rightNode);
        return false;
    }

    @Override
    public Boolean walkIn(Tree opNode, Tree colNode, Tree listNode) {
        this.walkExpr(colNode);
        this.walkExpr(listNode);
        return false;
    }

    @Override
    public Boolean walkNotIn(Tree opNode, Tree colNode, Tree listNode) {
        this.walkExpr(colNode);
        this.walkExpr(listNode);
        return false;
    }

    @Override
    public Boolean walkInAny(Tree opNode, Tree colNode, Tree listNode) {
        this.walkExpr(colNode);
        this.walkExpr(listNode);
        return false;
    }

    @Override
    public Boolean walkNotInAny(Tree opNode, Tree colNode, Tree listNode) {
        this.walkExpr(colNode);
        this.walkExpr(listNode);
        return false;
    }

    @Override
    public Boolean walkEqAny(Tree opNode, Tree literalNode, Tree colNode) {
        this.walkExpr(literalNode);
        this.walkExpr(colNode);
        return false;
    }

    @Override
    public Boolean walkIsNull(Tree opNode, Tree colNode) {
        this.walkExpr(colNode);
        return false;
    }

    @Override
    public Boolean walkIsNotNull(Tree opNode, Tree colNode) {
        this.walkExpr(colNode);
        return false;
    }

    @Override
    public Boolean walkLike(Tree opNode, Tree colNode, Tree stringNode) {
        this.walkExpr(colNode);
        this.walkExpr(stringNode);
        return false;
    }

    @Override
    public Boolean walkNotLike(Tree opNode, Tree colNode, Tree stringNode) {
        this.walkExpr(colNode);
        this.walkExpr(stringNode);
        return false;
    }

    @Override
    public Boolean walkContains(Tree opNode, Tree qualNode, Tree queryNode) {
        if (qualNode != null) {
            return this.walkSearchExpr(qualNode);
        }
        return this.walkSearchExpr(queryNode);
    }

    @Override
    public Boolean walkInFolder(Tree opNode, Tree qualNode, Tree paramNode) {
        if (qualNode != null) {
            this.walkExpr(qualNode);
        }
        this.walkExpr(paramNode);
        return false;
    }

    @Override
    public Boolean walkInTree(Tree opNode, Tree qualNode, Tree paramNode) {
        if (qualNode != null) {
            this.walkExpr(qualNode);
        }
        this.walkExpr(paramNode);
        return false;
    }

    @Override
    public Object walkList(Tree node) {
        int n = node.getChildCount();
        ArrayList<Object> res = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            res.add(this.walkExpr(node.getChild(i)));
        }
        return res;
    }

    @Override
    public Object walkBoolean(Tree node) {
        String s = node.getText();
        return Boolean.valueOf(s);
    }

    @Override
    public Object walkNumber(Tree node) {
        String s = node.getText();
        if (s.contains(".") || s.contains("e") || s.contains("E")) {
            return Double.valueOf(s);
        }
        return Long.valueOf(s);
    }

    @Override
    public Object walkString(Tree node) {
        String s = node.getText();
        s = s.substring(1, s.length() - 1);
        s = s.replace("''", "'");
        return s;
    }

    @Override
    public Object walkTimestamp(Tree node) {
        String s = node.getText();
        s = s.substring(s.indexOf(39) + 1, s.length() - 1);
        return CalendarHelper.fromString(s);
    }

    @Override
    public Object walkCol(Tree node) {
        return null;
    }

    @Override
    public Object walkId(Tree node) {
        return null;
    }

    protected Boolean walkTextAnd(Tree node) {
        return null;
    }

    protected Boolean walkTextOr(Tree node) {
        return null;
    }

    protected Boolean walkTextMinus(Tree node) {
        return null;
    }

    protected Boolean walkTextWord(Tree node) {
        return null;
    }

    protected Boolean walkTextPhrase(Tree node) {
        return null;
    }

    protected Boolean walkScore(Tree node) {
        return false;
    }
}

