/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests;

import java.util.List;
import net.jsourcerer.webdriver.jserrorcollector.JavaScriptError;
import org.junit.Assert;
import org.openqa.selenium.WebDriver;

public class JavaScriptErrorCollector {
    protected final WebDriver driver;

    public JavaScriptErrorCollector(WebDriver driver) {
        this.driver = driver;
    }

    public void checkForErrors() {
        List jsErrors;
        if (this.driver != null && (jsErrors = JavaScriptError.readErrors((WebDriver)this.driver)) != null && !jsErrors.isEmpty()) {
            StringBuilder msg = new StringBuilder();
            int i = 0;
            for (JavaScriptError jsError : jsErrors) {
                String error = jsError.getErrorMessage();
                if (error != null && error.startsWith("mutating the [[Prototype]] of an object")) continue;
                if (i != 0) {
                    msg.append(", ");
                }
                ++i;
                msg.append("\"").append(error).append("\"");
                msg.append(" at ").append(jsError.getSourceName());
                msg.append(" line ").append(jsError.getLineNumber());
            }
            if (i > 0) {
                msg.append("]");
                msg.insert(0, jsErrors.size() + " Javascript error(s) detected: [");
                Assert.fail((String)msg.toString());
            }
        }
    }
}

