/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.functionaltests.ScreenShotFileOutput;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;

public class ScreenshotTaker {
    private static final Log log = LogFactory.getLog(ScreenshotTaker.class);
    protected final String targetDirName;

    public ScreenshotTaker() {
        this(null);
    }

    public ScreenshotTaker(String targetDirName) {
        this.targetDirName = targetDirName;
    }

    public File takeScreenshot(WebDriver driver, String filename) {
        if (driver == null) {
            return null;
        }
        if (TakesScreenshot.class.isInstance(driver)) {
            try {
                Thread.sleep(250L);
                String name = filename;
                return (File)((TakesScreenshot)TakesScreenshot.class.cast(driver)).getScreenshotAs((OutputType)new ScreenShotFileOutput(this.targetDirName, name));
            }
            catch (InterruptedException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        return null;
    }

    public File dumpPageSource(WebDriver driver, String filename) {
        File file;
        if (driver == null) {
            return null;
        }
        FileWriter writer = null;
        try {
            String location = System.getProperty("basedir") + File.separator + "target";
            File outputFolder = new File(location);
            if (!outputFolder.exists() || !outputFolder.isDirectory()) {
                outputFolder = null;
            }
            if (outputFolder != null && !StringUtils.isBlank((String)this.targetDirName)) {
                outputFolder = new File(outputFolder, this.targetDirName);
                outputFolder.mkdir();
            }
            File tmpFile = File.createTempFile(filename, ".html", outputFolder);
            log.trace((Object)String.format("Created page source file named '%s'", tmpFile.getPath()));
            writer = new FileWriter(tmpFile);
            writer.write(driver.getPageSource());
            file = tmpFile;
        }
        catch (IOException e) {
            try {
                throw new WebDriverException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
        return file;
    }
}

